/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster;

import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.CountDownLatch;
import java.util.function.Consumer;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.node.stats.NodeStats;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsResponse;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsResponse;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.cluster.ClusterInfo;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.DiskUsage;
import org.elasticsearch.cluster.InternalClusterInfoService;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.monitor.fs.FsInfo;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.threadpool.ThreadPool;

public class MockInternalClusterInfoService
extends InternalClusterInfoService {
    private final ClusterName clusterName;
    private volatile NodeStats[] stats = new NodeStats[3];

    public static NodeStats makeStats(String nodeName, DiskUsage usage) {
        FsInfo.Path path = new FsInfo.Path("/dev/null", null, usage.getTotalBytes(), usage.getFreeBytes(), usage.getFreeBytes());
        FsInfo.Path[] paths = new FsInfo.Path[]{path};
        FsInfo fsInfo = new FsInfo(System.currentTimeMillis(), null, paths);
        return new NodeStats(new DiscoveryNode(nodeName, ESTestCase.buildNewFakeTransportAddress(), Collections.emptyMap(), Collections.emptySet(), Version.CURRENT), System.currentTimeMillis(), null, null, null, null, null, fsInfo, null, null, null, null, null, null, null);
    }

    public MockInternalClusterInfoService(Settings settings, ClusterService clusterService, ThreadPool threadPool, NodeClient client, Consumer<ClusterInfo> listener) {
        super(settings, clusterService, threadPool, client, listener);
        this.clusterName = (ClusterName)ClusterName.CLUSTER_NAME_SETTING.get(settings);
        this.stats[0] = MockInternalClusterInfoService.makeStats("node_t1", new DiskUsage("node_t1", "n1", "/dev/null", 100L, 100L));
        this.stats[1] = MockInternalClusterInfoService.makeStats("node_t2", new DiskUsage("node_t2", "n2", "/dev/null", 100L, 100L));
        this.stats[2] = MockInternalClusterInfoService.makeStats("node_t3", new DiskUsage("node_t3", "n3", "/dev/null", 100L, 100L));
    }

    public void setN1Usage(String nodeName, DiskUsage newUsage) {
        this.stats[0] = MockInternalClusterInfoService.makeStats(nodeName, newUsage);
    }

    public void setN2Usage(String nodeName, DiskUsage newUsage) {
        this.stats[1] = MockInternalClusterInfoService.makeStats(nodeName, newUsage);
    }

    public void setN3Usage(String nodeName, DiskUsage newUsage) {
        this.stats[2] = MockInternalClusterInfoService.makeStats(nodeName, newUsage);
    }

    public CountDownLatch updateNodeStats(ActionListener<NodesStatsResponse> listener) {
        NodesStatsResponse response = new NodesStatsResponse(this.clusterName, Arrays.asList(this.stats), Collections.emptyList());
        listener.onResponse((Object)response);
        return new CountDownLatch(0);
    }

    public CountDownLatch updateIndicesStats(ActionListener<IndicesStatsResponse> listener) {
        return new CountDownLatch(0);
    }

    public ClusterInfo getClusterInfo() {
        ClusterInfo clusterInfo = super.getClusterInfo();
        return new DevNullClusterInfo((ImmutableOpenMap<String, DiskUsage>)clusterInfo.getNodeLeastAvailableDiskUsages(), (ImmutableOpenMap<String, DiskUsage>)clusterInfo.getNodeMostAvailableDiskUsages(), (ImmutableOpenMap<String, Long>)clusterInfo.shardSizes);
    }

    public void setUpdateFrequency(TimeValue updateFrequency) {
        super.setUpdateFrequency(updateFrequency);
    }

    public static class DevNullClusterInfo
    extends ClusterInfo {
        public DevNullClusterInfo(ImmutableOpenMap<String, DiskUsage> leastAvailableSpaceUsage, ImmutableOpenMap<String, DiskUsage> mostAvailableSpaceUsage, ImmutableOpenMap<String, Long> shardSizes) {
            super(leastAvailableSpaceUsage, mostAvailableSpaceUsage, shardSizes, null);
        }

        public String getDataPath(ShardRouting shardRouting) {
            return "/dev/null";
        }
    }

    public static class TestPlugin
    extends Plugin {
    }
}

