/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.support;

import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.ElasticsearchTimeoutException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.UnavailableShardsException;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.IndicesAdminClient;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.cluster.health.ClusterIndexHealth;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.ReservedStateMetadata;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.features.FeatureService;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.gateway.GatewayService;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.indices.IndexClosedException;
import org.elasticsearch.indices.SystemIndexDescriptor;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.Scheduler;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.security.authz.RoleMappingMetadata;
import org.elasticsearch.xpack.security.SecurityFeatures;
import org.elasticsearch.xpack.security.support.SecurityMigrations;
import org.elasticsearch.xpack.security.support.SecuritySystemIndices;

public class SecurityIndexManager
implements ClusterStateListener {
    public static final String SECURITY_VERSION_STRING = "security-version";
    protected static final String FILE_SETTINGS_METADATA_NAMESPACE = "file_settings";
    private static final Logger logger = LogManager.getLogger(SecurityIndexManager.class);
    private final Client client;
    private final SystemIndexDescriptor systemIndexDescriptor;
    private final List<BiConsumer<State, State>> stateChangeListeners = new CopyOnWriteArrayList<BiConsumer<State, State>>();
    private volatile State state;
    private final boolean defensiveCopy;
    private final FeatureService featureService;
    private final Set<NodeFeature> allSecurityFeatures = new SecurityFeatures().getFeatures();

    public static SecurityIndexManager buildSecurityIndexManager(Client client, ClusterService clusterService, FeatureService featureService, SystemIndexDescriptor descriptor) {
        SecurityIndexManager securityIndexManager = new SecurityIndexManager(featureService, client, descriptor, State.UNRECOVERED_STATE, false);
        clusterService.addListener((ClusterStateListener)securityIndexManager);
        return securityIndexManager;
    }

    private SecurityIndexManager(FeatureService featureService, Client client, SystemIndexDescriptor descriptor, State state, boolean defensiveCopy) {
        this.featureService = featureService;
        this.client = client;
        this.state = state;
        this.systemIndexDescriptor = descriptor;
        this.defensiveCopy = defensiveCopy;
    }

    public SecurityIndexManager defensiveCopy() {
        return new SecurityIndexManager(null, null, this.systemIndexDescriptor, this.state, true);
    }

    public String aliasName() {
        return this.systemIndexDescriptor.getAliasName();
    }

    public boolean indexExists() {
        return this.state.indexExists();
    }

    public boolean indexIsClosed() {
        return this.state.indexState == IndexMetadata.State.CLOSE;
    }

    public Instant getCreationTime() {
        return this.state.creationTime;
    }

    public boolean isIndexUpToDate() {
        return this.state.isIndexUpToDate;
    }

    public boolean isAvailable(Availability availability) {
        switch (availability) {
            case SEARCH_SHARDS: {
                return this.state.indexAvailableForSearch;
            }
            case PRIMARY_SHARDS: {
                return this.state.indexAvailableForWrite;
            }
        }
        throw new IllegalStateException("Unexpected availability enumeration. This is bug, please contact support.");
    }

    public boolean isMappingUpToDate() {
        return this.state.mappingUpToDate;
    }

    public boolean isStateRecovered() {
        return this.state != State.UNRECOVERED_STATE;
    }

    public boolean isMigrationsVersionAtLeast(Integer expectedMigrationsVersion) {
        return this.indexExists() && this.state.migrationsVersion.compareTo(expectedMigrationsVersion) >= 0;
    }

    public ElasticsearchException getUnavailableReason(Availability availability) {
        if (!this.defensiveCopy) {
            throw new IllegalStateException("caller must make sure to use a defensive copy");
        }
        State state = this.state;
        if (state.indexState == IndexMetadata.State.CLOSE) {
            return new IndexClosedException(new Index(state.concreteIndexName, "_na_"));
        }
        if (state.indexExists()) {
            assert (!state.indexAvailableForSearch || !state.indexAvailableForWrite);
            if (Availability.PRIMARY_SHARDS.equals((Object)availability) && !state.indexAvailableForWrite) {
                return new UnavailableShardsException(null, "at least one primary shard for the index [" + state.concreteIndexName + "] is unavailable", new Object[0]);
            }
            if (Availability.SEARCH_SHARDS.equals((Object)availability) && !state.indexAvailableForSearch) {
                return new UnavailableShardsException(null, "at least one search shard for the index [" + state.concreteIndexName + "] is unavailable", new Object[0]);
            }
            throw new IllegalStateException("caller must ensure original availability matches the current availability");
        }
        return new IndexNotFoundException(state.concreteIndexName);
    }

    public void addStateListener(BiConsumer<State, State> listener) {
        this.stateChangeListeners.add(listener);
    }

    public void removeStateListener(BiConsumer<State, State> listener) {
        this.stateChangeListeners.remove(listener);
    }

    private SystemIndexDescriptor.MappingsVersion getMinSecurityIndexMappingVersion(ClusterState clusterState) {
        SystemIndexDescriptor.MappingsVersion mappingsVersion = (SystemIndexDescriptor.MappingsVersion)clusterState.getMinSystemIndexMappingVersions().get(this.systemIndexDescriptor.getPrimaryIndex());
        return mappingsVersion == null ? new SystemIndexDescriptor.MappingsVersion(1, 0) : mappingsVersion;
    }

    private static boolean isCreatedOnLatestVersion(IndexMetadata indexMetadata) {
        IndexVersion indexVersionCreated = indexMetadata != null ? (IndexVersion)IndexMetadata.SETTING_INDEX_VERSION_CREATED.get(indexMetadata.getSettings()) : null;
        return indexVersionCreated != null && indexVersionCreated.onOrAfter((VersionId)IndexVersion.current());
    }

    static RoleMappingsCleanupMigrationStatus getRoleMappingsCleanupMigrationStatus(ClusterState clusterState, int migrationsVersion) {
        boolean hasFileSettingsMetadata;
        if (migrationsVersion >= SecurityMigrations.CLEANUP_ROLE_MAPPING_DUPLICATES_MIGRATION_VERSION) {
            return RoleMappingsCleanupMigrationStatus.DONE;
        }
        ReservedStateMetadata fileSettingsMetadata = (ReservedStateMetadata)clusterState.metadata().reservedStateMetadata().get(FILE_SETTINGS_METADATA_NAMESPACE);
        boolean bl = hasFileSettingsMetadata = fileSettingsMetadata != null;
        assert (hasFileSettingsMetadata || clusterState.metadata().reservedStateMetadata().isEmpty()) : "ReservedStateMetadata contains unknown namespace";
        if (!hasFileSettingsMetadata || fileSettingsMetadata.keys("role_mappings").isEmpty()) {
            return RoleMappingsCleanupMigrationStatus.SKIP;
        }
        RoleMappingMetadata roleMappingMetadata = RoleMappingMetadata.getFromClusterState((ClusterState)clusterState);
        if (roleMappingMetadata.getRoleMappings().size() == fileSettingsMetadata.keys("role_mappings").size() && !roleMappingMetadata.hasAnyMappingWithFallbackName()) {
            return RoleMappingsCleanupMigrationStatus.READY;
        }
        return RoleMappingsCleanupMigrationStatus.NOT_READY;
    }

    public RoleMappingsCleanupMigrationStatus getRoleMappingsCleanupMigrationStatus() {
        return this.state.roleMappingsCleanupMigrationStatus;
    }

    public void clusterChanged(ClusterChangedEvent event) {
        State newState;
        ClusterHealthStatus indexHealth;
        IndexMetadata.State indexState;
        String concreteIndexName;
        if (event.state().blocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK)) {
            logger.debug("security index manager waiting until state has been recovered");
            return;
        }
        State previousState = this.state;
        IndexMetadata indexMetadata = SecurityIndexManager.resolveConcreteIndex(this.systemIndexDescriptor.getAliasName(), event.state().metadata());
        boolean createdOnLatestVersion = SecurityIndexManager.isCreatedOnLatestVersion(indexMetadata);
        Instant creationTime = indexMetadata != null ? Instant.ofEpochMilli(indexMetadata.getCreationDate()) : null;
        boolean isIndexUpToDate = indexMetadata == null || ((Integer)IndexMetadata.INDEX_FORMAT_SETTING.get(indexMetadata.getSettings())).intValue() == this.systemIndexDescriptor.getIndexFormat();
        Tuple<Boolean, Boolean> available = this.checkIndexAvailable(event.state());
        boolean indexAvailableForWrite = (Boolean)available.v1();
        boolean indexAvailableForSearch = (Boolean)available.v2();
        int migrationsVersion = SecurityIndexManager.getMigrationVersionFromIndexMetadata(indexMetadata);
        RoleMappingsCleanupMigrationStatus roleMappingsCleanupMigrationStatus = SecurityIndexManager.getRoleMappingsCleanupMigrationStatus(event.state(), migrationsVersion);
        boolean mappingIsUpToDate = indexMetadata == null || this.checkIndexMappingUpToDate(event.state());
        SystemIndexDescriptor.MappingsVersion minClusterMappingVersion = this.getMinSecurityIndexMappingVersion(event.state());
        int indexMappingVersion = SecurityIndexManager.loadIndexMappingVersion(this.systemIndexDescriptor.getAliasName(), event.state());
        String string = concreteIndexName = indexMetadata == null ? this.systemIndexDescriptor.getPrimaryIndex() : indexMetadata.getIndex().getName();
        if (indexMetadata == null) {
            indexState = null;
            indexHealth = null;
        } else if (indexMetadata.getState() == IndexMetadata.State.CLOSE) {
            indexState = IndexMetadata.State.CLOSE;
            indexHealth = null;
            logger.warn("Index [{}] is closed. This is likely to prevent security from functioning correctly", (Object)concreteIndexName);
        } else {
            indexState = IndexMetadata.State.OPEN;
            IndexRoutingTable routingTable = event.state().getRoutingTable().index(indexMetadata.getIndex());
            indexHealth = new ClusterIndexHealth(indexMetadata, routingTable).getStatus();
        }
        String indexUUID = indexMetadata != null ? indexMetadata.getIndexUUID() : null;
        this.state = newState = new State(creationTime, isIndexUpToDate, indexAvailableForSearch, indexAvailableForWrite, mappingIsUpToDate, createdOnLatestVersion, roleMappingsCleanupMigrationStatus, migrationsVersion, minClusterMappingVersion, indexMappingVersion, concreteIndexName, indexHealth, indexState, indexUUID, this.allSecurityFeatures.stream().filter(feature -> this.featureService.clusterHasFeature(event.state(), feature)).collect(Collectors.toSet()));
        if (!newState.equals(previousState)) {
            for (BiConsumer<State, State> listener : this.stateChangeListeners) {
                listener.accept(previousState, newState);
            }
        }
    }

    public static int getMigrationVersionFromIndexMetadata(IndexMetadata indexMetadata) {
        Map customMetadata;
        Map map = customMetadata = indexMetadata == null ? null : indexMetadata.getCustomData("migration_version");
        if (customMetadata == null) {
            return 0;
        }
        String migrationVersion = (String)customMetadata.get("version");
        return migrationVersion == null ? 0 : Integer.parseInt(migrationVersion);
    }

    public void onStateRecovered(final Consumer<State> recoveredStateConsumer) {
        BiConsumer<State, State> stateChangeListener = new BiConsumer<State, State>(){

            @Override
            public void accept(State previousState, State nextState) {
                boolean stateAlreadyRecovered;
                boolean stateJustRecovered = previousState == State.UNRECOVERED_STATE && nextState != State.UNRECOVERED_STATE;
                boolean bl = stateAlreadyRecovered = previousState != State.UNRECOVERED_STATE;
                if (stateJustRecovered) {
                    recoveredStateConsumer.accept(nextState);
                } else if (stateAlreadyRecovered) {
                    SecurityIndexManager.this.stateChangeListeners.remove(this);
                }
            }
        };
        this.stateChangeListeners.add(stateChangeListener);
    }

    public void onIndexAvailableForSearch(final ActionListener<Void> listener, TimeValue timeout) {
        logger.info("Will wait for security index [{}] for [{}] to become available for search", (Object)this.getConcreteIndexName(), (Object)timeout);
        if (this.state.indexAvailableForSearch) {
            logger.debug("Security index [{}] is already available", (Object)this.getConcreteIndexName());
            listener.onResponse(null);
            return;
        }
        final AtomicBoolean isDone = new AtomicBoolean(false);
        StateConsumerWithCancellable indexAvailableForSearchListener = new StateConsumerWithCancellable(){

            @Override
            public void accept(State previousState, State nextState) {
                if (nextState.indexAvailableForSearch && isDone.compareAndSet(false, true)) {
                    this.cancel();
                    SecurityIndexManager.this.removeStateListener(this);
                    listener.onResponse(null);
                }
            }
        };
        this.addStateListener(indexAvailableForSearchListener);
        indexAvailableForSearchListener.setCancellable(this.client.threadPool().schedule(() -> this.lambda$onIndexAvailableForSearch$1(isDone, indexAvailableForSearchListener, listener), timeout, (Executor)this.client.threadPool().generic()));
    }

    List<BiConsumer<State, State>> getStateChangeListeners() {
        return this.stateChangeListeners;
    }

    private Tuple<Boolean, Boolean> checkIndexAvailable(ClusterState state) {
        String aliasName = this.systemIndexDescriptor.getAliasName();
        IndexMetadata metadata = SecurityIndexManager.resolveConcreteIndex(aliasName, state.metadata());
        if (metadata == null) {
            logger.debug("Index [{}] is not available - no metadata", (Object)aliasName);
            return new Tuple((Object)false, (Object)false);
        }
        if (metadata.getState() == IndexMetadata.State.CLOSE) {
            logger.warn("Index [{}] is closed", (Object)aliasName);
            return new Tuple((Object)false, (Object)false);
        }
        boolean allPrimaryShards = false;
        boolean searchShards = false;
        IndexRoutingTable routingTable = state.routingTable().index(metadata.getIndex());
        if (routingTable != null && routingTable.allPrimaryShardsActive()) {
            allPrimaryShards = true;
        }
        if (routingTable != null && routingTable.readyForSearch(state)) {
            searchShards = true;
        }
        if (!allPrimaryShards || !searchShards) {
            logger.debug("Index [{}] is not fully available. all primary shards available [{}], search shards available, [{}]", (Object)aliasName, (Object)allPrimaryShards, (Object)searchShards);
        }
        return new Tuple((Object)allPrimaryShards, (Object)searchShards);
    }

    public boolean isEligibleSecurityMigration(SecurityMigrations.SecurityMigration securityMigration) {
        return this.state.securityFeatures.containsAll(securityMigration.nodeFeaturesRequired()) && this.state.indexMappingVersion >= securityMigration.minMappingVersion() && securityMigration.checkPreConditions(this.state);
    }

    public boolean isReadyForSecurityMigration(SecurityMigrations.SecurityMigration securityMigration) {
        return this.state.indexAvailableForWrite && this.state.indexAvailableForSearch && this.state.isIndexUpToDate && this.state.indexExists() && this.state.securityFeatures.contains(SecuritySystemIndices.SECURITY_MIGRATION_FRAMEWORK) && this.isEligibleSecurityMigration(securityMigration);
    }

    private boolean checkIndexMappingUpToDate(ClusterState clusterState) {
        SystemIndexDescriptor descriptor = this.systemIndexDescriptor.getDescriptorCompatibleWith(this.getMinSecurityIndexMappingVersion(clusterState));
        if (descriptor == null) {
            return false;
        }
        return descriptor.getMappingsVersion().version() <= SecurityIndexManager.loadIndexMappingVersion(this.systemIndexDescriptor.getAliasName(), clusterState);
    }

    private static int loadIndexMappingVersion(String aliasName, ClusterState clusterState) {
        MappingMetadata mappingMetadata;
        IndexMetadata indexMetadata = SecurityIndexManager.resolveConcreteIndex(aliasName, clusterState.metadata());
        if (indexMetadata != null && (mappingMetadata = indexMetadata.mapping()) != null) {
            return SecurityIndexManager.readMappingVersion(aliasName, mappingMetadata);
        }
        return 0;
    }

    private static int readMappingVersion(String indexName, MappingMetadata mappingMetadata) {
        Map meta = (Map)mappingMetadata.sourceAsMap().get("_meta");
        if (meta == null) {
            logger.info("Missing _meta field in mapping [{}] of index [{}]", (Object)mappingMetadata.type(), (Object)indexName);
            throw new IllegalStateException("Cannot read managed_index_mappings_version string in index " + indexName);
        }
        Integer value = (Integer)meta.get("managed_index_mappings_version");
        return value == null ? 0 : value;
    }

    private static IndexMetadata resolveConcreteIndex(String indexOrAliasName, Metadata metadata) {
        IndexAbstraction indexAbstraction = (IndexAbstraction)metadata.getIndicesLookup().get(indexOrAliasName);
        if (indexAbstraction != null) {
            List indices = indexAbstraction.getIndices();
            if (indexAbstraction.getType() != IndexAbstraction.Type.CONCRETE_INDEX && indices.size() > 1) {
                throw new IllegalStateException("Alias [" + indexOrAliasName + "] points to more than one index: " + indices);
            }
            return metadata.index((Index)indices.get(0));
        }
        return null;
    }

    public void checkIndexVersionThenExecute(Consumer<Exception> consumer, Runnable andThen) {
        State state = this.state;
        if (state.indexExists() && !state.isIndexUpToDate) {
            consumer.accept(new IllegalStateException("Index [" + state.concreteIndexName + "] is not on the current version. Security features relying on the index will not be available until the upgrade API is run on the index"));
        } else {
            andThen.run();
        }
    }

    public String getConcreteIndexName() {
        return this.state.concreteIndexName;
    }

    public void prepareIndexIfNeededThenExecute(final Consumer<Exception> consumer, final Runnable andThen) {
        State state = this.state;
        try {
            if (state == State.UNRECOVERED_STATE) {
                throw new ElasticsearchStatusException("Cluster state has not been recovered yet, cannot write to the [" + state.concreteIndexName + "] index", RestStatus.SERVICE_UNAVAILABLE, new Object[0]);
            }
            if (state.indexExists() && !state.isIndexUpToDate) {
                throw new IllegalStateException("Index [" + state.concreteIndexName + "] is not on the current version.Security features relying on the index will not be available until the upgrade API is run on the index");
            }
            if (!state.indexExists()) {
                assert (state.concreteIndexName != null);
                SystemIndexDescriptor descriptorForVersion = this.systemIndexDescriptor.getDescriptorCompatibleWith(state.minClusterMappingVersion);
                if (descriptorForVersion == null) {
                    String error = this.systemIndexDescriptor.getMinimumMappingsVersionMessage("create index");
                    consumer.accept(new IllegalStateException(error));
                } else {
                    logger.info("security index does not exist, creating [{}] with alias [{}]", (Object)state.concreteIndexName, (Object)descriptorForVersion.getAliasName());
                    CreateIndexRequest request = new CreateIndexRequest(state.concreteIndexName).origin(descriptorForVersion.getOrigin()).mapping(descriptorForVersion.getMappings()).settings(descriptorForVersion.getSettings()).alias(new Alias(descriptorForVersion.getAliasName())).waitForActiveShards(ActiveShardCount.ALL);
                    ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)descriptorForVersion.getOrigin(), (Object)request, (ActionListener)new ActionListener<CreateIndexResponse>(){

                        public void onResponse(CreateIndexResponse createIndexResponse) {
                            if (createIndexResponse.isAcknowledged()) {
                                andThen.run();
                            } else {
                                consumer.accept(new ElasticsearchException("Failed to create security index", new Object[0]));
                            }
                        }

                        public void onFailure(Exception e) {
                            Throwable cause = ExceptionsHelper.unwrapCause((Throwable)e);
                            if (cause instanceof ResourceAlreadyExistsException) {
                                andThen.run();
                            } else {
                                consumer.accept(e);
                            }
                        }
                    }, (arg_0, arg_1) -> ((IndicesAdminClient)this.client.admin().indices()).create(arg_0, arg_1));
                }
            } else if (!state.mappingUpToDate) {
                SystemIndexDescriptor descriptorForVersion = this.systemIndexDescriptor.getDescriptorCompatibleWith(state.minClusterMappingVersion);
                if (descriptorForVersion == null) {
                    String error = this.systemIndexDescriptor.getMinimumMappingsVersionMessage("updating mapping");
                    consumer.accept(new IllegalStateException(error));
                } else {
                    logger.info("Index [{}] (alias [{}]) is not up to date. Updating mapping", (Object)state.concreteIndexName, (Object)descriptorForVersion.getAliasName());
                    PutMappingRequest request = new PutMappingRequest(new String[]{state.concreteIndexName}).source(descriptorForVersion.getMappings(), XContentType.JSON).origin(descriptorForVersion.getOrigin());
                    ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)descriptorForVersion.getOrigin(), (Object)request, (ActionListener)ActionListener.wrap(putMappingResponse -> {
                        if (putMappingResponse.isAcknowledged()) {
                            andThen.run();
                        } else {
                            consumer.accept(new IllegalStateException("put mapping request was not acknowledged"));
                        }
                    }, consumer), (arg_0, arg_1) -> ((IndicesAdminClient)this.client.admin().indices()).putMapping(arg_0, arg_1));
                }
            } else {
                andThen.run();
            }
        }
        catch (Exception e) {
            consumer.accept(e);
        }
    }

    public boolean isCreatedOnLatestVersion() {
        return this.state.createdOnLatestVersion;
    }

    public static boolean isMoveFromRedToNonRed(State previousState, State currentState) {
        return (previousState.indexHealth == null || previousState.indexHealth == ClusterHealthStatus.RED) && currentState.indexHealth != null && currentState.indexHealth != ClusterHealthStatus.RED;
    }

    public static boolean isIndexDeleted(State previousState, State currentState) {
        return previousState.indexHealth != null && currentState.indexHealth == null;
    }

    private /* synthetic */ void lambda$onIndexAvailableForSearch$1(AtomicBoolean isDone, 2 indexAvailableForSearchListener, ActionListener listener) {
        if (isDone.compareAndSet(false, true)) {
            this.removeStateListener(indexAvailableForSearchListener);
            listener.onFailure((Exception)new ElasticsearchTimeoutException("timed out waiting for security index [" + this.getConcreteIndexName() + "] to become available for search", new Object[0]));
        }
    }

    public static class State {
        public static final State UNRECOVERED_STATE = new State(null, false, false, false, false, false, null, null, null, null, null, null, null, null, Set.of());
        public final Instant creationTime;
        public final boolean isIndexUpToDate;
        public final boolean indexAvailableForSearch;
        public final boolean indexAvailableForWrite;
        public final boolean mappingUpToDate;
        public final boolean createdOnLatestVersion;
        public final RoleMappingsCleanupMigrationStatus roleMappingsCleanupMigrationStatus;
        public final Integer migrationsVersion;
        public final SystemIndexDescriptor.MappingsVersion minClusterMappingVersion;
        public final Integer indexMappingVersion;
        public final String concreteIndexName;
        public final ClusterHealthStatus indexHealth;
        public final IndexMetadata.State indexState;
        public final String indexUUID;
        public final Set<NodeFeature> securityFeatures;

        public State(Instant creationTime, boolean isIndexUpToDate, boolean indexAvailableForSearch, boolean indexAvailableForWrite, boolean mappingUpToDate, boolean createdOnLatestVersion, RoleMappingsCleanupMigrationStatus roleMappingsCleanupMigrationStatus, Integer migrationsVersion, SystemIndexDescriptor.MappingsVersion minClusterMappingVersion, Integer indexMappingVersion, String concreteIndexName, ClusterHealthStatus indexHealth, IndexMetadata.State indexState, String indexUUID, Set<NodeFeature> securityFeatures) {
            this.creationTime = creationTime;
            this.isIndexUpToDate = isIndexUpToDate;
            this.indexAvailableForSearch = indexAvailableForSearch;
            this.indexAvailableForWrite = indexAvailableForWrite;
            this.mappingUpToDate = mappingUpToDate;
            this.migrationsVersion = migrationsVersion;
            this.createdOnLatestVersion = createdOnLatestVersion;
            this.roleMappingsCleanupMigrationStatus = roleMappingsCleanupMigrationStatus;
            this.minClusterMappingVersion = minClusterMappingVersion;
            this.indexMappingVersion = indexMappingVersion;
            this.concreteIndexName = concreteIndexName;
            this.indexHealth = indexHealth;
            this.indexState = indexState;
            this.indexUUID = indexUUID;
            this.securityFeatures = securityFeatures;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            State state = (State)o;
            return Objects.equals(this.creationTime, state.creationTime) && this.isIndexUpToDate == state.isIndexUpToDate && this.indexAvailableForSearch == state.indexAvailableForSearch && this.indexAvailableForWrite == state.indexAvailableForWrite && this.mappingUpToDate == state.mappingUpToDate && this.createdOnLatestVersion == state.createdOnLatestVersion && this.roleMappingsCleanupMigrationStatus == state.roleMappingsCleanupMigrationStatus && Objects.equals(this.indexMappingVersion, state.indexMappingVersion) && Objects.equals(this.migrationsVersion, state.migrationsVersion) && Objects.equals(this.minClusterMappingVersion, state.minClusterMappingVersion) && Objects.equals(this.concreteIndexName, state.concreteIndexName) && this.indexHealth == state.indexHealth && this.indexState == state.indexState && Objects.equals(this.securityFeatures, state.securityFeatures);
        }

        public boolean indexExists() {
            return this.creationTime != null;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.creationTime, this.isIndexUpToDate, this.indexAvailableForSearch, this.indexAvailableForWrite, this.mappingUpToDate, this.createdOnLatestVersion, this.roleMappingsCleanupMigrationStatus, this.migrationsVersion, this.minClusterMappingVersion, this.indexMappingVersion, this.concreteIndexName, this.indexHealth, this.securityFeatures});
        }

        public String toString() {
            return "State{creationTime=" + this.creationTime + ", isIndexUpToDate=" + this.isIndexUpToDate + ", indexAvailableForSearch=" + this.indexAvailableForSearch + ", indexAvailableForWrite=" + this.indexAvailableForWrite + ", mappingUpToDate=" + this.mappingUpToDate + ", createdOnLatestVersion=" + this.createdOnLatestVersion + ", roleMappingsCleanupMigrationStatus=" + this.roleMappingsCleanupMigrationStatus + ", migrationsVersion=" + this.migrationsVersion + ", minClusterMappingVersion=" + this.minClusterMappingVersion + ", indexMappingVersion=" + this.indexMappingVersion + ", concreteIndexName='" + this.concreteIndexName + "', indexHealth=" + this.indexHealth + ", indexState=" + this.indexState + ", indexUUID='" + this.indexUUID + "', securityFeatures=" + this.securityFeatures + "}";
        }
    }

    public static enum Availability {
        SEARCH_SHARDS,
        PRIMARY_SHARDS;

    }

    public static enum RoleMappingsCleanupMigrationStatus {
        READY,
        NOT_READY,
        SKIP,
        DONE;

    }

    static abstract class StateConsumerWithCancellable
    implements BiConsumer<State, State>,
    Scheduler.Cancellable {
        private volatile Scheduler.ScheduledCancellable cancellable;
        private volatile boolean cancelled = false;

        StateConsumerWithCancellable() {
        }

        void setCancellable(Scheduler.ScheduledCancellable cancellable) {
            this.cancellable = cancellable;
            if (this.cancelled) {
                this.cancel();
            }
        }

        public boolean cancel() {
            this.cancelled = true;
            if (this.cancellable != null) {
                return this.cancellable.cancel();
            }
            return this.isCancelled();
        }

        public boolean isCancelled() {
            return this.cancelled;
        }
    }
}

