/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authz.interceptor;

import java.util.Map;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.security.authz.accesscontrol.IndicesAccessControl;
import org.elasticsearch.xpack.security.authz.interceptor.FieldAndDocumentLevelSecurityRequestInterceptor;

public class UpdateRequestInterceptor
extends FieldAndDocumentLevelSecurityRequestInterceptor {
    public UpdateRequestInterceptor(ThreadPool threadPool, XPackLicenseState licenseState) {
        super(threadPool.getThreadContext(), licenseState);
    }

    @Override
    void disableFeatures(IndicesRequest indicesRequest, Map<String, IndicesAccessControl.IndexAccessControl> indicesAccessControlByIndex, ActionListener<Void> listener) {
        listener.onFailure((Exception)((Object)new ElasticsearchSecurityException("Can't execute an update request if field or document level security is enabled", RestStatus.BAD_REQUEST, new Object[0])));
    }

    @Override
    String[] requestIndices(IndicesRequest indicesRequest) {
        UpdateRequest updateRequest;
        if (indicesRequest instanceof UpdateRequest && (updateRequest = (UpdateRequest)indicesRequest).getShardId() != null) {
            return new String[]{updateRequest.getShardId().getIndexName()};
        }
        return new String[0];
    }

    @Override
    public boolean supports(IndicesRequest request) {
        return request instanceof UpdateRequest;
    }
}

