/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc;

import java.util.HashMap;
import java.util.Map;
import java.util.function.LongSupplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.core.Strings;
import org.elasticsearch.telemetry.metric.MeterRegistry;
import org.elasticsearch.xpack.core.security.action.apikey.ApiKey;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authc.AuthenticationResult;
import org.elasticsearch.xpack.core.security.authc.AuthenticationToken;
import org.elasticsearch.xpack.core.security.support.Exceptions;
import org.elasticsearch.xpack.security.authc.ApiKeyService;
import org.elasticsearch.xpack.security.authc.Authenticator;
import org.elasticsearch.xpack.security.metric.InstrumentedSecurityActionListener;
import org.elasticsearch.xpack.security.metric.SecurityMetricType;
import org.elasticsearch.xpack.security.metric.SecurityMetrics;

class ApiKeyAuthenticator
implements Authenticator {
    public static final String ATTRIBUTE_API_KEY_ID = "es.security.api_key_id";
    public static final String ATTRIBUTE_API_KEY_TYPE = "es.security.api_key_type";
    public static final String ATTRIBUTE_API_KEY_AUTHC_FAILURE_REASON = "es.security.api_key_authc_failure_reason";
    private static final Logger logger = LogManager.getLogger(ApiKeyAuthenticator.class);
    private final SecurityMetrics<ApiKeyService.ApiKeyCredentials> authenticationMetrics;
    private final ApiKeyService apiKeyService;
    private final String nodeName;

    ApiKeyAuthenticator(ApiKeyService apiKeyService, String nodeName, MeterRegistry meterRegistry) {
        this(apiKeyService, nodeName, meterRegistry, System::nanoTime);
    }

    ApiKeyAuthenticator(ApiKeyService apiKeyService, String nodeName, MeterRegistry meterRegistry, LongSupplier nanoTimeSupplier) {
        this.authenticationMetrics = new SecurityMetrics<ApiKeyService.ApiKeyCredentials>(SecurityMetricType.AUTHC_API_KEY, meterRegistry, this::buildMetricAttributes, nanoTimeSupplier);
        this.apiKeyService = apiKeyService;
        this.nodeName = nodeName;
    }

    @Override
    public String name() {
        return "API key";
    }

    @Override
    public AuthenticationToken extractCredentials(Authenticator.Context context) {
        ApiKeyService.ApiKeyCredentials apiKeyCredentials = this.apiKeyService.parseCredentialsFromApiKeyString(context.getApiKeyString());
        assert (apiKeyCredentials == null || apiKeyCredentials.getExpectedType() == ApiKey.Type.REST);
        return apiKeyCredentials;
    }

    @Override
    public void authenticate(Authenticator.Context context, ActionListener<AuthenticationResult<Authentication>> listener) {
        AuthenticationToken authenticationToken = context.getMostRecentAuthenticationToken();
        if (!(authenticationToken instanceof ApiKeyService.ApiKeyCredentials)) {
            listener.onResponse((Object)AuthenticationResult.notHandled());
            return;
        }
        ApiKeyService.ApiKeyCredentials apiKeyCredentials = (ApiKeyService.ApiKeyCredentials)authenticationToken;
        this.apiKeyService.tryAuthenticate(context.getThreadContext(), apiKeyCredentials, InstrumentedSecurityActionListener.wrapForAuthc(this.authenticationMetrics, apiKeyCredentials, ActionListener.wrap(authResult -> {
            if (authResult.isAuthenticated()) {
                Authentication authentication = Authentication.newApiKeyAuthentication((AuthenticationResult)authResult, (String)this.nodeName);
                listener.onResponse((Object)AuthenticationResult.success((Object)authentication));
            } else if (authResult.getStatus() == AuthenticationResult.Status.TERMINATE) {
                Exception e = authResult.getException() != null ? authResult.getException() : Exceptions.authenticationError((String)authResult.getMessage(), (Object[])new Object[0]);
                logger.debug(() -> "API key service terminated authentication for request [" + context.getRequest() + "]", (Throwable)e);
                context.getRequest().exceptionProcessingRequest(e, authenticationToken);
                listener.onFailure(e);
            } else {
                if (authResult.getMessage() != null) {
                    if (authResult.getException() != null) {
                        logger.warn(() -> Strings.format((String)"Authentication using apikey failed - %s", (Object[])new Object[]{authResult.getMessage()}), (Throwable)authResult.getException());
                    } else {
                        logger.warn("Authentication using apikey failed - {}", (Object)authResult.getMessage());
                    }
                }
                listener.onResponse((Object)AuthenticationResult.unsuccessful((String)authResult.getMessage(), (Exception)authResult.getException()));
            }
        }, e -> listener.onFailure((Exception)((Object)context.getRequest().exceptionProcessingRequest((Exception)e, null))))));
    }

    private Map<String, Object> buildMetricAttributes(ApiKeyService.ApiKeyCredentials credentials, String failureReason) {
        HashMap<String, Object> attributes = new HashMap<String, Object>(failureReason != null ? 3 : 2);
        attributes.put(ATTRIBUTE_API_KEY_ID, credentials.getId());
        attributes.put(ATTRIBUTE_API_KEY_TYPE, credentials.getExpectedType().value());
        if (failureReason != null) {
            attributes.put(ATTRIBUTE_API_KEY_AUTHC_FAILURE_REASON, failureReason);
        }
        return attributes;
    }
}

