/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.support;

import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Version;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.license.License;
import org.elasticsearch.license.LicenseStateListener;
import org.elasticsearch.license.XPackLicenseState;

public class SecurityStatusChangeListener
implements LicenseStateListener {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(this.getClass());
    private final XPackLicenseState licenseState;
    private Boolean securityEnabled;

    public SecurityStatusChangeListener(XPackLicenseState licenseState) {
        this.licenseState = licenseState;
        this.securityEnabled = null;
    }

    public synchronized void licenseStateChanged() {
        boolean newState = this.licenseState.isSecurityEnabled();
        if (!Objects.equals(newState, this.securityEnabled)) {
            this.logger.info("Active license is now [{}]; Security is {}", (Object)this.licenseState.getOperationMode(), (Object)(newState ? "enabled" : "disabled"));
            if (!newState) {
                this.logger.warn("Elasticsearch built-in security features are not enabled. Without authentication, your cluster could be accessible to anyone. See https://www.elastic.co/guide/en/elasticsearch/reference/" + Version.CURRENT.major + "." + Version.CURRENT.minor + "/security-minimal-setup.html to enable security.");
                if (this.licenseState.getOperationMode().equals((Object)License.OperationMode.BASIC) || this.licenseState.getOperationMode().equals((Object)License.OperationMode.TRIAL)) {
                    this.deprecationLogger.critical(DeprecationCategory.SECURITY, "security_implicitly_disabled", "The default behavior of disabling security on " + this.licenseState.getOperationMode().description() + " licenses is deprecated. In a later version of Elasticsearch, the value of [xpack.security.enabled] will default to \"true\" , regardless of the license level. See https://www.elastic.co/guide/en/elasticsearch/reference/" + Version.CURRENT.major + "." + Version.CURRENT.minor + "/security-minimal-setup.html to enable security, or explicitly disable security by setting [xpack.security.enabled] to false in elasticsearch.yml", new Object[0]);
                }
            }
            this.securityEnabled = newState;
        }
    }
}

