/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authz.interceptor;

import java.util.Arrays;
import java.util.Map;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.security.authz.accesscontrol.IndicesAccessControl;
import org.elasticsearch.xpack.security.Security;
import org.elasticsearch.xpack.security.authz.interceptor.FieldAndDocumentLevelSecurityRequestInterceptor;

public class SearchRequestInterceptor
extends FieldAndDocumentLevelSecurityRequestInterceptor {
    public static final Version VERSION_SHARD_SEARCH_INTERCEPTOR = Version.V_7_11_2;
    private final ClusterService clusterService;
    private final boolean forceTermsAggsToExcludeDeleteDocsEnabled;

    public SearchRequestInterceptor(ThreadPool threadPool, XPackLicenseState licenseState, ClusterService clusterService) {
        super(threadPool.getThreadContext(), licenseState);
        this.clusterService = clusterService;
        this.forceTermsAggsToExcludeDeleteDocsEnabled = (Boolean)Security.DLS_FORCE_TERMS_AGGS_TO_EXCLUDE_DELETED_DOCS.get(clusterService.getSettings());
    }

    @Override
    void disableFeatures(IndicesRequest indicesRequest, Map<String, IndicesAccessControl.IndexAccessControl> indexAccessControlByIndex, ActionListener<Void> listener) {
        SearchRequest request = (SearchRequest)indicesRequest;
        if (this.clusterService.state().nodes().getMinNodeVersion().before(VERSION_SHARD_SEARCH_INTERCEPTOR) || this.hasRemoteIndices(request)) {
            request.requestCache(Boolean.valueOf(false));
        }
        SearchSourceBuilder source = request.source();
        if (indexAccessControlByIndex.values().stream().anyMatch(iac -> iac.getDocumentPermissions().hasDocumentLevelPermissions())) {
            if (source != null && source.suggest() != null) {
                listener.onFailure((Exception)((Object)new ElasticsearchSecurityException("Suggest isn't supported if document level security is enabled", RestStatus.BAD_REQUEST, new Object[0])));
            } else if (source != null && source.profile()) {
                listener.onFailure((Exception)((Object)new ElasticsearchSecurityException("A search request cannot be profiled if document level security is enabled", RestStatus.BAD_REQUEST, new Object[0])));
            } else {
                if (this.forceTermsAggsToExcludeDeleteDocsEnabled && SearchRequestInterceptor.hasZeroMinDocTermsAggregation(request)) {
                    assert (request.source() != null && request.source().aggregations() != null);
                    request.source().aggregations().forceTermsAggsToExcludeDeletedDocs();
                }
                listener.onResponse(null);
            }
        } else {
            listener.onResponse(null);
        }
    }

    @Override
    public boolean supports(IndicesRequest request) {
        return request instanceof SearchRequest;
    }

    boolean hasRemoteIndices(SearchRequest request) {
        return Arrays.stream(request.indices()).anyMatch(name -> name.indexOf(58) >= 0);
    }

    private static boolean hasZeroMinDocTermsAggregation(SearchRequest searchRequest) {
        return searchRequest.source() != null && searchRequest.source().aggregations() != null && searchRequest.source().aggregations().hasZeroMinDocTermsAggregation();
    }
}

