/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.saml;

import java.util.Collections;
import java.util.List;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xpack.security.authc.saml.SigningConfiguration;
import org.opensaml.security.x509.X509Credential;

public class SpConfiguration {
    private final String entityId;
    private final String ascUrl;
    private final String logoutUrl;
    private final SigningConfiguration signingConfiguration;
    private final List<String> reqAuthnCtxClassRef;
    private final List<X509Credential> encryptionCredentials;

    public SpConfiguration(String entityId, String ascUrl, String logoutUrl, SigningConfiguration signingConfiguration, @Nullable List<X509Credential> encryptionCredential, List<String> authnCtxClassRef) {
        this.entityId = entityId;
        this.ascUrl = ascUrl;
        this.logoutUrl = logoutUrl;
        this.signingConfiguration = signingConfiguration;
        this.encryptionCredentials = encryptionCredential != null ? Collections.unmodifiableList(encryptionCredential) : Collections.emptyList();
        this.reqAuthnCtxClassRef = authnCtxClassRef;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public String getAscUrl() {
        return this.ascUrl;
    }

    public String getLogoutUrl() {
        return this.logoutUrl;
    }

    public List<X509Credential> getEncryptionCredentials() {
        return this.encryptionCredentials;
    }

    public SigningConfiguration getSigningConfiguration() {
        return this.signingConfiguration;
    }

    List<String> getReqAuthnCtxClassRef() {
        return this.reqAuthnCtxClassRef;
    }
}

