/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.user;

import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.security.action.user.PutUserRequest;
import org.elasticsearch.xpack.core.security.action.user.PutUserResponse;
import org.elasticsearch.xpack.core.security.authc.esnative.ClientReservedRealm;
import org.elasticsearch.xpack.core.security.support.Validation;
import org.elasticsearch.xpack.core.security.user.AnonymousUser;
import org.elasticsearch.xpack.security.authc.esnative.NativeUsersStore;

public class TransportPutUserAction
extends HandledTransportAction<PutUserRequest, PutUserResponse> {
    private final Settings settings;
    private final NativeUsersStore usersStore;

    @Inject
    public TransportPutUserAction(Settings settings, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, NativeUsersStore usersStore, TransportService transportService) {
        super(settings, "cluster:admin/xpack/security/user/put", threadPool, transportService, actionFilters, indexNameExpressionResolver, PutUserRequest::new);
        this.settings = settings;
        this.usersStore = usersStore;
    }

    protected void doExecute(final PutUserRequest request, final ActionListener<PutUserResponse> listener) {
        ActionRequestValidationException validationException = this.validateRequest(request);
        if (validationException != null) {
            listener.onFailure((Exception)validationException);
        } else {
            this.usersStore.putUser(request, new ActionListener<Boolean>(){

                public void onResponse(Boolean created) {
                    if (created.booleanValue()) {
                        TransportPutUserAction.this.logger.info("added user [{}]", (Object)request.username());
                    } else {
                        TransportPutUserAction.this.logger.info("updated user [{}]", (Object)request.username());
                    }
                    listener.onResponse((Object)new PutUserResponse(created.booleanValue()));
                }

                public void onFailure(Exception e) {
                    TransportPutUserAction.this.logger.error(() -> new ParameterizedMessage("failed to put user [{}]", (Object)request.username()), (Throwable)e);
                    listener.onFailure(e);
                }
            });
        }
    }

    private ActionRequestValidationException validateRequest(PutUserRequest request) {
        ActionRequestValidationException validationException = null;
        String username = request.username();
        if (ClientReservedRealm.isReserved((String)username, (Settings)this.settings)) {
            validationException = AnonymousUser.isAnonymousUsername((String)username, (Settings)this.settings) ? ValidateActions.addValidationError((String)("user [" + username + "] is anonymous and cannot be modified via the API"), validationException) : ValidateActions.addValidationError((String)("user [" + username + "] is reserved and only the password can be changed"), validationException);
        } else if ("_system".equals(username) || "_xpack".equals(username) || "_xpack_security".equals(username)) {
            validationException = ValidateActions.addValidationError((String)("user [" + username + "] is internal"), validationException);
        } else {
            Validation.Error usernameError = Validation.Users.validateUsername((String)username, (boolean)true, (Settings)this.settings);
            if (usernameError != null) {
                validationException = ValidateActions.addValidationError((String)usernameError.toString(), (ActionRequestValidationException)validationException);
            }
        }
        if (request.roles() != null) {
            for (String role : request.roles()) {
                Validation.Error roleNameError = Validation.Roles.validateRoleName((String)role, (boolean)true);
                if (roleNameError == null) continue;
                validationException = ValidateActions.addValidationError((String)roleNameError.toString(), (ActionRequestValidationException)validationException);
            }
        }
        return validationException;
    }
}

