/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.actions.hipchat;

import java.io.IOException;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.common.text.TextTemplateEngine;
import org.elasticsearch.xpack.notification.hipchat.HipChatAccount;
import org.elasticsearch.xpack.notification.hipchat.HipChatService;
import org.elasticsearch.xpack.watcher.actions.ActionFactory;
import org.elasticsearch.xpack.watcher.actions.hipchat.ExecutableHipChatAction;
import org.elasticsearch.xpack.watcher.actions.hipchat.HipChatAction;

public class HipChatActionFactory
extends ActionFactory {
    private final TextTemplateEngine templateEngine;
    private final HipChatService hipchatService;

    public HipChatActionFactory(Settings settings, TextTemplateEngine templateEngine, HipChatService hipchatService) {
        super(Loggers.getLogger(ExecutableHipChatAction.class, (Settings)settings, (String[])new String[0]));
        this.templateEngine = templateEngine;
        this.hipchatService = hipchatService;
    }

    @Override
    public ExecutableHipChatAction parseExecutable(String watchId, String actionId, XContentParser parser) throws IOException {
        HipChatAction action = HipChatAction.parse(watchId, actionId, parser);
        HipChatAccount account = (HipChatAccount)this.hipchatService.getAccount(action.account);
        account.validateParsedTemplate(watchId, actionId, action.message);
        return new ExecutableHipChatAction(action, this.actionLogger, this.hipchatService, this.templateEngine);
    }
}

