/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.GenericAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.NamedDiff;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.IndexTemplateMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.Booleans;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.SecureSetting;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.env.Environment;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.ScriptPlugin;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.script.ScriptSettings;
import org.elasticsearch.threadpool.ExecutorBuilder;
import org.elasticsearch.threadpool.FixedExecutorBuilder;
import org.elasticsearch.xpack.XPackPlugin;
import org.elasticsearch.xpack.XPackSettings;
import org.elasticsearch.xpack.common.http.HttpClient;
import org.elasticsearch.xpack.common.http.HttpRequestTemplate;
import org.elasticsearch.xpack.common.text.TextTemplateEngine;
import org.elasticsearch.xpack.notification.email.EmailService;
import org.elasticsearch.xpack.notification.email.attachment.EmailAttachmentsParser;
import org.elasticsearch.xpack.notification.hipchat.HipChatService;
import org.elasticsearch.xpack.notification.jira.JiraService;
import org.elasticsearch.xpack.notification.pagerduty.PagerDutyService;
import org.elasticsearch.xpack.notification.slack.SlackService;
import org.elasticsearch.xpack.security.InternalClient;
import org.elasticsearch.xpack.security.crypto.CryptoService;
import org.elasticsearch.xpack.support.clock.Clock;
import org.elasticsearch.xpack.template.TemplateUtils;
import org.elasticsearch.xpack.watcher.WatcherMetaData;
import org.elasticsearch.xpack.watcher.WatcherModule;
import org.elasticsearch.xpack.watcher.actions.ActionFactory;
import org.elasticsearch.xpack.watcher.actions.ActionRegistry;
import org.elasticsearch.xpack.watcher.actions.email.EmailActionFactory;
import org.elasticsearch.xpack.watcher.actions.hipchat.HipChatActionFactory;
import org.elasticsearch.xpack.watcher.actions.index.IndexActionFactory;
import org.elasticsearch.xpack.watcher.actions.jira.JiraActionFactory;
import org.elasticsearch.xpack.watcher.actions.logging.LoggingActionFactory;
import org.elasticsearch.xpack.watcher.actions.pagerduty.PagerDutyActionFactory;
import org.elasticsearch.xpack.watcher.actions.slack.SlackActionFactory;
import org.elasticsearch.xpack.watcher.actions.webhook.WebhookActionFactory;
import org.elasticsearch.xpack.watcher.client.WatcherClientModule;
import org.elasticsearch.xpack.watcher.condition.AlwaysCondition;
import org.elasticsearch.xpack.watcher.condition.ArrayCompareCondition;
import org.elasticsearch.xpack.watcher.condition.CompareCondition;
import org.elasticsearch.xpack.watcher.condition.ConditionFactory;
import org.elasticsearch.xpack.watcher.condition.ConditionRegistry;
import org.elasticsearch.xpack.watcher.condition.NeverCondition;
import org.elasticsearch.xpack.watcher.condition.ScriptCondition;
import org.elasticsearch.xpack.watcher.execution.ExecutionModule;
import org.elasticsearch.xpack.watcher.execution.ExecutionService;
import org.elasticsearch.xpack.watcher.history.HistoryModule;
import org.elasticsearch.xpack.watcher.history.HistoryStore;
import org.elasticsearch.xpack.watcher.input.InputModule;
import org.elasticsearch.xpack.watcher.rest.action.RestAckWatchAction;
import org.elasticsearch.xpack.watcher.rest.action.RestActivateWatchAction;
import org.elasticsearch.xpack.watcher.rest.action.RestDeleteWatchAction;
import org.elasticsearch.xpack.watcher.rest.action.RestExecuteWatchAction;
import org.elasticsearch.xpack.watcher.rest.action.RestGetWatchAction;
import org.elasticsearch.xpack.watcher.rest.action.RestHijackOperationAction;
import org.elasticsearch.xpack.watcher.rest.action.RestPutWatchAction;
import org.elasticsearch.xpack.watcher.rest.action.RestWatchServiceAction;
import org.elasticsearch.xpack.watcher.rest.action.RestWatcherStatsAction;
import org.elasticsearch.xpack.watcher.support.WatcherIndexTemplateRegistry;
import org.elasticsearch.xpack.watcher.transform.TransformFactory;
import org.elasticsearch.xpack.watcher.transform.TransformRegistry;
import org.elasticsearch.xpack.watcher.transform.script.ScriptTransformFactory;
import org.elasticsearch.xpack.watcher.transform.search.SearchTransformFactory;
import org.elasticsearch.xpack.watcher.transport.actions.ack.AckWatchAction;
import org.elasticsearch.xpack.watcher.transport.actions.ack.TransportAckWatchAction;
import org.elasticsearch.xpack.watcher.transport.actions.activate.ActivateWatchAction;
import org.elasticsearch.xpack.watcher.transport.actions.activate.TransportActivateWatchAction;
import org.elasticsearch.xpack.watcher.transport.actions.delete.DeleteWatchAction;
import org.elasticsearch.xpack.watcher.transport.actions.delete.TransportDeleteWatchAction;
import org.elasticsearch.xpack.watcher.transport.actions.execute.ExecuteWatchAction;
import org.elasticsearch.xpack.watcher.transport.actions.execute.TransportExecuteWatchAction;
import org.elasticsearch.xpack.watcher.transport.actions.get.GetWatchAction;
import org.elasticsearch.xpack.watcher.transport.actions.get.TransportGetWatchAction;
import org.elasticsearch.xpack.watcher.transport.actions.put.PutWatchAction;
import org.elasticsearch.xpack.watcher.transport.actions.put.TransportPutWatchAction;
import org.elasticsearch.xpack.watcher.transport.actions.service.TransportWatcherServiceAction;
import org.elasticsearch.xpack.watcher.transport.actions.service.WatcherServiceAction;
import org.elasticsearch.xpack.watcher.transport.actions.stats.TransportWatcherStatsAction;
import org.elasticsearch.xpack.watcher.transport.actions.statsdist.WatcherStatsAction;
import org.elasticsearch.xpack.watcher.trigger.TriggerModule;
import org.elasticsearch.xpack.watcher.trigger.schedule.ScheduleModule;
import org.elasticsearch.xpack.watcher.watch.WatchModule;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class Watcher
implements ActionPlugin,
ScriptPlugin {
    public static final Setting<String> INDEX_WATCHER_VERSION_SETTING = new Setting("index.xpack.watcher.plugin.version", "", Function.identity(), new Setting.Property[]{Setting.Property.IndexScope});
    public static final Setting<String> INDEX_WATCHER_TEMPLATE_VERSION_SETTING = new Setting("index.xpack.watcher.template.version", "", Function.identity(), new Setting.Property[]{Setting.Property.IndexScope});
    public static final Setting<Boolean> ENCRYPT_SENSITIVE_DATA_SETTING = Setting.boolSetting((String)"xpack.watcher.encrypt_sensitive_data", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<InputStream> ENCRYPTION_KEY_SETTING = SecureSetting.secureFile((String)"xpack.watcher.encryption_key", null, (Setting.Property[])new Setting.Property[0]);
    public static final Setting<TimeValue> MAX_STOP_TIMEOUT_SETTING = Setting.timeSetting((String)"xpack.watcher.stop.timeout", (TimeValue)TimeValue.timeValueSeconds((long)30L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private static final String SETTING_KEY_AUTO_CREATE_INDEX = "action.auto_create_index";
    private static final ScriptContext.Plugin SCRIPT_PLUGIN = new ScriptContext.Plugin("xpack", "watch");
    public static final ScriptContext SCRIPT_CONTEXT = () -> ((ScriptContext.Plugin)SCRIPT_PLUGIN).getKey();
    private static final Logger logger = Loggers.getLogger(XPackPlugin.class);
    private static final DeprecationLogger DEPRECATION_LOGGER = new DeprecationLogger(logger);
    protected final Settings settings;
    protected final boolean transportClient;
    protected final boolean enabled;

    public List<NamedWriteableRegistry.Entry> getNamedWriteables() {
        ArrayList<NamedWriteableRegistry.Entry> entries = new ArrayList<NamedWriteableRegistry.Entry>();
        entries.add(new NamedWriteableRegistry.Entry(MetaData.Custom.class, "watcher", WatcherMetaData::new));
        entries.add(new NamedWriteableRegistry.Entry(NamedDiff.class, "watcher", WatcherMetaData::readDiffFrom));
        return entries;
    }

    public List<NamedXContentRegistry.Entry> getNamedXContent() {
        ArrayList<NamedXContentRegistry.Entry> entries = new ArrayList<NamedXContentRegistry.Entry>();
        entries.add(new NamedXContentRegistry.Entry(MetaData.Custom.class, new ParseField("watcher", new String[0]), WatcherMetaData::fromXContent));
        return entries;
    }

    public Watcher(Settings settings) {
        this.settings = settings;
        this.transportClient = "transport".equals(settings.get(Client.CLIENT_TYPE_SETTING_S.getKey()));
        this.enabled = (Boolean)XPackSettings.WATCHER_ENABLED.get(settings);
        if (this.enabled && !this.transportClient) {
            Watcher.validAutoCreateIndex(settings);
        }
        if (((Boolean)ENCRYPT_SENSITIVE_DATA_SETTING.get(settings)).booleanValue() && !ENCRYPTION_KEY_SETTING.exists(settings)) {
            DEPRECATION_LOGGER.deprecated("The use of the system_key file for encrypting sensitive values is deprecated. In order to continue using watches with encrypted data, execute the following command to store the key in the secure settings store: 'bin/elasticsearch-keystore add-file {} {}' on all of your nodes.", new Object[]{ENCRYPTION_KEY_SETTING.getKey(), CryptoService.resolveSystemKey(new Environment(settings))});
        }
    }

    public Collection<Object> createComponents(Clock clock, ScriptService scriptService, InternalClient internalClient, XPackLicenseState licenseState, HttpClient httpClient, NamedXContentRegistry xContentRegistry, Collection<Object> components) {
        HashMap<String, ConditionFactory> parsers = new HashMap<String, ConditionFactory>();
        parsers.put("always", (c, id, p, upgrade) -> AlwaysCondition.parse(id, p));
        parsers.put("never", (c, id, p, upgrade) -> NeverCondition.parse(id, p));
        parsers.put("array_compare", (c, id, p, upgrade) -> ArrayCompareCondition.parse(c, id, p));
        parsers.put("compare", (c, id, p, upgrade) -> CompareCondition.parse(c, id, p));
        String defaultLegacyScriptLanguage = ScriptSettings.getLegacyDefaultLang((Settings)this.settings);
        parsers.put("script", (c, id, p, upgrade) -> ScriptCondition.parse(scriptService, id, p, upgrade, defaultLegacyScriptLanguage));
        ConditionRegistry conditionRegistry = new ConditionRegistry(Collections.unmodifiableMap(parsers), clock);
        HashMap<String, TransformFactory> transformFactories = new HashMap<String, TransformFactory>();
        transformFactories.put("script", new ScriptTransformFactory(this.settings, scriptService));
        transformFactories.put("search", new SearchTransformFactory(this.settings, internalClient, xContentRegistry, scriptService));
        TransformRegistry transformRegistry = new TransformRegistry(this.settings, Collections.unmodifiableMap(transformFactories));
        HashMap<String, ActionFactory> actionFactoryMap = new HashMap<String, ActionFactory>();
        TextTemplateEngine templateEngine = this.getService(TextTemplateEngine.class, components);
        actionFactoryMap.put("email", new EmailActionFactory(this.settings, this.getService(EmailService.class, components), templateEngine, this.getService(EmailAttachmentsParser.class, components)));
        actionFactoryMap.put("webhook", new WebhookActionFactory(this.settings, httpClient, this.getService(HttpRequestTemplate.Parser.class, components), templateEngine));
        actionFactoryMap.put("index", new IndexActionFactory(this.settings, internalClient));
        actionFactoryMap.put("logging", new LoggingActionFactory(this.settings, templateEngine));
        actionFactoryMap.put("hipchat", new HipChatActionFactory(this.settings, templateEngine, this.getService(HipChatService.class, components)));
        actionFactoryMap.put("jira", new JiraActionFactory(this.settings, templateEngine, this.getService(JiraService.class, components)));
        actionFactoryMap.put("slack", new SlackActionFactory(this.settings, templateEngine, this.getService(SlackService.class, components)));
        actionFactoryMap.put("pagerduty", new PagerDutyActionFactory(this.settings, templateEngine, this.getService(PagerDutyService.class, components)));
        ActionRegistry registry = new ActionRegistry(actionFactoryMap, conditionRegistry, transformRegistry, clock, licenseState);
        return Collections.singleton(registry);
    }

    private <T> T getService(Class<T> serviceClass, Collection<Object> services) {
        List collect = services.stream().filter(o -> o.getClass() == serviceClass).collect(Collectors.toList());
        if (collect.isEmpty()) {
            throw new IllegalArgumentException("no service for class " + serviceClass.getName());
        }
        if (collect.size() > 1) {
            throw new IllegalArgumentException("more than one service for class " + serviceClass.getName());
        }
        return collect.get(0);
    }

    public Collection<Module> nodeModules() {
        ArrayList<Module> modules = new ArrayList<Module>();
        modules.add((Module)new WatcherModule(this.enabled, this.transportClient));
        if (this.enabled && !this.transportClient) {
            modules.add((Module)new WatchModule());
            modules.add((Module)new WatcherClientModule());
            modules.add((Module)new TriggerModule(this.settings));
            modules.add((Module)new ScheduleModule());
            modules.add((Module)new InputModule());
            modules.add((Module)new HistoryModule());
            modules.add((Module)new ExecutionModule());
        }
        return modules;
    }

    public Settings additionalSettings() {
        return Settings.EMPTY;
    }

    public List<Setting<?>> getSettings() {
        ArrayList settings = new ArrayList();
        for (WatcherIndexTemplateRegistry.TemplateConfig templateConfig : WatcherIndexTemplateRegistry.TEMPLATE_CONFIGS) {
            settings.add(templateConfig.getSetting());
        }
        settings.add(INDEX_WATCHER_VERSION_SETTING);
        settings.add(INDEX_WATCHER_TEMPLATE_VERSION_SETTING);
        settings.add(MAX_STOP_TIMEOUT_SETTING);
        settings.add(ExecutionService.DEFAULT_THROTTLE_PERIOD_SETTING);
        settings.add(Setting.intSetting((String)"xpack.watcher.execution.scroll.size", (int)0, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(Setting.intSetting((String)"xpack.watcher.watch.scroll.size", (int)0, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(ENCRYPT_SENSITIVE_DATA_SETTING);
        settings.add(ENCRYPTION_KEY_SETTING);
        settings.add(Setting.simpleString((String)"xpack.watcher.internal.ops.search.default_timeout", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(Setting.simpleString((String)"xpack.watcher.internal.ops.bulk.default_timeout", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(Setting.simpleString((String)"xpack.watcher.internal.ops.index.default_timeout", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(Setting.simpleString((String)"xpack.watcher.actions.index.default_timeout", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(Setting.simpleString((String)"xpack.watcher.index.rest.direct_access", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(Setting.simpleString((String)"xpack.watcher.trigger.schedule.engine", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(Setting.simpleString((String)"xpack.watcher.input.search.default_timeout", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(Setting.simpleString((String)"xpack.watcher.transform.search.default_timeout", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(Setting.simpleString((String)"xpack.watcher.trigger.schedule.ticker.tick_interval", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(Setting.simpleString((String)"xpack.watcher.execution.scroll.timeout", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(Setting.simpleString((String)"xpack.watcher.start_immediately", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        return settings;
    }

    public List<ExecutorBuilder<?>> getExecutorBuilders(Settings settings) {
        if (this.enabled) {
            FixedExecutorBuilder builder = new FixedExecutorBuilder(settings, "watcher", 5 * EsExecutors.boundedNumberOfProcessors((Settings)settings), 1000, "xpack.watcher.thread_pool");
            return Collections.singletonList(builder);
        }
        return Collections.emptyList();
    }

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        if (!this.enabled) {
            return Collections.emptyList();
        }
        return Arrays.asList(new ActionPlugin.ActionHandler((GenericAction)PutWatchAction.INSTANCE, TransportPutWatchAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)DeleteWatchAction.INSTANCE, TransportDeleteWatchAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)GetWatchAction.INSTANCE, TransportGetWatchAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)org.elasticsearch.xpack.watcher.transport.actions.stats.WatcherStatsAction.INSTANCE, TransportWatcherStatsAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)WatcherStatsAction.INSTANCE, org.elasticsearch.xpack.watcher.transport.actions.statsdist.TransportWatcherStatsAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)AckWatchAction.INSTANCE, TransportAckWatchAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)ActivateWatchAction.INSTANCE, TransportActivateWatchAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)WatcherServiceAction.INSTANCE, TransportWatcherServiceAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)ExecuteWatchAction.INSTANCE, TransportExecuteWatchAction.class, new Class[0]));
    }

    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        if (!this.enabled) {
            return Collections.emptyList();
        }
        return Arrays.asList(new RestHandler[]{new RestPutWatchAction(settings, restController), new RestDeleteWatchAction(settings, restController), new RestWatcherStatsAction(settings, restController), new RestGetWatchAction(settings, restController), new RestWatchServiceAction(settings, restController), new RestAckWatchAction(settings, restController), new RestActivateWatchAction(settings, restController), new RestExecuteWatchAction(settings, restController), new RestHijackOperationAction(settings, restController)});
    }

    public ScriptContext.Plugin getCustomScriptContexts() {
        return SCRIPT_PLUGIN;
    }

    public UnaryOperator<Map<String, IndexTemplateMetaData>> getIndexTemplateMetaDataUpgrader() {
        return templates -> {
            String templateName = ".watch-history-6";
            byte[] watchHistoryTemplate = TemplateUtils.loadTemplate("/watch-history.json", "6", Pattern.quote("${xpack.watcher.template.version}")).getBytes(StandardCharsets.UTF_8);
            try (XContentParser parser = XContentFactory.xContent((byte[])watchHistoryTemplate).createParser(NamedXContentRegistry.EMPTY, watchHistoryTemplate);){
                IndexTemplateMetaData indexTemplateMetaData = IndexTemplateMetaData.Builder.fromXContent((XContentParser)parser, (String)templateName);
                templates.put(templateName, indexTemplateMetaData);
            }
            catch (IOException e) {
                logger.error("Error loading watch history template [{}] as part of metadata upgrading", (Object)templateName);
            }
            return templates;
        };
    }

    static void validAutoCreateIndex(Settings settings) {
        String value = settings.get(SETTING_KEY_AUTO_CREATE_INDEX);
        if (value == null) {
            return;
        }
        String errorMessage = LoggerMessageFormat.format((String)"the [{}] setting value [{}] is too restrictive. disable [{}] or set it to [{}, {}, {}*]", (Object[])new Object[]{SETTING_KEY_AUTO_CREATE_INDEX, value, SETTING_KEY_AUTO_CREATE_INDEX, ".watches", ".triggered_watches", ".watcher-history-"});
        if (Booleans.isExplicitFalse((String)value)) {
            if (!Booleans.isStrictlyBoolean((String)value)) {
                DEPRECATION_LOGGER.deprecated("Expected [false] for setting [{}] but got [{}]", new Object[]{SETTING_KEY_AUTO_CREATE_INDEX, value});
            }
            throw new IllegalArgumentException(errorMessage);
        }
        if (Booleans.isExplicitTrue((String)value)) {
            if (!Booleans.isStrictlyBoolean((String)value)) {
                DEPRECATION_LOGGER.deprecated("Expected [true] for setting [{}] but got [{}]", new Object[]{SETTING_KEY_AUTO_CREATE_INDEX, value});
            }
            return;
        }
        String[] matches = Strings.commaDelimitedListToStringArray((String)value);
        ArrayList<String> indices = new ArrayList<String>();
        indices.add(".watches");
        indices.add(".triggered_watches");
        DateTime now = new DateTime(DateTimeZone.UTC);
        indices.add(HistoryStore.getHistoryIndexNameForTime(now));
        indices.add(HistoryStore.getHistoryIndexNameForTime(now.plusDays(1)));
        indices.add(HistoryStore.getHistoryIndexNameForTime(now.plusMonths(1)));
        indices.add(HistoryStore.getHistoryIndexNameForTime(now.plusMonths(2)));
        indices.add(HistoryStore.getHistoryIndexNameForTime(now.plusMonths(3)));
        indices.add(HistoryStore.getHistoryIndexNameForTime(now.plusMonths(4)));
        indices.add(HistoryStore.getHistoryIndexNameForTime(now.plusMonths(5)));
        indices.add(HistoryStore.getHistoryIndexNameForTime(now.plusMonths(6)));
        for (String index : indices) {
            boolean matched = false;
            for (String match : matches) {
                char c = match.charAt(0);
                if (c == '-') {
                    if (!Regex.simpleMatch((String)match.substring(1), (String)index)) continue;
                    throw new IllegalArgumentException(errorMessage);
                }
                if (c == '+') {
                    if (!Regex.simpleMatch((String)match.substring(1), (String)index)) continue;
                    matched = true;
                    break;
                }
                if (!Regex.simpleMatch((String)match, (String)index)) continue;
                matched = true;
                break;
            }
            if (matched) continue;
            throw new IllegalArgumentException(errorMessage);
        }
        logger.warn("the [action.auto_create_index] setting is configured to be restrictive [{}].  for the next 6 months daily history indices are allowed to be created, but please make sure that any future history indices after 6 months with the pattern [.watcher-history-YYYY.MM.dd] are allowed to be created", (Object)value);
    }
}

