/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.upgrade.actions;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.MasterNodeReadOperationRequestBuilder;
import org.elasticsearch.action.support.master.MasterNodeReadRequest;
import org.elasticsearch.action.support.master.TransportMasterNodeReadAction;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.upgrade.IndexUpgradeService;
import org.elasticsearch.xpack.upgrade.UpgradeActionRequired;

public class IndexUpgradeInfoAction
extends Action<Request, Response, RequestBuilder> {
    public static final IndexUpgradeInfoAction INSTANCE = new IndexUpgradeInfoAction();
    public static final String NAME = "cluster:admin/xpack/upgrade/info";

    private IndexUpgradeInfoAction() {
        super(NAME);
    }

    public RequestBuilder newRequestBuilder(ElasticsearchClient client) {
        return new RequestBuilder(client, this);
    }

    public Response newResponse() {
        return new Response();
    }

    public static class TransportAction
    extends TransportMasterNodeReadAction<Request, Response> {
        private final IndexUpgradeService indexUpgradeService;
        private final XPackLicenseState licenseState;

        @Inject
        public TransportAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexUpgradeService indexUpgradeService, IndexNameExpressionResolver indexNameExpressionResolver, XPackLicenseState licenseState) {
            super(settings, IndexUpgradeInfoAction.NAME, transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, Request::new);
            this.indexUpgradeService = indexUpgradeService;
            this.licenseState = licenseState;
        }

        protected String executor() {
            return "generic";
        }

        protected Response newResponse() {
            return new Response();
        }

        protected ClusterBlockException checkBlock(Request request, ClusterState state) {
            return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
        }

        protected final void masterOperation(Request request, ClusterState state, ActionListener<Response> listener) {
            if (this.licenseState.isUpgradeAllowed()) {
                Map<String, UpgradeActionRequired> results = this.indexUpgradeService.upgradeInfo(request.indices(), request.indicesOptions(), state);
                listener.onResponse((Object)new Response(results));
            } else {
                listener.onFailure((Exception)((Object)LicenseUtils.newComplianceException("upgrade")));
            }
        }
    }

    public static class RequestBuilder
    extends MasterNodeReadOperationRequestBuilder<Request, Response, RequestBuilder> {
        protected RequestBuilder(ElasticsearchClient client, IndexUpgradeInfoAction action) {
            super(client, (Action)action, (MasterNodeReadRequest)new Request());
        }

        public RequestBuilder setIndices(String ... indices) {
            ((Request)this.request).indices(indices);
            return this;
        }

        public RequestBuilder setIndicesOptions(IndicesOptions indicesOptions) {
            ((Request)this.request).indicesOptions(indicesOptions);
            return this;
        }
    }

    public static class Request
    extends MasterNodeReadRequest<Request>
    implements IndicesRequest.Replaceable {
        private String[] indices = null;
        private IndicesOptions indicesOptions = IndicesOptions.fromOptions((boolean)false, (boolean)true, (boolean)true, (boolean)true);

        public Request() {
        }

        public Request(String ... indices) {
            this.indices = indices;
        }

        public String[] indices() {
            return this.indices;
        }

        public Request indices(String ... indices) {
            this.indices = indices;
            return this;
        }

        public IndicesOptions indicesOptions() {
            return this.indicesOptions;
        }

        public void indicesOptions(IndicesOptions indicesOptions) {
            this.indicesOptions = indicesOptions;
        }

        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            if (this.indices == null) {
                validationException = ValidateActions.addValidationError((String)"index/indices is missing", validationException);
            }
            return validationException;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.indices = in.readStringArray();
            this.indicesOptions = IndicesOptions.readIndicesOptions((StreamInput)in);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeStringArray(this.indices);
            this.indicesOptions.writeIndicesOptions(out);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)((Object)o);
            return Arrays.equals(this.indices, request.indices) && Objects.equals(this.indicesOptions.toString(), request.indicesOptions.toString());
        }

        public int hashCode() {
            return Objects.hash(Arrays.hashCode(this.indices), this.indicesOptions.toString());
        }
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        private Map<String, UpgradeActionRequired> actions;

        protected Response() {
        }

        public Response(Map<String, UpgradeActionRequired> actions) {
            this.actions = actions;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.actions = in.readMap(StreamInput::readString, UpgradeActionRequired::readFromStream);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeMap(this.actions, StreamOutput::writeString, (out1, value) -> value.writeTo(out1));
        }

        public Map<String, UpgradeActionRequired> getActions() {
            return this.actions;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.startObject("indices");
            for (Map.Entry<String, UpgradeActionRequired> entry : this.actions.entrySet()) {
                builder.startObject(entry.getKey());
                builder.field("action_required", entry.getValue().toString());
                builder.endObject();
            }
            builder.endObject();
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)((Object)o);
            return Objects.equals(this.actions, response.actions);
        }

        public int hashCode() {
            return Objects.hash(this.actions);
        }
    }
}

