/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.upgrade.actions;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.MasterNodeReadOperationRequestBuilder;
import org.elasticsearch.action.support.master.MasterNodeReadRequest;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.upgrade.IndexUpgradeService;

public class IndexUpgradeAction
extends Action<Request, BulkByScrollResponse, RequestBuilder> {
    public static final IndexUpgradeAction INSTANCE = new IndexUpgradeAction();
    public static final String NAME = "cluster:admin/xpack/upgrade";

    private IndexUpgradeAction() {
        super(NAME);
    }

    public RequestBuilder newRequestBuilder(ElasticsearchClient client) {
        return new RequestBuilder(client, this);
    }

    public BulkByScrollResponse newResponse() {
        return new BulkByScrollResponse();
    }

    public static class TransportAction
    extends TransportMasterNodeAction<Request, BulkByScrollResponse> {
        private final IndexUpgradeService indexUpgradeService;

        @Inject
        public TransportAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexUpgradeService indexUpgradeService, IndexNameExpressionResolver indexNameExpressionResolver) {
            super(settings, IndexUpgradeAction.NAME, transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, Request::new);
            this.indexUpgradeService = indexUpgradeService;
        }

        protected String executor() {
            return "generic";
        }

        protected BulkByScrollResponse newResponse() {
            return new BulkByScrollResponse();
        }

        protected ClusterBlockException checkBlock(Request request, ClusterState state) {
            return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
        }

        protected final void masterOperation(Task task, Request request, ClusterState state, ActionListener<BulkByScrollResponse> listener) {
            TaskId taskId = new TaskId(this.clusterService.localNode().getId(), task.getId());
            this.indexUpgradeService.upgrade(taskId, request.index(), state, listener);
        }

        protected final void masterOperation(Request request, ClusterState state, ActionListener<BulkByScrollResponse> listener) {
            throw new UnsupportedOperationException("the task parameter is required");
        }
    }

    public static class RequestBuilder
    extends MasterNodeReadOperationRequestBuilder<Request, BulkByScrollResponse, RequestBuilder> {
        protected RequestBuilder(ElasticsearchClient client, IndexUpgradeAction action) {
            super(client, (Action)action, (MasterNodeReadRequest)new Request());
        }

        public RequestBuilder setIndex(String index) {
            ((Request)this.request).index(index);
            return this;
        }
    }

    public static class Request
    extends MasterNodeReadRequest<Request>
    implements IndicesRequest {
        private String index = null;
        private boolean shouldStoreResult;

        public Request() {
        }

        public Request(String index) {
            this.index = index;
        }

        public String index() {
            return this.index;
        }

        public final Request index(String index) {
            this.index = index;
            return this;
        }

        public String[] indices() {
            return new String[]{this.index};
        }

        public IndicesOptions indicesOptions() {
            return IndexUpgradeService.UPGRADE_INDEX_OPTIONS;
        }

        public Request setShouldStoreResult(boolean shouldStoreResult) {
            this.shouldStoreResult = shouldStoreResult;
            return this;
        }

        public boolean getShouldStoreResult() {
            return this.shouldStoreResult;
        }

        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            if (this.index == null) {
                validationException = ValidateActions.addValidationError((String)"index is missing", validationException);
            }
            return validationException;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.index = in.readString();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.index);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)((Object)o);
            return Objects.equals(this.index, request.index);
        }

        public int hashCode() {
            return Objects.hash(this.index);
        }

        public Task createTask(long id, String type, String action, TaskId parentTaskId) {
            return new CancellableTask(id, type, action, this.getDescription(), parentTaskId){

                public boolean shouldCancelChildrenOnCancellation() {
                    return true;
                }
            };
        }
    }
}

