/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.upgrade;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.GenericAction;
import org.elasticsearch.action.admin.indices.template.delete.DeleteIndexTemplateResponse;
import org.elasticsearch.action.admin.indices.template.put.PutIndexTemplateResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.indices.IndexTemplateMissingException;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.script.ScriptType;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.watcher.ResourceWatcherService;
import org.elasticsearch.xpack.security.InternalClient;
import org.elasticsearch.xpack.security.InternalSecurityClient;
import org.elasticsearch.xpack.security.crypto.CryptoService;
import org.elasticsearch.xpack.security.support.IndexLifecycleManager;
import org.elasticsearch.xpack.template.TemplateUtils;
import org.elasticsearch.xpack.upgrade.IndexUpgradeCheck;
import org.elasticsearch.xpack.upgrade.IndexUpgradeService;
import org.elasticsearch.xpack.upgrade.UpgradeActionRequired;
import org.elasticsearch.xpack.upgrade.actions.IndexUpgradeAction;
import org.elasticsearch.xpack.upgrade.actions.IndexUpgradeInfoAction;
import org.elasticsearch.xpack.upgrade.rest.RestIndexUpgradeAction;
import org.elasticsearch.xpack.upgrade.rest.RestIndexUpgradeInfoAction;
import org.elasticsearch.xpack.watcher.client.WatcherClient;
import org.elasticsearch.xpack.watcher.transport.actions.service.WatcherServiceRequest;
import org.elasticsearch.xpack.watcher.transport.actions.service.WatcherServiceResponse;

public class Upgrade
implements ActionPlugin {
    public static final Version UPGRADE_INTRODUCED = Version.V_5_6_0;
    private static final int EXPECTED_INDEX_FORMAT_VERSION = 6;
    private final Settings settings;
    private final List<BiFunction<InternalClient, ClusterService, IndexUpgradeCheck>> upgradeCheckFactories;

    public Upgrade(Settings settings) {
        this.settings = settings;
        this.upgradeCheckFactories = new ArrayList<BiFunction<InternalClient, ClusterService, IndexUpgradeCheck>>();
        this.upgradeCheckFactories.add(Upgrade.getWatchesIndexUpgradeCheckFactory(settings));
        this.upgradeCheckFactories.add(Upgrade.getTriggeredWatchesIndexUpgradeCheckFactory(settings));
        this.upgradeCheckFactories.add(Upgrade.getSecurityUpgradeCheckFactory(settings));
    }

    public Collection<Object> createComponents(Client client, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, CryptoService cryptoService) {
        InternalSecurityClient internalSecurityClient = new InternalSecurityClient(this.settings, threadPool, client, cryptoService);
        ArrayList<IndexUpgradeCheck> upgradeChecks = new ArrayList<IndexUpgradeCheck>(this.upgradeCheckFactories.size());
        for (BiFunction<InternalClient, ClusterService, IndexUpgradeCheck> checkFactory : this.upgradeCheckFactories) {
            upgradeChecks.add(checkFactory.apply(internalSecurityClient, clusterService));
        }
        return Collections.singletonList(new IndexUpgradeService(this.settings, Collections.unmodifiableList(upgradeChecks)));
    }

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        return Arrays.asList(new ActionPlugin.ActionHandler((GenericAction)IndexUpgradeInfoAction.INSTANCE, IndexUpgradeInfoAction.TransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((GenericAction)IndexUpgradeAction.INSTANCE, IndexUpgradeAction.TransportAction.class, new Class[0]));
    }

    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        return Arrays.asList(new RestHandler[]{new RestIndexUpgradeInfoAction(settings, restController), new RestIndexUpgradeAction(settings, restController)});
    }

    public static boolean checkInternalIndexFormat(IndexMetaData indexMetaData) {
        return indexMetaData.getSettings().getAsInt(IndexMetaData.INDEX_FORMAT_SETTING.getKey(), Integer.valueOf(0)) == 6;
    }

    static BiFunction<InternalClient, ClusterService, IndexUpgradeCheck> getSecurityUpgradeCheckFactory(Settings settings) {
        return (internalClient, clusterService) -> new IndexUpgradeCheck<Void>("security", settings, indexMetaData -> {
            if (".security".equals(indexMetaData.getIndex().getName()) || indexMetaData.getAliases().containsKey((Object)".security")) {
                if (Upgrade.checkInternalIndexFormat(indexMetaData)) {
                    return UpgradeActionRequired.UP_TO_DATE;
                }
                return UpgradeActionRequired.UPGRADE;
            }
            return UpgradeActionRequired.NOT_APPLICABLE;
        }, (Client)internalClient, (ClusterService)clusterService, new String[]{"user", "reserved-user", "role", "doc"}, new Script(ScriptType.INLINE, "painless", "ctx._source.type = ctx._type;\nif (!ctx._type.equals(\"doc\")) {\n   ctx._id = ctx._type + \"-\" + ctx._id;\n}\nctx._type = \"doc\";", new HashMap()), voidListener -> Upgrade.preSecurityUpgrade((Client)internalClient, (ActionListener<Void>)voidListener), (success, listener) -> listener.onResponse(null));
    }

    private static void preSecurityUpgrade(Client client, final ActionListener<Void> listener) {
        byte[] templateBytes = TemplateUtils.loadTemplate("/security-index-template-v6.json", Version.CURRENT.toString(), IndexLifecycleManager.TEMPLATE_VERSION_PATTERN).getBytes(StandardCharsets.UTF_8);
        client.admin().indices().preparePutTemplate("security-index-template-v6").setSource(templateBytes, XContentType.JSON).execute((ActionListener)new ActionListener<PutIndexTemplateResponse>(){

            public void onResponse(PutIndexTemplateResponse putIndexTemplateResponse) {
                if (putIndexTemplateResponse.isAcknowledged()) {
                    listener.onResponse(null);
                } else {
                    listener.onFailure((Exception)new IllegalStateException("unable to create new security template"));
                }
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        });
    }

    static BiFunction<InternalClient, ClusterService, IndexUpgradeCheck> getWatchesIndexUpgradeCheckFactory(Settings settings) {
        return (internalClient, clusterService) -> new IndexUpgradeCheck<Boolean>("watches", settings, indexMetaData -> {
            if (Upgrade.indexOrAliasExists(indexMetaData, ".watches")) {
                if (Upgrade.checkInternalIndexFormat(indexMetaData)) {
                    return UpgradeActionRequired.UP_TO_DATE;
                }
                return UpgradeActionRequired.UPGRADE;
            }
            return UpgradeActionRequired.NOT_APPLICABLE;
        }, (Client)internalClient, (ClusterService)clusterService, new String[]{"watch"}, new Script(ScriptType.INLINE, "painless", "ctx._type = \"doc\";\nif (ctx._source.containsKey(\"_status\") && !ctx._source.containsKey(\"status\")  ) {\n  ctx._source.status = ctx._source.remove(\"_status\");\n}", new HashMap()), booleanActionListener -> Upgrade.preWatchesIndexUpgrade((Client)internalClient, (ActionListener<Boolean>)booleanActionListener), (shouldStartWatcher, listener) -> Upgrade.postWatchesIndexUpgrade((Client)internalClient, shouldStartWatcher, (ActionListener<TransportResponse.Empty>)listener));
    }

    static BiFunction<InternalClient, ClusterService, IndexUpgradeCheck> getTriggeredWatchesIndexUpgradeCheckFactory(Settings settings) {
        return (internalClient, clusterService) -> new IndexUpgradeCheck<Boolean>("triggered-watches", settings, indexMetaData -> {
            if (Upgrade.indexOrAliasExists(indexMetaData, ".triggered_watches")) {
                if (Upgrade.checkInternalIndexFormat(indexMetaData)) {
                    return UpgradeActionRequired.UP_TO_DATE;
                }
                return UpgradeActionRequired.UPGRADE;
            }
            return UpgradeActionRequired.NOT_APPLICABLE;
        }, (Client)internalClient, (ClusterService)clusterService, new String[]{"triggered-watch"}, new Script(ScriptType.INLINE, "painless", "ctx._type = \"doc\";\n", new HashMap()), booleanActionListener -> Upgrade.preTriggeredWatchesIndexUpgrade((Client)internalClient, (ActionListener<Boolean>)booleanActionListener), (shouldStartWatcher, listener) -> Upgrade.postWatchesIndexUpgrade((Client)internalClient, shouldStartWatcher, (ActionListener<TransportResponse.Empty>)listener));
    }

    private static boolean indexOrAliasExists(IndexMetaData indexMetaData, String name) {
        return name.equals(indexMetaData.getIndex().getName()) || indexMetaData.getAliases().containsKey((Object)name);
    }

    static void preTriggeredWatchesIndexUpgrade(Client client, ActionListener<Boolean> listener) {
        new WatcherClient(client).prepareWatcherStats().execute(ActionListener.wrap(stats -> {
            if (stats.getWatcherMetaData().manuallyStopped()) {
                Upgrade.preTriggeredWatchesIndexUpgrade(client, listener, false);
            } else {
                new WatcherClient(client).prepareWatchService().stop().execute(ActionListener.wrap(watcherServiceResponse -> {
                    if (watcherServiceResponse.isAcknowledged()) {
                        Upgrade.preTriggeredWatchesIndexUpgrade(client, listener, true);
                    } else {
                        listener.onFailure((Exception)new IllegalStateException("unable to stop watcher service"));
                    }
                }, arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private static void preTriggeredWatchesIndexUpgrade(Client client, ActionListener<Boolean> listener, boolean restart) {
        String legacyTriggeredWatchesTemplateName = "triggered_watches";
        ActionListener<DeleteIndexTemplateResponse> returnToCallerListener = Upgrade.deleteIndexTemplateListener("triggered_watches", listener, () -> listener.onResponse((Object)restart));
        ActionListener<PutIndexTemplateResponse> putTriggeredWatchesListener = Upgrade.putIndexTemplateListener(".triggered_watches", listener, () -> client.admin().indices().prepareDeleteTemplate("triggered_watches").execute(returnToCallerListener));
        byte[] triggeredWatchesTemplate = TemplateUtils.loadTemplate("/triggered-watches.json", "6", Pattern.quote("${xpack.watcher.template.version}")).getBytes(StandardCharsets.UTF_8);
        client.admin().indices().preparePutTemplate(".triggered_watches").setSource(triggeredWatchesTemplate, XContentType.JSON).execute(putTriggeredWatchesListener);
    }

    static void preWatchesIndexUpgrade(Client client, ActionListener<Boolean> listener) {
        new WatcherClient(client).prepareWatcherStats().execute(ActionListener.wrap(stats -> {
            if (stats.getWatcherMetaData().manuallyStopped()) {
                Upgrade.preWatchesIndexUpgrade(client, listener, false);
            } else {
                new WatcherClient(client).prepareWatchService().stop().execute(ActionListener.wrap(watcherServiceResponse -> {
                    if (watcherServiceResponse.isAcknowledged()) {
                        Upgrade.preWatchesIndexUpgrade(client, listener, true);
                    } else {
                        listener.onFailure((Exception)new IllegalStateException("unable to stop watcher service"));
                    }
                }, arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private static void preWatchesIndexUpgrade(Client client, ActionListener<Boolean> listener, boolean restart) {
        String legacyWatchesTemplateName = "watches";
        ActionListener<DeleteIndexTemplateResponse> returnToCallerListener = Upgrade.deleteIndexTemplateListener("watches", listener, () -> listener.onResponse((Object)restart));
        ActionListener<PutIndexTemplateResponse> putTriggeredWatchesListener = Upgrade.putIndexTemplateListener(".triggered_watches", listener, () -> client.admin().indices().prepareDeleteTemplate("watches").execute(returnToCallerListener));
        byte[] watchesTemplate = TemplateUtils.loadTemplate("/watches.json", "6", Pattern.quote("${xpack.watcher.template.version}")).getBytes(StandardCharsets.UTF_8);
        ActionListener<DeleteIndexTemplateResponse> putTriggeredWatchesTemplateListener = Upgrade.deleteIndexTemplateListener("watch_history_*", listener, () -> client.admin().indices().preparePutTemplate(".watches").setSource(watchesTemplate, XContentType.JSON).execute(putTriggeredWatchesListener));
        client.admin().indices().prepareDeleteTemplate("watch_history_*").execute(putTriggeredWatchesTemplateListener);
    }

    static void postWatchesIndexUpgrade(Client client, boolean shouldStartWatcher, ActionListener<TransportResponse.Empty> listener) {
        if (shouldStartWatcher) {
            new WatcherClient(client).watcherService(new WatcherServiceRequest().start(), (ActionListener<WatcherServiceResponse>)ActionListener.wrap(r -> listener.onResponse((Object)TransportResponse.Empty.INSTANCE), arg_0 -> listener.onFailure(arg_0)));
        } else {
            listener.onResponse((Object)TransportResponse.Empty.INSTANCE);
        }
    }

    private static ActionListener<PutIndexTemplateResponse> putIndexTemplateListener(String name, ActionListener<Boolean> listener, Runnable runnable) {
        return ActionListener.wrap(r -> {
            if (r.isAcknowledged()) {
                runnable.run();
            } else {
                listener.onFailure((Exception)((Object)new ElasticsearchException("Putting [{}] template was not acknowledged", new Object[]{name})));
            }
        }, arg_0 -> listener.onFailure(arg_0));
    }

    private static ActionListener<DeleteIndexTemplateResponse> deleteIndexTemplateListener(String name, ActionListener<Boolean> listener, Runnable runnable) {
        return ActionListener.wrap(r -> {
            if (r.isAcknowledged()) {
                runnable.run();
            } else {
                listener.onFailure((Exception)((Object)new ElasticsearchException("Deleting [{}] template was not acknowledged", new Object[]{name})));
            }
        }, e -> {
            if (e instanceof IndexTemplateMissingException) {
                runnable.run();
            } else {
                listener.onFailure(e);
            }
        });
    }
}

