/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.transport.netty3;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLEngine;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.internal.Nullable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.netty3.Netty3Transport;
import org.elasticsearch.xpack.XPackSettings;
import org.elasticsearch.xpack.security.Security;
import org.elasticsearch.xpack.security.transport.SSLExceptionHelper;
import org.elasticsearch.xpack.security.transport.filter.IPFilter;
import org.elasticsearch.xpack.security.transport.netty3.IPFilterNetty3UpstreamHandler;
import org.elasticsearch.xpack.security.transport.netty3.Netty3HandshakeWaitingHandler;
import org.elasticsearch.xpack.ssl.SSLConfiguration;
import org.elasticsearch.xpack.ssl.SSLService;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.handler.ssl.SslHandler;

public class SecurityNetty3Transport
extends Netty3Transport {
    public static final Setting<Boolean> PROFILE_SSL_SETTING = Setting.boolSetting((String)Security.setting("ssl.enabled"), (boolean)false, (Setting.Property[])new Setting.Property[0]);
    private final SSLService sslService;
    @Nullable
    private final IPFilter authenticator;
    private final boolean defaultTransportSslEnabled;
    private final SSLConfiguration sslConfiguration;
    private final Map<String, SSLConfiguration> profileConfiguration;

    @Inject
    public SecurityNetty3Transport(Settings settings, ThreadPool threadPool, NetworkService networkService, BigArrays bigArrays, @Nullable IPFilter authenticator, SSLService sslService, NamedWriteableRegistry namedWriteableRegistry, CircuitBreakerService circuitBreakerService) {
        super(settings, threadPool, networkService, bigArrays, namedWriteableRegistry, circuitBreakerService);
        this.authenticator = authenticator;
        this.defaultTransportSslEnabled = (Boolean)XPackSettings.TRANSPORT_SSL_ENABLED.get(settings);
        this.sslService = sslService;
        Settings transportSSLSettings = settings.getByPrefix(Security.setting("transport.ssl."));
        this.sslConfiguration = this.defaultTransportSslEnabled ? sslService.sslConfiguration(transportSSLSettings, Settings.EMPTY) : null;
        Map profileSettingsMap = settings.getGroups("transport.profiles.", true);
        HashMap<String, SSLConfiguration> profileConfiguration = new HashMap<String, SSLConfiguration>(profileSettingsMap.size() + 1);
        if (this.sslConfiguration != null) {
            this.validateProfileSettings(sslService, transportSSLSettings, "default", transportSSLSettings);
            profileConfiguration.put("default", this.sslConfiguration);
        } else {
            profileConfiguration.put("default", null);
        }
        for (Map.Entry entry : profileSettingsMap.entrySet()) {
            Settings profileSettings = (Settings)entry.getValue();
            String name = (String)entry.getKey();
            if (SecurityNetty3Transport.isProfileSSLEnabled(profileSettings, this.defaultTransportSslEnabled)) {
                Settings profileSslSettings = profileSettings.getByPrefix(Security.setting("ssl."));
                SSLConfiguration configuration = sslService.sslConfiguration(profileSslSettings, transportSSLSettings);
                this.validateProfileSettings(sslService, transportSSLSettings, name, profileSslSettings);
                profileConfiguration.put(name, configuration);
                continue;
            }
            profileConfiguration.put(name, null);
        }
        this.profileConfiguration = Collections.unmodifiableMap(profileConfiguration);
    }

    void validateProfileSettings(SSLService sslService, Settings transportSSLSettings, String name, Settings profileSslSettings) {
        if (((Boolean)NetworkService.NETWORK_SERVER.get(this.settings)).booleanValue() && !sslService.isConfigurationValidForServerUsage(profileSslSettings, transportSSLSettings)) {
            if ("default".equals(name)) {
                throw new IllegalArgumentException("a key must be provided to run as a server. the key should be configured using the [xpack.security.transport.ssl.key] or [xpack.security.transport.ssl.keystore.path] setting");
            }
            throw new IllegalArgumentException("a key must be provided to run as a server. the key should be configured using the [transport.profiles." + name + ".xpack.security.ssl.key] or [transport.profiles." + name + ".xpack.security.ssl.keystore.path] setting");
        }
    }

    protected String deprecationMessage() {
        return "transport type [security3] is deprecated";
    }

    protected void doStart() {
        super.doStart();
        if (this.authenticator != null) {
            this.authenticator.setBoundTransportAddress(this.boundAddress(), this.profileBoundAddresses());
        }
    }

    public ChannelPipelineFactory configureClientChannelPipelineFactory() {
        return new SslClientChannelPipelineFactory();
    }

    public ChannelPipelineFactory configureServerChannelPipelineFactory(String name, Settings profileSettings) {
        if (!this.profileConfiguration.containsKey(name)) {
            throw new IllegalStateException("unknown profile: " + name);
        }
        SSLConfiguration configuration = this.profileConfiguration.get(name);
        return new SslServerChannelPipelineFactory(name, this.settings, configuration);
    }

    protected void onException(Channel channel, Exception e) throws IOException {
        if (SSLExceptionHelper.isNotSslRecordException(e)) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace(() -> new ParameterizedMessage("received plaintext traffic on a encrypted channel, closing connection {}", (Object)channel), (Throwable)e);
            } else {
                this.logger.warn("received plaintext traffic on a encrypted channel, closing connection {}", (Object)channel);
            }
            this.closeChannelWhileHandlingExceptions(channel);
        } else if (SSLExceptionHelper.isCloseDuringHandshakeException(e)) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace(() -> new ParameterizedMessage("connection {} closed during handshake", (Object)channel), (Throwable)e);
            } else {
                this.logger.warn("connection {} closed during handshake", (Object)channel);
            }
            this.closeChannelWhileHandlingExceptions(channel);
        } else {
            super.onException((Object)channel, e);
        }
    }

    public static Settings profileSslSettings(Settings profileSettings) {
        return profileSettings.getByPrefix(Security.setting("ssl."));
    }

    private static boolean isProfileSSLEnabled(Settings profileSettings, boolean defaultTransportSSL) {
        return PROFILE_SSL_SETTING.exists(profileSettings) ? (Boolean)PROFILE_SSL_SETTING.get(profileSettings) : defaultTransportSSL;
    }

    private class SslClientChannelPipelineFactory
    extends Netty3Transport.ClientChannelPipelineFactory {
        SslClientChannelPipelineFactory() {
            super((Netty3Transport)SecurityNetty3Transport.this);
        }

        public ChannelPipeline getPipeline() throws Exception {
            ChannelPipeline pipeline = super.getPipeline();
            if (SecurityNetty3Transport.this.sslConfiguration != null) {
                pipeline.addFirst("sslInitializer", (ChannelHandler)new ClientSslHandlerInitializer());
            }
            return pipeline;
        }

        private class ClientSslHandlerInitializer
        extends SimpleChannelHandler {
            private ClientSslHandlerInitializer() {
            }

            public void connectRequested(ChannelHandlerContext ctx, ChannelStateEvent e) {
                SSLEngine sslEngine;
                if (SecurityNetty3Transport.this.sslConfiguration.verificationMode().isHostnameVerificationEnabled()) {
                    InetSocketAddress inetSocketAddress = (InetSocketAddress)e.getValue();
                    sslEngine = SecurityNetty3Transport.this.sslService.createSSLEngine(SecurityNetty3Transport.this.sslConfiguration, inetSocketAddress.getHostString(), inetSocketAddress.getPort());
                } else {
                    sslEngine = SecurityNetty3Transport.this.sslService.createSSLEngine(SecurityNetty3Transport.this.sslConfiguration, null, -1);
                }
                sslEngine.setUseClientMode(true);
                ctx.getPipeline().replace((ChannelHandler)this, "ssl", (ChannelHandler)new SslHandler(sslEngine));
                ctx.getPipeline().addAfter("ssl", "handshake", (ChannelHandler)new Netty3HandshakeWaitingHandler(SecurityNetty3Transport.this.logger));
                ctx.sendDownstream((ChannelEvent)e);
            }
        }
    }

    private class SslServerChannelPipelineFactory
    extends Netty3Transport.ServerChannelPipelineFactory {
        private final SSLConfiguration configuration;

        SslServerChannelPipelineFactory(String name, Settings settings, SSLConfiguration configuration) {
            super((Netty3Transport)SecurityNetty3Transport.this, name, settings);
            this.configuration = configuration;
        }

        public ChannelPipeline getPipeline() throws Exception {
            ChannelPipeline pipeline = super.getPipeline();
            if (this.configuration != null) {
                SSLEngine serverEngine = SecurityNetty3Transport.this.sslService.createSSLEngine(this.configuration, null, -1);
                serverEngine.setUseClientMode(false);
                pipeline.addFirst("ssl", (ChannelHandler)new SslHandler(serverEngine));
            }
            if (SecurityNetty3Transport.this.authenticator != null) {
                pipeline.addFirst("ipfilter", (ChannelHandler)new IPFilterNetty3UpstreamHandler(SecurityNetty3Transport.this.authenticator, this.name));
            }
            return pipeline;
        }
    }
}

