/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authz;

import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.index.shard.SearchOperationListener;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.search.SearchContextMissingException;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.transport.TransportMessage;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.xpack.security.audit.AuditTrailService;
import org.elasticsearch.xpack.security.authc.Authentication;

public final class SecuritySearchOperationListener
implements SearchOperationListener {
    private final ThreadContext threadContext;
    private final XPackLicenseState licenseState;
    private final AuditTrailService auditTrailService;

    public SecuritySearchOperationListener(ThreadContext threadContext, XPackLicenseState licenseState, AuditTrailService auditTrail) {
        this.threadContext = threadContext;
        this.licenseState = licenseState;
        this.auditTrailService = auditTrail;
    }

    public void onNewScrollContext(SearchContext searchContext) {
        if (this.licenseState.isAuthAllowed()) {
            searchContext.scrollContext().putInContext("_xpack_security_authentication", (Object)Authentication.getAuthentication(this.threadContext));
        }
    }

    public void validateSearchContext(SearchContext searchContext, TransportRequest request) {
        if (this.licenseState.isAuthAllowed() && searchContext.scrollContext() != null) {
            Authentication originalAuth = (Authentication)searchContext.scrollContext().getFromContext("_xpack_security_authentication");
            Authentication current = Authentication.getAuthentication(this.threadContext);
            String action = (String)this.threadContext.getTransient("_originating_action_name");
            SecuritySearchOperationListener.ensureAuthenticatedUserIsSame(originalAuth, current, this.auditTrailService, searchContext.id(), action, request);
        }
    }

    static void ensureAuthenticatedUserIsSame(Authentication original, Authentication current, AuditTrailService auditTrailService, long id, String action, TransportRequest request) {
        boolean sameUser;
        boolean samePrincipal = original.getUser().principal().equals(current.getUser().principal());
        boolean sameRealmType = original.getUser().isRunAs() ? (current.getUser().isRunAs() ? original.getLookedUpBy().getType().equals(current.getLookedUpBy().getType()) : original.getLookedUpBy().getType().equals(current.getAuthenticatedBy().getType())) : (current.getUser().isRunAs() ? original.getAuthenticatedBy().getType().equals(current.getLookedUpBy().getType()) : original.getAuthenticatedBy().getType().equals(current.getAuthenticatedBy().getType()));
        boolean bl = sameUser = samePrincipal && sameRealmType;
        if (!sameUser) {
            auditTrailService.accessDenied(current.getUser(), action, (TransportMessage)request);
            throw new SearchContextMissingException(id);
        }
    }
}

