/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.support;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.xpack.security.authc.RealmConfig;
import org.elasticsearch.xpack.security.authc.support.CachingUsernamePasswordRealm;

public interface UserRoleMapper {
    public void resolveRoles(UserData var1, ActionListener<Set<String>> var2);

    public void refreshRealmOnChange(CachingUsernamePasswordRealm var1);

    public static class UserData {
        private final String username;
        @Nullable
        private final String dn;
        private final Set<String> groups;
        private final Map<String, Object> metadata;
        private final RealmConfig realm;

        public UserData(String username, @Nullable String dn, Collection<String> groups, Map<String, Object> metadata, RealmConfig realm) {
            this.username = username;
            this.dn = dn;
            this.groups = groups == null || groups.isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(new HashSet<String>(groups));
            this.metadata = metadata == null || metadata.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(metadata);
            this.realm = realm;
        }

        public Map<String, Object> asMap() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("username", this.username);
            map.put("dn", this.dn);
            map.put("groups", this.groups);
            this.metadata.keySet().forEach(k -> map.put("metadata." + k, this.metadata.get(k)));
            map.put("realm.name", this.realm.name());
            return map;
        }

        public String toString() {
            return "UserData{username:" + this.username + "; dn:" + this.dn + "; groups:" + this.groups + "; metadata:" + this.metadata + "; realm=" + this.realm.name() + '}';
        }

        public String getUsername() {
            return this.username;
        }

        @Nullable
        public String getDn() {
            return this.dn;
        }

        public Set<String> getGroups() {
            return this.groups;
        }

        public Map<String, Object> getMetadata() {
            return this.metadata;
        }

        public RealmConfig getRealm() {
            return this.realm;
        }
    }
}

