/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.esnative;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetRequestBuilder;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.update.UpdateRequestBuilder;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.client.Requests;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.engine.DocumentMissingException;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.xpack.XPackPlugin;
import org.elasticsearch.xpack.security.InternalClient;
import org.elasticsearch.xpack.security.InternalSecurityClient;
import org.elasticsearch.xpack.security.SecurityLifecycleService;
import org.elasticsearch.xpack.security.action.realm.ClearRealmCacheRequest;
import org.elasticsearch.xpack.security.action.realm.ClearRealmCacheResponse;
import org.elasticsearch.xpack.security.action.user.ChangePasswordRequest;
import org.elasticsearch.xpack.security.action.user.DeleteUserRequest;
import org.elasticsearch.xpack.security.action.user.PutUserRequest;
import org.elasticsearch.xpack.security.authc.esnative.ReservedRealm;
import org.elasticsearch.xpack.security.authc.esnative.UserAndPassword;
import org.elasticsearch.xpack.security.authc.support.Hasher;
import org.elasticsearch.xpack.security.client.SecurityClient;
import org.elasticsearch.xpack.security.user.User;

public class NativeUsersStore
extends AbstractComponent {
    private static final String USER_DOC_TYPE = "user";
    public static final String RESERVED_USER_DOC_TYPE = "reserved-user";
    private static final String NEW_INDEX_TYPE = "doc";
    private final Hasher hasher = Hasher.BCRYPT;
    private final InternalSecurityClient client;
    private final boolean isTribeNode;
    private volatile SecurityLifecycleService securityLifecycleService;

    public NativeUsersStore(Settings settings, InternalSecurityClient client, SecurityLifecycleService securityLifecycleService) {
        super(settings);
        this.client = client;
        this.isTribeNode = XPackPlugin.isTribeNode(settings);
        this.securityLifecycleService = securityLifecycleService;
    }

    public void getUser(String username, ActionListener<User> listener) {
        this.getUserAndPassword(username, (ActionListener<UserAndPassword>)ActionListener.wrap(uap -> listener.onResponse((Object)(uap == null ? null : uap.user())), arg_0 -> listener.onFailure(arg_0)));
    }

    public void getUsers(String[] userNames, ActionListener<Collection<User>> listener) {
        Consumer<Exception> handleException = t -> {
            if (t instanceof IndexNotFoundException) {
                this.logger.trace("could not retrieve users because security index does not exist");
                listener.onResponse(Collections.emptyList());
            } else {
                listener.onFailure(t);
            }
        };
        if (userNames.length == 1) {
            String username = userNames[0];
            this.getUserAndPassword(username, (ActionListener<UserAndPassword>)ActionListener.wrap(uap -> listener.onResponse(uap == null ? Collections.emptyList() : Collections.singletonList(uap.user())), handleException::accept));
        } else {
            try {
                Object query;
                boolean isNewSecurityIndexVersion = this.securityLifecycleService.isSecurityIndexOnNewVersion();
                if (isNewSecurityIndexVersion) {
                    if (userNames == null || userNames.length == 0) {
                        query = QueryBuilders.termQuery((String)User.Fields.TYPE.getPreferredName(), (String)USER_DOC_TYPE);
                    } else {
                        String[] users = (String[])Arrays.asList(userNames).stream().map(s -> NativeUsersStore.getIdForUser(USER_DOC_TYPE, s)).toArray(String[]::new);
                        query = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.idsQuery((String[])new String[]{NEW_INDEX_TYPE}).addIds(users));
                    }
                } else {
                    query = userNames == null || userNames.length == 0 ? QueryBuilders.matchAllQuery() : QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.idsQuery((String[])new String[]{USER_DOC_TYPE}).addIds(userNames));
                }
                SearchRequest request = (SearchRequest)this.client.prepareSearch(new String[]{".security"}).setScroll(TimeValue.timeValueSeconds((long)10L)).setTypes(new String[]{isNewSecurityIndexVersion ? NEW_INDEX_TYPE : USER_DOC_TYPE}).setQuery((QueryBuilder)query).setSize(1000).setFetchSource(true).request();
                request.indicesOptions().ignoreUnavailable();
                InternalClient.fetchAllByEntity((Client)this.client, request, listener, hit -> {
                    String username;
                    if (isNewSecurityIndexVersion) {
                        String id = hit.getId();
                        assert (id != null && id.startsWith(USER_DOC_TYPE)) : "id [" + id + "] does not start with user prefix";
                        username = id.substring(USER_DOC_TYPE.length() + 1);
                    } else {
                        username = hit.getId();
                    }
                    UserAndPassword u = this.transformUser(username, hit.getSource());
                    return u != null ? u.user() : null;
                });
            }
            catch (Exception e) {
                this.logger.error(() -> new ParameterizedMessage("unable to retrieve users {}", (Object)Arrays.toString(userNames)), (Throwable)e);
                listener.onFailure(e);
            }
        }
    }

    private void getUserAndPassword(final String user, final ActionListener<UserAndPassword> listener) {
        try {
            final boolean isNewSecurityIndexVersion = this.securityLifecycleService.isSecurityIndexOnNewVersion();
            GetRequest request = isNewSecurityIndexVersion ? (GetRequest)this.client.prepareGet(".security", NEW_INDEX_TYPE, NativeUsersStore.getIdForUser(USER_DOC_TYPE, user)).request() : (GetRequest)this.client.prepareGet(".security", USER_DOC_TYPE, user).request();
            this.client.get(request, (ActionListener)new ActionListener<GetResponse>(){

                public void onResponse(GetResponse response) {
                    String username;
                    if (isNewSecurityIndexVersion) {
                        String id = response.getId();
                        assert (id != null && id.startsWith(NativeUsersStore.USER_DOC_TYPE)) : "id [" + id + "] does not start with user prefix";
                        username = id.substring(NativeUsersStore.USER_DOC_TYPE.length() + 1);
                    } else {
                        username = response.getId();
                    }
                    listener.onResponse((Object)NativeUsersStore.this.transformUser(username, response.getSource()));
                }

                public void onFailure(Exception t) {
                    if (t instanceof IndexNotFoundException) {
                        NativeUsersStore.this.logger.trace(() -> new ParameterizedMessage("could not retrieve user [{}] because security index does not exist", (Object)user), (Throwable)t);
                    } else {
                        NativeUsersStore.this.logger.error(() -> new ParameterizedMessage("failed to retrieve user [{}]", (Object)user), (Throwable)t);
                    }
                    listener.onResponse(null);
                }
            });
        }
        catch (IndexNotFoundException infe) {
            this.logger.trace("could not retrieve user [{}] because security index does not exist", (Object)user);
            listener.onResponse(null);
        }
        catch (Exception e) {
            this.logger.error(() -> new ParameterizedMessage("unable to retrieve user [{}]", (Object)user), (Throwable)e);
            listener.onFailure(e);
        }
    }

    public void changePassword(final ChangePasswordRequest request, final ActionListener<Void> listener) {
        final String username = request.username();
        assert (!"_system".equals(username) && !"_xpack".equals(username)) : username + "is internal!";
        if (this.isTribeNode) {
            listener.onFailure((Exception)new UnsupportedOperationException("users may not be created or modified using a tribe node"));
            return;
        }
        if (!this.securityLifecycleService.isSecurityIndexWriteable()) {
            listener.onFailure((Exception)new IllegalStateException("password cannot be changed as user service cannot write until template and mappings are up to date"));
            return;
        }
        final String docType = ReservedRealm.isReserved(username, this.settings) ? RESERVED_USER_DOC_TYPE : USER_DOC_TYPE;
        UpdateRequestBuilder updateRequest = this.securityLifecycleService.isSecurityIndexOnNewVersion() ? this.client.prepareUpdate(".security", NEW_INDEX_TYPE, NativeUsersStore.getIdForUser(docType, username)) : this.client.prepareUpdate(".security", docType, username);
        ((UpdateRequestBuilder)updateRequest.setDoc(Requests.INDEX_CONTENT_TYPE, new Object[]{User.Fields.PASSWORD.getPreferredName(), String.valueOf(request.passwordHash())}).setRefreshPolicy(request.getRefreshPolicy())).execute((ActionListener)new ActionListener<UpdateResponse>(){

            public void onResponse(UpdateResponse updateResponse) {
                assert (updateResponse.getResult() == DocWriteResponse.Result.UPDATED);
                NativeUsersStore.this.clearRealmCache(request.username(), listener, null);
            }

            public void onFailure(Exception e) {
                if (NativeUsersStore.isIndexNotFoundOrDocumentMissing(e)) {
                    if (docType.equals(NativeUsersStore.RESERVED_USER_DOC_TYPE)) {
                        NativeUsersStore.this.createReservedUser(username, request.passwordHash(), request.getRefreshPolicy(), (ActionListener<Void>)listener);
                    } else {
                        NativeUsersStore.this.logger.debug(() -> new ParameterizedMessage("failed to change password for user [{}]", (Object)request.username()), (Throwable)e);
                        ValidationException validationException = new ValidationException();
                        validationException.addValidationError("user must exist in order to change password");
                        listener.onFailure((Exception)validationException);
                    }
                } else {
                    listener.onFailure(e);
                }
            }
        });
    }

    private void createReservedUser(final String username, char[] passwordHash, WriteRequest.RefreshPolicy refresh, final ActionListener<Void> listener) {
        IndexRequestBuilder indexRequest;
        if (this.securityLifecycleService.isSecurityIndexOnNewVersion()) {
            String userId = NativeUsersStore.getIdForUser(RESERVED_USER_DOC_TYPE, username);
            indexRequest = this.client.prepareIndex(".security", NEW_INDEX_TYPE, userId).setSource(new Object[]{User.Fields.PASSWORD.getPreferredName(), String.valueOf(passwordHash), User.Fields.ENABLED.getPreferredName(), true, User.Fields.TYPE.getPreferredName(), RESERVED_USER_DOC_TYPE});
        } else {
            indexRequest = this.client.prepareIndex(".security", RESERVED_USER_DOC_TYPE, username).setSource(new Object[]{User.Fields.PASSWORD.getPreferredName(), String.valueOf(passwordHash), User.Fields.ENABLED.getPreferredName(), true});
        }
        ((IndexRequestBuilder)indexRequest.setRefreshPolicy(refresh)).execute((ActionListener)new ActionListener<IndexResponse>(){

            public void onResponse(IndexResponse indexResponse) {
                NativeUsersStore.this.clearRealmCache(username, listener, null);
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        });
    }

    public void putUser(PutUserRequest request, ActionListener<Boolean> listener) {
        if (this.isTribeNode) {
            listener.onFailure((Exception)new UnsupportedOperationException("users may not be created or modified using a tribe node"));
            return;
        }
        if (!this.securityLifecycleService.isSecurityIndexWriteable()) {
            listener.onFailure((Exception)new IllegalStateException("user cannot be created or changed as the user service cannot write until template and mappings are up to date"));
            return;
        }
        try {
            if (request.passwordHash() == null) {
                this.updateUserWithoutPassword(request, listener);
            } else {
                this.indexUser(request, listener);
            }
        }
        catch (Exception e) {
            this.logger.error(() -> new ParameterizedMessage("unable to put user [{}]", (Object)request.username()), (Throwable)e);
            listener.onFailure(e);
        }
    }

    private void updateUserWithoutPassword(final PutUserRequest putUserRequest, final ActionListener<Boolean> listener) {
        UpdateRequestBuilder updateRequest;
        assert (putUserRequest.passwordHash() == null);
        Object[] doc = new Object[]{User.Fields.USERNAME.getPreferredName(), putUserRequest.username(), User.Fields.ROLES.getPreferredName(), putUserRequest.roles(), User.Fields.FULL_NAME.getPreferredName(), putUserRequest.fullName(), User.Fields.EMAIL.getPreferredName(), putUserRequest.email(), User.Fields.METADATA.getPreferredName(), putUserRequest.metadata(), User.Fields.ENABLED.getPreferredName(), putUserRequest.enabled()};
        if (this.securityLifecycleService.isSecurityIndexOnNewVersion()) {
            Object[] newDocSource = new Object[doc.length + 2];
            System.arraycopy(doc, 0, newDocSource, 0, doc.length);
            newDocSource[newDocSource.length - 2] = User.Fields.TYPE.getPreferredName();
            newDocSource[newDocSource.length - 1] = USER_DOC_TYPE;
            doc = newDocSource;
            updateRequest = this.client.prepareUpdate(".security", NEW_INDEX_TYPE, NativeUsersStore.getIdForUser(USER_DOC_TYPE, putUserRequest.username()));
        } else {
            updateRequest = this.client.prepareUpdate(".security", USER_DOC_TYPE, putUserRequest.username());
        }
        WriteRequest.RefreshPolicy refreshPolicy = putUserRequest.getRefreshPolicy();
        ((UpdateRequestBuilder)updateRequest.setDoc(Requests.INDEX_CONTENT_TYPE, doc).setRefreshPolicy(refreshPolicy)).execute((ActionListener)new ActionListener<UpdateResponse>(){

            public void onResponse(UpdateResponse updateResponse) {
                assert (updateResponse.getResult() == DocWriteResponse.Result.UPDATED);
                NativeUsersStore.this.clearRealmCache(putUserRequest.username(), listener, false);
            }

            public void onFailure(Exception e) {
                Exception failure = e;
                if (NativeUsersStore.isIndexNotFoundOrDocumentMissing(e)) {
                    NativeUsersStore.this.logger.debug(() -> new ParameterizedMessage("failed to update user document with username [{}]", (Object)putUserRequest.username()), (Throwable)e);
                    ValidationException validationException = new ValidationException();
                    validationException.addValidationError("password must be specified unless you are updating an existing user");
                    failure = validationException;
                }
                listener.onFailure(failure);
            }
        });
    }

    private void indexUser(final PutUserRequest putUserRequest, final ActionListener<Boolean> listener) {
        IndexRequestBuilder indexRequest;
        assert (putUserRequest.passwordHash() != null);
        Object[] doc = new Object[]{User.Fields.USERNAME.getPreferredName(), putUserRequest.username(), User.Fields.PASSWORD.getPreferredName(), String.valueOf(putUserRequest.passwordHash()), User.Fields.ROLES.getPreferredName(), putUserRequest.roles(), User.Fields.FULL_NAME.getPreferredName(), putUserRequest.fullName(), User.Fields.EMAIL.getPreferredName(), putUserRequest.email(), User.Fields.METADATA.getPreferredName(), putUserRequest.metadata(), User.Fields.ENABLED.getPreferredName(), putUserRequest.enabled()};
        if (this.securityLifecycleService.isSecurityIndexOnNewVersion()) {
            Object[] newDocSource = new Object[doc.length + 2];
            System.arraycopy(doc, 0, newDocSource, 0, doc.length);
            newDocSource[newDocSource.length - 2] = User.Fields.TYPE.getPreferredName();
            newDocSource[newDocSource.length - 1] = USER_DOC_TYPE;
            doc = newDocSource;
            indexRequest = this.client.prepareIndex(".security", NEW_INDEX_TYPE, NativeUsersStore.getIdForUser(USER_DOC_TYPE, putUserRequest.username()));
        } else {
            indexRequest = this.client.prepareIndex(".security", USER_DOC_TYPE, putUserRequest.username());
        }
        ((IndexRequestBuilder)indexRequest.setSource(doc).setRefreshPolicy(putUserRequest.getRefreshPolicy())).execute((ActionListener)new ActionListener<IndexResponse>(){

            public void onResponse(IndexResponse updateResponse) {
                NativeUsersStore.this.clearRealmCache(putUserRequest.username(), listener, updateResponse.getResult() == DocWriteResponse.Result.CREATED);
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        });
    }

    public void setEnabled(String username, boolean enabled, WriteRequest.RefreshPolicy refreshPolicy, ActionListener<Void> listener) {
        if (this.isTribeNode) {
            listener.onFailure((Exception)new UnsupportedOperationException("users may not be created or modified using a tribe node"));
            return;
        }
        if (!this.securityLifecycleService.isSecurityIndexWriteable()) {
            listener.onFailure((Exception)new IllegalStateException("enabled status cannot be changed as user service cannot write until template and mappings are up to date"));
            return;
        }
        if (ReservedRealm.isReserved(username, this.settings)) {
            this.setReservedUserEnabled(username, enabled, refreshPolicy, true, listener);
        } else {
            this.setRegularUserEnabled(username, enabled, refreshPolicy, listener);
        }
    }

    private void setRegularUserEnabled(final String username, final boolean enabled, WriteRequest.RefreshPolicy refreshPolicy, final ActionListener<Void> listener) {
        UpdateRequestBuilder updateRequest = this.securityLifecycleService.isSecurityIndexOnNewVersion() ? this.client.prepareUpdate(".security", NEW_INDEX_TYPE, NativeUsersStore.getIdForUser(USER_DOC_TYPE, username)) : this.client.prepareUpdate(".security", USER_DOC_TYPE, username);
        try {
            ((UpdateRequestBuilder)updateRequest.setDoc(Requests.INDEX_CONTENT_TYPE, new Object[]{User.Fields.ENABLED.getPreferredName(), enabled}).setRefreshPolicy(refreshPolicy)).execute((ActionListener)new ActionListener<UpdateResponse>(){

                public void onResponse(UpdateResponse updateResponse) {
                    NativeUsersStore.this.clearRealmCache(username, listener, null);
                }

                public void onFailure(Exception e) {
                    Exception failure = e;
                    if (NativeUsersStore.isIndexNotFoundOrDocumentMissing(e)) {
                        NativeUsersStore.this.logger.debug(() -> new ParameterizedMessage("failed to {} user [{}]", (Object)(enabled ? "enable" : "disable"), (Object)username), (Throwable)e);
                        ValidationException validationException = new ValidationException();
                        validationException.addValidationError("only existing users can be " + (enabled ? "enabled" : "disabled"));
                        failure = validationException;
                    }
                    listener.onFailure(failure);
                }
            });
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    private void setReservedUserEnabled(final String username, boolean enabled, WriteRequest.RefreshPolicy refreshPolicy, final boolean clearCache, final ActionListener<Void> listener) {
        UpdateRequestBuilder updateRequest = this.securityLifecycleService.isSecurityIndexOnNewVersion() ? this.client.prepareUpdate(".security", NEW_INDEX_TYPE, NativeUsersStore.getIdForUser(RESERVED_USER_DOC_TYPE, username)).setUpsert(XContentType.JSON, new Object[]{User.Fields.PASSWORD.getPreferredName(), "", User.Fields.ENABLED.getPreferredName(), enabled, User.Fields.TYPE.getPreferredName(), RESERVED_USER_DOC_TYPE}) : this.client.prepareUpdate(".security", RESERVED_USER_DOC_TYPE, username).setUpsert(XContentType.JSON, new Object[]{User.Fields.PASSWORD.getPreferredName(), "", User.Fields.ENABLED.getPreferredName(), enabled});
        try {
            ((UpdateRequestBuilder)updateRequest.setDoc(Requests.INDEX_CONTENT_TYPE, new Object[]{User.Fields.ENABLED.getPreferredName(), enabled}).setRefreshPolicy(refreshPolicy)).execute((ActionListener)new ActionListener<UpdateResponse>(){

                public void onResponse(UpdateResponse updateResponse) {
                    if (clearCache) {
                        NativeUsersStore.this.clearRealmCache(username, listener, null);
                    } else {
                        listener.onResponse(null);
                    }
                }

                public void onFailure(Exception e) {
                    listener.onFailure(e);
                }
            });
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    public void deleteUser(final DeleteUserRequest deleteUserRequest, final ActionListener<Boolean> listener) {
        if (this.isTribeNode) {
            listener.onFailure((Exception)new UnsupportedOperationException("users may not be deleted using a tribe node"));
            return;
        }
        if (!this.securityLifecycleService.isSecurityIndexWriteable()) {
            listener.onFailure((Exception)new IllegalStateException("user cannot be deleted as user service cannot write until template and mappings are up to date"));
            return;
        }
        try {
            DeleteRequest request = this.securityLifecycleService.isSecurityIndexOnNewVersion() ? (DeleteRequest)this.client.prepareDelete(".security", NEW_INDEX_TYPE, NativeUsersStore.getIdForUser(USER_DOC_TYPE, deleteUserRequest.username())).request() : (DeleteRequest)this.client.prepareDelete(".security", USER_DOC_TYPE, deleteUserRequest.username()).request();
            request.indicesOptions().ignoreUnavailable();
            request.setRefreshPolicy(deleteUserRequest.getRefreshPolicy());
            this.client.delete(request, (ActionListener)new ActionListener<DeleteResponse>(){

                public void onResponse(DeleteResponse deleteResponse) {
                    NativeUsersStore.this.clearRealmCache(deleteUserRequest.username(), listener, deleteResponse.getResult() == DocWriteResponse.Result.DELETED);
                }

                public void onFailure(Exception e) {
                    listener.onFailure(e);
                }
            });
        }
        catch (Exception e) {
            this.logger.error("unable to remove user", (Throwable)e);
            listener.onFailure(e);
        }
    }

    void verifyPassword(String username, SecureString password, ActionListener<User> listener) {
        this.getUserAndPassword(username, (ActionListener<UserAndPassword>)ActionListener.wrap(userAndPassword -> {
            if (userAndPassword == null || userAndPassword.passwordHash() == null) {
                listener.onResponse(null);
            } else if (this.hasher.verify(password, userAndPassword.passwordHash())) {
                listener.onResponse((Object)userAndPassword.user());
            } else {
                listener.onResponse(null);
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    void getReservedUserInfo(final String username, final ActionListener<ReservedUserInfo> listener) {
        if (!this.securityLifecycleService.isSecurityIndexExisting()) {
            listener.onFailure((Exception)new IllegalStateException("Attempt to get reserved user info but the security index does not exist"));
            return;
        }
        GetRequestBuilder getRequest = this.securityLifecycleService.isSecurityIndexOnNewVersion() ? this.client.prepareGet(".security", NEW_INDEX_TYPE, NativeUsersStore.getIdForUser(RESERVED_USER_DOC_TYPE, username)) : this.client.prepareGet(".security", RESERVED_USER_DOC_TYPE, username);
        getRequest.execute((ActionListener)new ActionListener<GetResponse>(){

            public void onResponse(GetResponse getResponse) {
                if (getResponse.isExists()) {
                    Map sourceMap = getResponse.getSourceAsMap();
                    String password = (String)sourceMap.get(User.Fields.PASSWORD.getPreferredName());
                    Boolean enabled = (Boolean)sourceMap.get(User.Fields.ENABLED.getPreferredName());
                    if (password == null) {
                        listener.onFailure((Exception)new IllegalStateException("password hash must not be null!"));
                    } else if (enabled == null) {
                        listener.onFailure((Exception)new IllegalStateException("enabled must not be null!"));
                    } else if (password.isEmpty()) {
                        listener.onResponse((Object)new ReservedUserInfo(ReservedRealm.DEFAULT_PASSWORD_HASH, enabled, true));
                    } else {
                        listener.onResponse((Object)new ReservedUserInfo(password.toCharArray(), enabled, false));
                    }
                } else {
                    listener.onResponse(null);
                }
            }

            public void onFailure(Exception e) {
                if (e instanceof IndexNotFoundException) {
                    NativeUsersStore.this.logger.trace(() -> new ParameterizedMessage("could not retrieve built in user [{}] info since security index does not exist", (Object)username), (Throwable)e);
                    listener.onResponse(null);
                } else {
                    NativeUsersStore.this.logger.error(() -> new ParameterizedMessage("failed to retrieve built in user [{}] info", (Object)username), (Throwable)e);
                    listener.onFailure(null);
                }
            }
        });
    }

    void getAllReservedUserInfo(final ActionListener<Map<String, ReservedUserInfo>> listener) {
        final boolean isNewSecurityIndexVersion = this.securityLifecycleService.isSecurityIndexOnNewVersion();
        SearchRequestBuilder searchRequest = isNewSecurityIndexVersion ? this.client.prepareSearch(new String[]{".security"}).setQuery((QueryBuilder)QueryBuilders.termQuery((String)User.Fields.TYPE.getPreferredName(), (String)RESERVED_USER_DOC_TYPE)) : this.client.prepareSearch(new String[]{".security"}).setTypes(new String[]{RESERVED_USER_DOC_TYPE}).setQuery((QueryBuilder)QueryBuilders.matchAllQuery());
        searchRequest.setFetchSource(true).execute((ActionListener)new ActionListener<SearchResponse>(){

            public void onResponse(SearchResponse searchResponse) {
                HashMap<String, ReservedUserInfo> userInfos = new HashMap<String, ReservedUserInfo>();
                assert (searchResponse.getHits().getTotalHits() <= 10L) : "there are more than 10 reserved users we need to change this to retrieve them all!";
                for (SearchHit searchHit : searchResponse.getHits().getHits()) {
                    String username;
                    Map sourceMap = searchHit.getSource();
                    String password = (String)sourceMap.get(User.Fields.PASSWORD.getPreferredName());
                    Boolean enabled = (Boolean)sourceMap.get(User.Fields.ENABLED.getPreferredName());
                    String id = searchHit.getId();
                    if (isNewSecurityIndexVersion) {
                        assert (id != null && id.startsWith(NativeUsersStore.RESERVED_USER_DOC_TYPE)) : "id [" + id + "] does not start with reserved-user prefix";
                        username = id.substring(NativeUsersStore.RESERVED_USER_DOC_TYPE.length() + 1);
                    } else {
                        username = id;
                    }
                    if (password == null) {
                        listener.onFailure((Exception)new IllegalStateException("password hash must not be null!"));
                        return;
                    }
                    if (enabled == null) {
                        listener.onFailure((Exception)new IllegalStateException("enabled must not be null!"));
                        return;
                    }
                    if (password.isEmpty()) {
                        userInfos.put(username, new ReservedUserInfo(ReservedRealm.DEFAULT_PASSWORD_HASH, enabled, true));
                        continue;
                    }
                    userInfos.put(username, new ReservedUserInfo(password.toCharArray(), enabled, false));
                }
                listener.onResponse(userInfos);
            }

            public void onFailure(Exception e) {
                if (e instanceof IndexNotFoundException) {
                    NativeUsersStore.this.logger.trace("could not retrieve built in users since security index does not exist", (Throwable)e);
                    listener.onResponse(Collections.emptyMap());
                } else {
                    NativeUsersStore.this.logger.error("failed to retrieve built in users", (Throwable)e);
                    listener.onFailure(e);
                }
            }
        });
    }

    private <Response> void clearRealmCache(final String username, final ActionListener<Response> listener, final Response response) {
        SecurityClient securityClient = new SecurityClient((ElasticsearchClient)this.client);
        ClearRealmCacheRequest request = (ClearRealmCacheRequest)securityClient.prepareClearRealmCache().usernames(username).request();
        securityClient.clearRealmCache(request, new ActionListener<ClearRealmCacheResponse>(){

            public void onResponse(ClearRealmCacheResponse nodes) {
                listener.onResponse(response);
            }

            public void onFailure(Exception e) {
                NativeUsersStore.this.logger.error(() -> new ParameterizedMessage("unable to clear realm cache for user [{}]", (Object)username), (Throwable)e);
                ElasticsearchException exception = new ElasticsearchException("clearing the cache for [" + username + "] failed. please clear the realm cache manually", (Throwable)e, new Object[0]);
                listener.onFailure((Exception)((Object)exception));
            }
        });
    }

    @Nullable
    private UserAndPassword transformUser(String username, Map<String, Object> sourceMap) {
        if (sourceMap == null) {
            return null;
        }
        try {
            String password = (String)sourceMap.get(User.Fields.PASSWORD.getPreferredName());
            String[] roles = ((List)sourceMap.get(User.Fields.ROLES.getPreferredName())).toArray(Strings.EMPTY_ARRAY);
            String fullName = (String)sourceMap.get(User.Fields.FULL_NAME.getPreferredName());
            String email = (String)sourceMap.get(User.Fields.EMAIL.getPreferredName());
            Boolean enabled = (Boolean)sourceMap.get(User.Fields.ENABLED.getPreferredName());
            if (enabled == null) {
                enabled = Boolean.TRUE;
            }
            Map metadata = (Map)sourceMap.get(User.Fields.METADATA.getPreferredName());
            return new UserAndPassword(new User(username, roles, fullName, email, metadata, enabled), password.toCharArray());
        }
        catch (Exception e) {
            this.logger.error(() -> new ParameterizedMessage("error in the format of data for user [{}]", (Object)username), (Throwable)e);
            return null;
        }
    }

    private static boolean isIndexNotFoundOrDocumentMissing(Exception e) {
        Throwable cause;
        return e instanceof ElasticsearchException && ((cause = ExceptionsHelper.unwrapCause((Throwable)e)) instanceof IndexNotFoundException || cause instanceof DocumentMissingException);
    }

    public static String getIdForUser(String docType, String userName) {
        return docType + "-" + userName;
    }

    static class ReservedUserInfo {
        public final char[] passwordHash;
        public final boolean enabled;
        public final boolean hasDefaultPassword;

        ReservedUserInfo(char[] passwordHash, boolean enabled, boolean hasDefaultPassword) {
            this.passwordHash = passwordHash;
            this.enabled = enabled;
            this.hasDefaultPassword = hasDefaultPassword;
        }
    }
}

