/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc;

import java.io.IOException;
import java.time.Instant;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xpack.security.authc.Authentication;

public final class UserToken
implements Writeable {
    private final Version version;
    private final String id;
    private final Authentication authentication;
    private final Instant expirationTime;

    UserToken(Authentication authentication, Instant expirationTime) {
        this.version = Version.CURRENT;
        this.id = UUIDs.base64UUID();
        this.authentication = Objects.requireNonNull(authentication);
        this.expirationTime = Objects.requireNonNull(expirationTime);
    }

    UserToken(StreamInput input) throws IOException {
        this.version = input.getVersion();
        this.id = input.readString();
        this.authentication = new Authentication(input);
        this.expirationTime = Instant.ofEpochSecond(input.readLong(), input.readInt());
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.id);
        this.authentication.writeTo(out);
        out.writeLong(this.expirationTime.getEpochSecond());
        out.writeInt(this.expirationTime.getNano());
    }

    Authentication getAuthentication() {
        return this.authentication;
    }

    Instant getExpirationTime() {
        return this.expirationTime;
    }

    String getId() {
        return this.id;
    }

    Version getVersion() {
        return this.version;
    }
}

