/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.audit;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.transport.TransportMessage;

public class AuditUtil {
    public static String restRequestContent(RestRequest request) {
        if (request.hasContent()) {
            try {
                return XContentHelper.convertToJson((BytesReference)request.content(), (boolean)false, (boolean)false, (XContentType)request.getXContentType());
            }
            catch (IOException ioe) {
                return "Invalid Format: " + request.content().utf8ToString();
            }
        }
        return "";
    }

    public static Set<String> indices(TransportMessage message) {
        if (message instanceof IndicesRequest) {
            return AuditUtil.arrayToSetOrNull(((IndicesRequest)message).indices());
        }
        return null;
    }

    private static Set<String> arrayToSetOrNull(String[] indices) {
        return indices == null ? null : new HashSet<String>(Arrays.asList(indices));
    }
}

