/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.rolemapping;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.security.action.rolemapping.GetRoleMappingsRequest;
import org.elasticsearch.xpack.security.action.rolemapping.GetRoleMappingsResponse;
import org.elasticsearch.xpack.security.authc.support.mapper.ExpressionRoleMapping;
import org.elasticsearch.xpack.security.authc.support.mapper.NativeRoleMappingStore;

public class TransportGetRoleMappingsAction
extends HandledTransportAction<GetRoleMappingsRequest, GetRoleMappingsResponse> {
    private final NativeRoleMappingStore roleMappingStore;

    @Inject
    public TransportGetRoleMappingsAction(Settings settings, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, TransportService transportService, NativeRoleMappingStore nativeRoleMappingStore) {
        super(settings, "cluster:admin/xpack/security/role_mapping/get", threadPool, transportService, actionFilters, indexNameExpressionResolver, GetRoleMappingsRequest::new);
        this.roleMappingStore = nativeRoleMappingStore;
    }

    protected void doExecute(GetRoleMappingsRequest request, ActionListener<GetRoleMappingsResponse> listener) {
        HashSet<String> names = request.getNames() == null || request.getNames().length == 0 ? null : new HashSet<String>(Arrays.asList(request.getNames()));
        this.roleMappingStore.getRoleMappings(names, (ActionListener<List<ExpressionRoleMapping>>)ActionListener.wrap(mappings -> {
            ExpressionRoleMapping[] array = mappings.toArray(new ExpressionRoleMapping[mappings.size()]);
            listener.onResponse((Object)new GetRoleMappingsResponse(array));
        }, arg_0 -> listener.onFailure(arg_0)));
    }
}

