/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security;

import org.elasticsearch.bootstrap.BootstrapCheck;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.xpack.XPackSettings;

final class TokenSSLBootstrapCheck
implements BootstrapCheck {
    private final Settings settings;

    TokenSSLBootstrapCheck(Settings settings) {
        this.settings = settings;
    }

    public boolean check() {
        return (Boolean)XPackSettings.TOKEN_SERVICE_ENABLED_SETTING.get(this.settings) != false && (Boolean)XPackSettings.HTTP_SSL_ENABLED.get(this.settings) == false;
    }

    public String errorMessage() {
        return "HTTPS is required in order to use the token service. Please enable HTTPS using the [" + XPackSettings.HTTP_SSL_ENABLED.getKey() + "] setting or disable the token service using the [" + XPackSettings.TOKEN_SERVICE_ENABLED_SETTING.getKey() + "] setting.";
    }
}

