/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security;

import org.elasticsearch.bootstrap.BootstrapCheck;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.xpack.XPackSettings;
import org.elasticsearch.xpack.security.authc.TokenService;

final class TokenPassphraseBootstrapCheck
implements BootstrapCheck {
    static final int MINIMUM_PASSPHRASE_LENGTH = 8;
    private final boolean tokenServiceEnabled;
    private final SecureString tokenPassphrase;

    TokenPassphraseBootstrapCheck(Settings settings) {
        this.tokenServiceEnabled = (Boolean)XPackSettings.TOKEN_SERVICE_ENABLED_SETTING.get(settings);
        this.tokenPassphrase = (SecureString)TokenService.TOKEN_PASSPHRASE.get(settings);
    }

    public boolean check() {
        try (SecureString ignore = this.tokenPassphrase;){
            if (this.tokenServiceEnabled) {
                boolean bl = this.tokenPassphrase.length() < 8 || this.tokenPassphrase.equals((Object)"changeme is a terrible password, so let's not use it anymore!");
                return bl;
            }
        }
        return false;
    }

    public String errorMessage() {
        return "Please set a passphrase using the elasticsearch-keystore tool for the setting [" + TokenService.TOKEN_PASSPHRASE.getKey() + "] that is at least " + 8 + " characters in length and does not match the default passphrase or disable the token service using the [" + XPackSettings.TOKEN_SERVICE_ENABLED_SETTING.getKey() + "] setting";
    }
}

