/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.health.ClusterIndexHealth;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.component.LifecycleListener;
import org.elasticsearch.common.inject.internal.Nullable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.gateway.GatewayService;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.security.InternalSecurityClient;
import org.elasticsearch.xpack.security.Security;
import org.elasticsearch.xpack.security.audit.index.IndexAuditTrail;
import org.elasticsearch.xpack.security.authc.esnative.NativeRealmMigrator;
import org.elasticsearch.xpack.security.support.IndexLifecycleManager;

public class SecurityLifecycleService
extends AbstractComponent
implements ClusterStateListener {
    public static final String SECURITY_INDEX_NAME = ".security";
    public static final String SECURITY_TEMPLATE_NAME = "security-index-template";
    public static final String NEW_SECURITY_TEMPLATE_NAME = "security-index-template-v6";
    public static final String NEW_SECURITY_INDEX_NAME = ".security-" + IndexLifecycleManager.NEW_INDEX_VERSION;
    private static final Version MIN_READ_VERSION = Version.V_5_0_0;
    private final Settings settings;
    private final ThreadPool threadPool;
    private final IndexAuditTrail indexAuditTrail;
    private final IndexLifecycleManager securityIndex;

    public SecurityLifecycleService(Settings settings, ClusterService clusterService, ThreadPool threadPool, InternalSecurityClient client, XPackLicenseState licenseState, @Nullable IndexAuditTrail indexAuditTrail) {
        this(settings, clusterService, threadPool, client, new NativeRealmMigrator(settings, licenseState, client), indexAuditTrail);
    }

    SecurityLifecycleService(Settings settings, ClusterService clusterService, ThreadPool threadPool, InternalSecurityClient client, NativeRealmMigrator migrator, @Nullable IndexAuditTrail indexAuditTrail) {
        super(settings);
        this.settings = settings;
        this.threadPool = threadPool;
        this.indexAuditTrail = indexAuditTrail;
        this.securityIndex = new IndexLifecycleManager(settings, client, clusterService, threadPool, SECURITY_INDEX_NAME, SECURITY_TEMPLATE_NAME, migrator);
        clusterService.addListener((ClusterStateListener)this);
        clusterService.addLifecycleListener(new LifecycleListener(){

            public void beforeStop() {
                SecurityLifecycleService.this.stop();
            }
        });
    }

    public void clusterChanged(final ClusterChangedEvent event) {
        ClusterState state = event.state();
        if (state.blocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK)) {
            this.logger.debug("lifecycle service waiting until state has been recovered");
            return;
        }
        this.securityIndex.clusterChanged(event);
        try {
            if (Security.indexAuditLoggingEnabled(this.settings) && this.indexAuditTrail.state() == IndexAuditTrail.State.INITIALIZED && this.indexAuditTrail.canStart(event, event.localNodeMaster())) {
                this.threadPool.generic().execute((Runnable)new AbstractRunnable(){

                    public void onFailure(Exception throwable) {
                        SecurityLifecycleService.this.logger.error("failed to start index audit trail services", (Throwable)throwable);
                        assert (false) : "security lifecycle services startup failed";
                    }

                    public void doRun() {
                        SecurityLifecycleService.this.indexAuditTrail.start(event.localNodeMaster());
                    }
                });
            }
        }
        catch (Exception e) {
            this.logger.error("failed to start index audit trail", (Throwable)e);
        }
    }

    protected IndexLifecycleManager securityIndex() {
        return this.securityIndex;
    }

    public boolean isSecurityIndexExisting() {
        return this.securityIndex.indexExists();
    }

    public boolean isSecurityIndexAvailable() {
        return this.securityIndex.isAvailable();
    }

    public boolean isSecurityIndexWriteable() {
        return this.securityIndex.isWritable();
    }

    public boolean isSecurityIndexOnNewVersion() {
        return this.securityIndex.isIndexOnNewVersion();
    }

    public boolean checkSecurityMappingVersion(Predicate<Version> requiredVersion) {
        return this.securityIndex.checkMappingVersion(requiredVersion);
    }

    public void addSecurityIndexHealthChangeListener(BiConsumer<ClusterIndexHealth, ClusterIndexHealth> listener) {
        this.securityIndex.addIndexHealthChangeListener(listener);
    }

    public void stop() {
        if (this.indexAuditTrail != null) {
            try {
                this.indexAuditTrail.stop();
            }
            catch (Exception e) {
                this.logger.error("failed to stop audit trail module", (Throwable)e);
            }
        }
    }

    public static boolean securityIndexMappingAndTemplateSufficientToRead(ClusterState clusterState, Logger logger) {
        return SecurityLifecycleService.checkTemplateAndMappingVersions(clusterState, logger, arg_0 -> ((Version)MIN_READ_VERSION).onOrBefore(arg_0));
    }

    public static boolean securityIndexMappingAndTemplateUpToDate(ClusterState clusterState, Logger logger) {
        return SecurityLifecycleService.checkTemplateAndMappingVersions(clusterState, logger, arg_0 -> ((Version)Version.CURRENT).equals(arg_0));
    }

    private static boolean checkTemplateAndMappingVersions(ClusterState clusterState, Logger logger, Predicate<Version> versionPredicate) {
        return IndexLifecycleManager.checkTemplateExistsAndVersionMatches(SECURITY_TEMPLATE_NAME, clusterState, logger, versionPredicate) && IndexLifecycleManager.checkIndexMappingVersionMatches(SECURITY_INDEX_NAME, clusterState, logger, versionPredicate);
    }

    public static List<String> indexNames() {
        return Collections.unmodifiableList(Arrays.asList(SECURITY_INDEX_NAME, NEW_SECURITY_INDEX_NAME));
    }
}

