/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.persistent;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.MasterNodeOperationRequestBuilder;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.persistent.NodePersistentTasksExecutor;
import org.elasticsearch.xpack.persistent.PersistentTaskParams;
import org.elasticsearch.xpack.persistent.PersistentTaskResponse;
import org.elasticsearch.xpack.persistent.PersistentTasksClusterService;
import org.elasticsearch.xpack.persistent.PersistentTasksCustomMetaData;
import org.elasticsearch.xpack.persistent.PersistentTasksExecutorRegistry;
import org.elasticsearch.xpack.persistent.PersistentTasksNodeService;
import org.elasticsearch.xpack.persistent.PersistentTasksService;

public class StartPersistentTaskAction
extends Action<Request, PersistentTaskResponse, RequestBuilder> {
    public static final StartPersistentTaskAction INSTANCE = new StartPersistentTaskAction();
    public static final String NAME = "cluster:admin/persistent/start";

    private StartPersistentTaskAction() {
        super(NAME);
    }

    public RequestBuilder newRequestBuilder(ElasticsearchClient client) {
        return new RequestBuilder(client, this);
    }

    public PersistentTaskResponse newResponse() {
        return new PersistentTaskResponse();
    }

    public static class TransportAction
    extends TransportMasterNodeAction<Request, PersistentTaskResponse> {
        private final PersistentTasksClusterService persistentTasksClusterService;

        @Inject
        public TransportAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, PersistentTasksClusterService persistentTasksClusterService, PersistentTasksExecutorRegistry persistentTasksExecutorRegistry, PersistentTasksService persistentTasksService, IndexNameExpressionResolver indexNameExpressionResolver) {
            super(settings, StartPersistentTaskAction.NAME, transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, Request::new);
            this.persistentTasksClusterService = persistentTasksClusterService;
            NodePersistentTasksExecutor executor = new NodePersistentTasksExecutor(threadPool);
            clusterService.addListener((ClusterStateListener)new PersistentTasksNodeService(settings, persistentTasksService, persistentTasksExecutorRegistry, transportService.getTaskManager(), executor));
        }

        protected String executor() {
            return "generic";
        }

        protected PersistentTaskResponse newResponse() {
            return new PersistentTaskResponse();
        }

        protected ClusterBlockException checkBlock(Request request, ClusterState state) {
            return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
        }

        protected final void masterOperation(Request request, ClusterState state, final ActionListener<PersistentTaskResponse> listener) {
            this.persistentTasksClusterService.createPersistentTask(request.taskId, request.taskName, request.params, new ActionListener<PersistentTasksCustomMetaData.PersistentTask<?>>(){

                public void onResponse(PersistentTasksCustomMetaData.PersistentTask<?> task) {
                    listener.onResponse((Object)new PersistentTaskResponse(task));
                }

                public void onFailure(Exception e) {
                    listener.onFailure(e);
                }
            });
        }
    }

    public static class RequestBuilder
    extends MasterNodeOperationRequestBuilder<Request, PersistentTaskResponse, RequestBuilder> {
        protected RequestBuilder(ElasticsearchClient client, StartPersistentTaskAction action) {
            super(client, (Action)action, (MasterNodeRequest)new Request());
        }

        public RequestBuilder setTaskId(String taskId) {
            ((Request)this.request).setTaskId(taskId);
            return this;
        }

        public RequestBuilder setAction(String action) {
            ((Request)this.request).setTaskName(action);
            return this;
        }

        public RequestBuilder setRequest(PersistentTaskParams params) {
            ((Request)this.request).setParams(params);
            return this;
        }
    }

    public static class Request
    extends MasterNodeRequest<Request> {
        private String taskId;
        @Nullable
        private String taskName;
        private PersistentTaskParams params;

        public Request() {
        }

        public Request(String taskId, String taskName, PersistentTaskParams params) {
            this.taskId = taskId;
            this.taskName = taskName;
            this.params = params;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.taskId = in.readString();
            this.taskName = in.readString();
            this.params = (PersistentTaskParams)in.readOptionalNamedWriteable(PersistentTaskParams.class);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.taskId);
            out.writeString(this.taskName);
            out.writeOptionalNamedWriteable((NamedWriteable)this.params);
        }

        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            if (this.taskId == null) {
                validationException = ValidateActions.addValidationError((String)"task id must be specified", validationException);
            }
            if (this.taskName == null) {
                validationException = ValidateActions.addValidationError((String)"action must be specified", (ActionRequestValidationException)validationException);
            }
            if (this.params != null && !this.params.getWriteableName().equals(this.taskName)) {
                validationException = ValidateActions.addValidationError((String)("params have to have the same writeable name as task. params: " + this.params.getWriteableName() + " task: " + this.taskName), (ActionRequestValidationException)validationException);
            }
            return validationException;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request request1 = (Request)((Object)o);
            return Objects.equals(this.taskId, request1.taskId) && Objects.equals(this.taskName, request1.taskName) && Objects.equals(this.params, request1.params);
        }

        public int hashCode() {
            return Objects.hash(this.taskId, this.taskName, this.params);
        }

        public String getTaskName() {
            return this.taskName;
        }

        public void setTaskName(String taskName) {
            this.taskName = taskName;
        }

        public String getTaskId() {
            return this.taskId;
        }

        public void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        public PersistentTaskParams getParams() {
            return this.params;
        }

        @Nullable
        public void setParams(PersistentTaskParams params) {
            this.params = params;
        }
    }
}

