/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.persistent;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.tasks.TaskManager;
import org.elasticsearch.xpack.persistent.PersistentTasksCustomMetaData;
import org.elasticsearch.xpack.persistent.PersistentTasksNodeService;
import org.elasticsearch.xpack.persistent.PersistentTasksService;

public class AllocatedPersistentTask
extends CancellableTask {
    private volatile String persistentTaskId;
    private volatile long allocationId;
    private final AtomicReference<State> state = new AtomicReference<State>(State.STARTED);
    @Nullable
    private volatile Exception failure;
    private volatile PersistentTasksService persistentTasksService;
    private volatile Logger logger;
    private volatile TaskManager taskManager;

    public AllocatedPersistentTask(long id, String type, String action, String description, TaskId parentTask) {
        super(id, type, action, description, parentTask);
    }

    public boolean shouldCancelChildrenOnCancellation() {
        return true;
    }

    public final boolean cancelOnParentLeaving() {
        return false;
    }

    public Task.Status getStatus() {
        return new PersistentTasksNodeService.Status(this.state.get());
    }

    public void updatePersistentStatus(Task.Status status, ActionListener<PersistentTasksCustomMetaData.PersistentTask<?>> listener) {
        this.persistentTasksService.updateStatus(this.persistentTaskId, this.allocationId, status, listener);
    }

    public String getPersistentTaskId() {
        return this.persistentTaskId;
    }

    void init(PersistentTasksService persistentTasksService, TaskManager taskManager, Logger logger, String persistentTaskId, long allocationId) {
        this.persistentTasksService = persistentTasksService;
        this.logger = logger;
        this.taskManager = taskManager;
        this.persistentTaskId = persistentTaskId;
        this.allocationId = allocationId;
    }

    public Exception getFailure() {
        return this.failure;
    }

    boolean markAsCancelled() {
        return this.state.compareAndSet(State.STARTED, State.PENDING_CANCEL);
    }

    public State getState() {
        return this.state.get();
    }

    public long getAllocationId() {
        return this.allocationId;
    }

    public void markAsCompleted() {
        this.completeAndNotifyIfNeeded(null);
    }

    public void markAsFailed(Exception e) {
        if ("by user request".equals(this.getReasonCancelled())) {
            this.completeAndNotifyIfNeeded(null);
        } else {
            this.completeAndNotifyIfNeeded(e);
        }
    }

    private void completeAndNotifyIfNeeded(@Nullable Exception failure) {
        State prevState = this.state.getAndSet(State.COMPLETED);
        if (prevState == State.COMPLETED) {
            this.logger.warn("attempt to complete task [{}] with id [{}] in the [{}] state", (Object)this.getAction(), (Object)this.getPersistentTaskId(), (Object)prevState);
        } else {
            if (failure != null) {
                this.logger.warn(() -> new ParameterizedMessage("task {} failed with an exception", (Object)this.getPersistentTaskId()), (Throwable)failure);
            }
            try {
                this.failure = failure;
                if (prevState == State.STARTED) {
                    this.logger.trace("sending notification for completed task [{}] with id [{}]", (Object)this.getAction(), (Object)this.getPersistentTaskId());
                    this.persistentTasksService.sendCompletionNotification(this.getPersistentTaskId(), this.getAllocationId(), failure, new ActionListener<PersistentTasksCustomMetaData.PersistentTask<?>>(){

                        public void onResponse(PersistentTasksCustomMetaData.PersistentTask<?> persistentTask) {
                            AllocatedPersistentTask.this.logger.trace("notification for task [{}] with id [{}] was successful", (Object)AllocatedPersistentTask.this.getAction(), (Object)AllocatedPersistentTask.this.getPersistentTaskId());
                        }

                        public void onFailure(Exception e) {
                            AllocatedPersistentTask.this.logger.warn(() -> new ParameterizedMessage("notification for task [{}] with id [{}] failed", (Object)AllocatedPersistentTask.this.getAction(), (Object)AllocatedPersistentTask.this.getPersistentTaskId()), (Throwable)e);
                        }
                    });
                }
            }
            finally {
                this.taskManager.unregister((Task)this);
            }
        }
    }

    public static enum State {
        STARTED,
        PENDING_CANCEL,
        COMPLETED;

    }
}

