/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.utils;

import java.util.regex.Pattern;

public final class MlStrings {
    private static final Pattern NEEDS_QUOTING = Pattern.compile("\\W");
    private static final Pattern VALID_ID_CHAR_PATTERN = Pattern.compile("[a-z0-9](?:[a-z0-9_\\-\\.]*[a-z0-9])?");

    private MlStrings() {
    }

    public static String doubleQuoteIfNotAlphaNumeric(String input) {
        if (!NEEDS_QUOTING.matcher(input).find()) {
            return input;
        }
        StringBuilder quoted = new StringBuilder();
        quoted.append('\"');
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c == '\"' || c == '\\') {
                quoted.append('\\');
            }
            quoted.append(c);
        }
        quoted.append('\"');
        return quoted.toString();
    }

    public static boolean isValidId(String id) {
        return id != null && VALID_ID_CHAR_PATTERN.matcher(id).matches() && !"_all".equals(id);
    }

    public static String getParentField(String fieldPath) {
        if (fieldPath == null) {
            return fieldPath;
        }
        int lastIndexOfDot = fieldPath.lastIndexOf(46);
        if (lastIndexOfDot < 0) {
            return fieldPath;
        }
        return fieldPath.substring(0, lastIndexOfDot);
    }
}

