/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.retention;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.xpack.ml.MlMetadata;
import org.elasticsearch.xpack.ml.job.config.Job;
import org.elasticsearch.xpack.ml.job.results.Result;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.chrono.ISOChronology;

abstract class AbstractExpiredJobDataRemover {
    private final ClusterService clusterService;

    AbstractExpiredJobDataRemover(ClusterService clusterService) {
        this.clusterService = Objects.requireNonNull(clusterService);
    }

    public void trigger(Runnable onFinish) {
        this.removeData(this.newJobIterator(), onFinish);
    }

    private void removeData(Iterator<Job> jobIterator, Runnable onFinish) {
        if (!jobIterator.hasNext()) {
            onFinish.run();
            return;
        }
        Job job = jobIterator.next();
        Long retentionDays = this.getRetentionDays(job);
        if (retentionDays == null) {
            this.removeData(jobIterator, () -> this.removeData(jobIterator, onFinish));
            return;
        }
        long cutoffEpochMs = this.calcCutoffEpochMs(retentionDays);
        this.removeDataBefore(job, cutoffEpochMs, () -> this.removeData(jobIterator, onFinish));
    }

    private Iterator<Job> newJobIterator() {
        ArrayList<Job> jobs = new ArrayList<Job>();
        ClusterState clusterState = this.clusterService.state();
        MlMetadata mlMetadata = (MlMetadata)clusterState.getMetaData().custom("ml");
        if (mlMetadata != null) {
            jobs.addAll(mlMetadata.getJobs().values());
        }
        return AbstractExpiredJobDataRemover.createVolatileCursorIterator(jobs);
    }

    protected static <T> Iterator<T> createVolatileCursorIterator(List<T> items) {
        return new VolatileCursorIterator(items);
    }

    private long calcCutoffEpochMs(long retentionDays) {
        long nowEpochMs = DateTime.now((Chronology)ISOChronology.getInstance()).getMillis();
        return nowEpochMs - new TimeValue(retentionDays, TimeUnit.DAYS).getMillis();
    }

    protected abstract Long getRetentionDays(Job var1);

    protected abstract void removeDataBefore(Job var1, long var2, Runnable var4);

    protected static BoolQueryBuilder createQuery(String jobId, long cutoffEpochMs) {
        return QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termQuery((String)Job.ID.getPreferredName(), (String)jobId)).filter((QueryBuilder)QueryBuilders.rangeQuery((String)Result.TIMESTAMP.getPreferredName()).lt((Object)cutoffEpochMs).format("epoch_millis"));
    }

    private static class VolatileCursorIterator<T>
    implements Iterator<T> {
        private final List<T> items;
        private volatile int cursor;

        private VolatileCursorIterator(List<T> items) {
            this.items = items;
            this.cursor = 0;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < this.items.size();
        }

        @Override
        public T next() {
            return this.items.get(this.cursor++);
        }
    }
}

