/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.results;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.action.support.ToXContentToBytes;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.ml.job.config.Detector;
import org.elasticsearch.xpack.ml.job.config.Job;
import org.elasticsearch.xpack.ml.job.results.AnomalyCause;
import org.elasticsearch.xpack.ml.job.results.Influence;
import org.elasticsearch.xpack.ml.job.results.ReservedFieldNames;
import org.elasticsearch.xpack.ml.job.results.Result;
import org.elasticsearch.xpack.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.ml.utils.time.TimeUtils;

public class AnomalyRecord
extends ToXContentToBytes
implements Writeable {
    public static final String RESULT_TYPE_VALUE = "record";
    public static final ParseField SEQUENCE_NUM = new ParseField("sequence_num", new String[0]);
    public static final ParseField PROBABILITY = new ParseField("probability", new String[0]);
    public static final ParseField BY_FIELD_NAME = new ParseField("by_field_name", new String[0]);
    public static final ParseField BY_FIELD_VALUE = new ParseField("by_field_value", new String[0]);
    public static final ParseField CORRELATED_BY_FIELD_VALUE = new ParseField("correlated_by_field_value", new String[0]);
    public static final ParseField PARTITION_FIELD_NAME = new ParseField("partition_field_name", new String[0]);
    public static final ParseField PARTITION_FIELD_VALUE = new ParseField("partition_field_value", new String[0]);
    public static final ParseField FUNCTION = new ParseField("function", new String[0]);
    public static final ParseField FUNCTION_DESCRIPTION = new ParseField("function_description", new String[0]);
    public static final ParseField TYPICAL = new ParseField("typical", new String[0]);
    public static final ParseField ACTUAL = new ParseField("actual", new String[0]);
    public static final ParseField INFLUENCERS = new ParseField("influencers", new String[0]);
    public static final ParseField BUCKET_SPAN = new ParseField("bucket_span", new String[0]);
    public static final ParseField RESULTS_FIELD = new ParseField("records", new String[0]);
    public static final ParseField FIELD_NAME = new ParseField("field_name", new String[0]);
    public static final ParseField OVER_FIELD_NAME = new ParseField("over_field_name", new String[0]);
    public static final ParseField OVER_FIELD_VALUE = new ParseField("over_field_value", new String[0]);
    public static final ParseField CAUSES = new ParseField("causes", new String[0]);
    public static final ParseField RECORD_SCORE = new ParseField("record_score", new String[0]);
    public static final ParseField INITIAL_RECORD_SCORE = new ParseField("initial_record_score", new String[0]);
    public static final ConstructingObjectParser<AnomalyRecord, Void> PARSER = new ConstructingObjectParser("record", true, a -> new AnomalyRecord((String)a[0], (Date)a[1], (Long)a[2]));
    private final String jobId;
    private int detectorIndex;
    private double probability;
    private String byFieldName;
    private String byFieldValue;
    private String correlatedByFieldValue;
    private String partitionFieldName;
    private String partitionFieldValue;
    private String function;
    private String functionDescription;
    private List<Double> typical;
    private List<Double> actual;
    private boolean isInterim;
    private String fieldName;
    private String overFieldName;
    private String overFieldValue;
    private List<AnomalyCause> causes;
    private double recordScore;
    private double initialRecordScore;
    private final Date timestamp;
    private final long bucketSpan;
    private List<Influence> influences;

    public AnomalyRecord(String jobId, Date timestamp, long bucketSpan) {
        this.jobId = jobId;
        this.timestamp = ExceptionsHelper.requireNonNull(timestamp, Result.TIMESTAMP.getPreferredName());
        this.bucketSpan = bucketSpan;
    }

    public AnomalyRecord(StreamInput in) throws IOException {
        this.jobId = in.readString();
        if (in.getVersion().before(Version.V_5_5_0)) {
            in.readInt();
        }
        this.detectorIndex = in.readInt();
        this.probability = in.readDouble();
        this.byFieldName = in.readOptionalString();
        this.byFieldValue = in.readOptionalString();
        this.correlatedByFieldValue = in.readOptionalString();
        this.partitionFieldName = in.readOptionalString();
        this.partitionFieldValue = in.readOptionalString();
        this.function = in.readOptionalString();
        this.functionDescription = in.readOptionalString();
        this.fieldName = in.readOptionalString();
        this.overFieldName = in.readOptionalString();
        this.overFieldValue = in.readOptionalString();
        if (in.readBoolean()) {
            this.typical = (List)in.readGenericValue();
        }
        if (in.readBoolean()) {
            this.actual = (List)in.readGenericValue();
        }
        this.isInterim = in.readBoolean();
        if (in.readBoolean()) {
            this.causes = in.readList(AnomalyCause::new);
        }
        this.recordScore = in.readDouble();
        this.initialRecordScore = in.readDouble();
        this.timestamp = new Date(in.readLong());
        this.bucketSpan = in.readLong();
        if (in.readBoolean()) {
            this.influences = in.readList(Influence::new);
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.jobId);
        if (out.getVersion().before(Version.V_5_5_0)) {
            out.writeInt(0);
        }
        out.writeInt(this.detectorIndex);
        out.writeDouble(this.probability);
        out.writeOptionalString(this.byFieldName);
        out.writeOptionalString(this.byFieldValue);
        out.writeOptionalString(this.correlatedByFieldValue);
        out.writeOptionalString(this.partitionFieldName);
        out.writeOptionalString(this.partitionFieldValue);
        out.writeOptionalString(this.function);
        out.writeOptionalString(this.functionDescription);
        out.writeOptionalString(this.fieldName);
        out.writeOptionalString(this.overFieldName);
        out.writeOptionalString(this.overFieldValue);
        boolean hasTypical = this.typical != null;
        out.writeBoolean(hasTypical);
        if (hasTypical) {
            out.writeGenericValue(this.typical);
        }
        boolean hasActual = this.actual != null;
        out.writeBoolean(hasActual);
        if (hasActual) {
            out.writeGenericValue(this.actual);
        }
        out.writeBoolean(this.isInterim);
        boolean hasCauses = this.causes != null;
        out.writeBoolean(hasCauses);
        if (hasCauses) {
            out.writeList(this.causes);
        }
        out.writeDouble(this.recordScore);
        out.writeDouble(this.initialRecordScore);
        out.writeLong(this.timestamp.getTime());
        out.writeLong(this.bucketSpan);
        boolean hasInfluencers = this.influences != null;
        out.writeBoolean(hasInfluencers);
        if (hasInfluencers) {
            out.writeList(this.influences);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.innerToXContent(builder, params);
        builder.endObject();
        return builder;
    }

    XContentBuilder innerToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(Job.ID.getPreferredName(), this.jobId);
        builder.field(Result.RESULT_TYPE.getPreferredName(), RESULT_TYPE_VALUE);
        builder.field(PROBABILITY.getPreferredName(), this.probability);
        builder.field(RECORD_SCORE.getPreferredName(), this.recordScore);
        builder.field(INITIAL_RECORD_SCORE.getPreferredName(), this.initialRecordScore);
        builder.field(BUCKET_SPAN.getPreferredName(), this.bucketSpan);
        builder.field(Detector.DETECTOR_INDEX.getPreferredName(), this.detectorIndex);
        builder.field(Result.IS_INTERIM.getPreferredName(), this.isInterim);
        builder.dateField(Result.TIMESTAMP.getPreferredName(), Result.TIMESTAMP.getPreferredName() + "_string", this.timestamp.getTime());
        if (this.byFieldName != null) {
            builder.field(BY_FIELD_NAME.getPreferredName(), this.byFieldName);
        }
        if (this.byFieldValue != null) {
            builder.field(BY_FIELD_VALUE.getPreferredName(), this.byFieldValue);
        }
        if (this.correlatedByFieldValue != null) {
            builder.field(CORRELATED_BY_FIELD_VALUE.getPreferredName(), this.correlatedByFieldValue);
        }
        if (this.partitionFieldName != null) {
            builder.field(PARTITION_FIELD_NAME.getPreferredName(), this.partitionFieldName);
        }
        if (this.partitionFieldValue != null) {
            builder.field(PARTITION_FIELD_VALUE.getPreferredName(), this.partitionFieldValue);
        }
        if (this.function != null) {
            builder.field(FUNCTION.getPreferredName(), this.function);
        }
        if (this.functionDescription != null) {
            builder.field(FUNCTION_DESCRIPTION.getPreferredName(), this.functionDescription);
        }
        if (this.typical != null) {
            builder.field(TYPICAL.getPreferredName(), this.typical);
        }
        if (this.actual != null) {
            builder.field(ACTUAL.getPreferredName(), this.actual);
        }
        if (this.fieldName != null) {
            builder.field(FIELD_NAME.getPreferredName(), this.fieldName);
        }
        if (this.overFieldName != null) {
            builder.field(OVER_FIELD_NAME.getPreferredName(), this.overFieldName);
        }
        if (this.overFieldValue != null) {
            builder.field(OVER_FIELD_VALUE.getPreferredName(), this.overFieldValue);
        }
        if (this.causes != null) {
            builder.field(CAUSES.getPreferredName(), this.causes);
        }
        if (this.influences != null) {
            builder.field(INFLUENCERS.getPreferredName(), this.influences);
        }
        Map<String, LinkedHashSet<String>> inputFields = this.inputFieldMap();
        for (String fieldName : inputFields.keySet()) {
            builder.field(fieldName, (Iterable)inputFields.get(fieldName));
        }
        return builder;
    }

    private Map<String, LinkedHashSet<String>> inputFieldMap() {
        HashMap<String, LinkedHashSet<String>> result = new HashMap<String, LinkedHashSet<String>>();
        this.addInputFieldsToMap(result, this.byFieldName, this.byFieldValue);
        this.addInputFieldsToMap(result, this.overFieldName, this.overFieldValue);
        this.addInputFieldsToMap(result, this.partitionFieldName, this.partitionFieldValue);
        if (this.influences != null) {
            for (Influence inf : this.influences) {
                String fieldName = inf.getInfluencerFieldName();
                for (String fieldValue : inf.getInfluencerFieldValues()) {
                    this.addInputFieldsToMap(result, fieldName, fieldValue);
                }
            }
        }
        return result;
    }

    private void addInputFieldsToMap(Map<String, LinkedHashSet<String>> inputFields, String fieldName, String fieldValue) {
        if (!Strings.isNullOrEmpty((String)fieldName) && fieldValue != null && ReservedFieldNames.isValidFieldName(fieldName)) {
            inputFields.computeIfAbsent(fieldName, k -> new LinkedHashSet()).add(fieldValue);
        }
    }

    public String getJobId() {
        return this.jobId;
    }

    public String getId() {
        int valuesHash = Objects.hash(this.byFieldValue, this.overFieldValue, this.partitionFieldValue);
        int length = (this.byFieldValue == null ? 0 : this.byFieldValue.length()) + (this.overFieldValue == null ? 0 : this.overFieldValue.length()) + (this.partitionFieldValue == null ? 0 : this.partitionFieldValue.length());
        return this.jobId + "_record_" + this.timestamp.getTime() + "_" + this.bucketSpan + "_" + this.detectorIndex + "_" + valuesHash + "_" + length;
    }

    public int getDetectorIndex() {
        return this.detectorIndex;
    }

    public void setDetectorIndex(int detectorIndex) {
        this.detectorIndex = detectorIndex;
    }

    public double getRecordScore() {
        return this.recordScore;
    }

    public void setRecordScore(double recordScore) {
        this.recordScore = recordScore;
    }

    public double getInitialRecordScore() {
        return this.initialRecordScore;
    }

    public void setInitialRecordScore(double initialRecordScore) {
        this.initialRecordScore = initialRecordScore;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public long getBucketSpan() {
        return this.bucketSpan;
    }

    public double getProbability() {
        return this.probability;
    }

    public void setProbability(double value) {
        this.probability = value;
    }

    public String getByFieldName() {
        return this.byFieldName;
    }

    public void setByFieldName(String value) {
        this.byFieldName = value.intern();
    }

    public String getByFieldValue() {
        return this.byFieldValue;
    }

    public void setByFieldValue(String value) {
        this.byFieldValue = value.intern();
    }

    public String getCorrelatedByFieldValue() {
        return this.correlatedByFieldValue;
    }

    public void setCorrelatedByFieldValue(String value) {
        this.correlatedByFieldValue = value.intern();
    }

    public String getPartitionFieldName() {
        return this.partitionFieldName;
    }

    public void setPartitionFieldName(String field) {
        this.partitionFieldName = field.intern();
    }

    public String getPartitionFieldValue() {
        return this.partitionFieldValue;
    }

    public void setPartitionFieldValue(String value) {
        this.partitionFieldValue = value.intern();
    }

    public String getFunction() {
        return this.function;
    }

    public void setFunction(String name) {
        this.function = name.intern();
    }

    public String getFunctionDescription() {
        return this.functionDescription;
    }

    public void setFunctionDescription(String functionDescription) {
        this.functionDescription = functionDescription.intern();
    }

    public List<Double> getTypical() {
        return this.typical;
    }

    public void setTypical(List<Double> typical) {
        this.typical = typical;
    }

    public List<Double> getActual() {
        return this.actual;
    }

    public void setActual(List<Double> actual) {
        this.actual = actual;
    }

    public boolean isInterim() {
        return this.isInterim;
    }

    public void setInterim(boolean isInterim) {
        this.isInterim = isInterim;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String field) {
        this.fieldName = field.intern();
    }

    public String getOverFieldName() {
        return this.overFieldName;
    }

    public void setOverFieldName(String name) {
        this.overFieldName = name.intern();
    }

    public String getOverFieldValue() {
        return this.overFieldValue;
    }

    public void setOverFieldValue(String value) {
        this.overFieldValue = value.intern();
    }

    public List<AnomalyCause> getCauses() {
        return this.causes;
    }

    public void setCauses(List<AnomalyCause> causes) {
        this.causes = causes;
    }

    public void addCause(AnomalyCause cause) {
        if (this.causes == null) {
            this.causes = new ArrayList<AnomalyCause>();
        }
        this.causes.add(cause);
    }

    public List<Influence> getInfluencers() {
        return this.influences;
    }

    public void setInfluencers(List<Influence> influencers) {
        this.influences = influencers;
    }

    public int hashCode() {
        return Objects.hash(this.jobId, this.detectorIndex, this.bucketSpan, this.probability, this.recordScore, this.initialRecordScore, this.typical, this.actual, this.function, this.functionDescription, this.fieldName, this.byFieldName, this.byFieldValue, this.correlatedByFieldValue, this.partitionFieldName, this.partitionFieldValue, this.overFieldName, this.overFieldValue, this.timestamp, this.isInterim, this.causes, this.influences, this.jobId);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AnomalyRecord)) {
            return false;
        }
        AnomalyRecord that = (AnomalyRecord)((Object)other);
        return Objects.equals(this.jobId, that.jobId) && this.detectorIndex == that.detectorIndex && this.bucketSpan == that.bucketSpan && this.probability == that.probability && this.recordScore == that.recordScore && this.initialRecordScore == that.initialRecordScore && Objects.deepEquals(this.typical, that.typical) && Objects.deepEquals(this.actual, that.actual) && Objects.equals(this.function, that.function) && Objects.equals(this.functionDescription, that.functionDescription) && Objects.equals(this.fieldName, that.fieldName) && Objects.equals(this.byFieldName, that.byFieldName) && Objects.equals(this.byFieldValue, that.byFieldValue) && Objects.equals(this.correlatedByFieldValue, that.correlatedByFieldValue) && Objects.equals(this.partitionFieldName, that.partitionFieldName) && Objects.equals(this.partitionFieldValue, that.partitionFieldValue) && Objects.equals(this.overFieldName, that.overFieldName) && Objects.equals(this.overFieldValue, that.overFieldValue) && Objects.equals(this.timestamp, that.timestamp) && Objects.equals(this.isInterim, that.isInterim) && Objects.equals(this.causes, that.causes) && Objects.equals(this.influences, that.influences);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), Job.ID);
        PARSER.declareField(ConstructingObjectParser.constructorArg(), p -> {
            if (p.currentToken() == XContentParser.Token.VALUE_NUMBER) {
                return new Date(p.longValue());
            }
            if (p.currentToken() == XContentParser.Token.VALUE_STRING) {
                return new Date(TimeUtils.dateStringToEpoch(p.text()));
            }
            throw new IllegalArgumentException("unexpected token [" + p.currentToken() + "] for [" + Result.TIMESTAMP.getPreferredName() + "]");
        }, Result.TIMESTAMP, ObjectParser.ValueType.VALUE);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), BUCKET_SPAN);
        PARSER.declareString((anomalyRecord, s) -> {}, Result.RESULT_TYPE);
        PARSER.declareDouble(AnomalyRecord::setProbability, PROBABILITY);
        PARSER.declareDouble(AnomalyRecord::setRecordScore, RECORD_SCORE);
        PARSER.declareDouble(AnomalyRecord::setInitialRecordScore, INITIAL_RECORD_SCORE);
        PARSER.declareInt(AnomalyRecord::setDetectorIndex, Detector.DETECTOR_INDEX);
        PARSER.declareBoolean(AnomalyRecord::setInterim, Result.IS_INTERIM);
        PARSER.declareString(AnomalyRecord::setByFieldName, BY_FIELD_NAME);
        PARSER.declareString(AnomalyRecord::setByFieldValue, BY_FIELD_VALUE);
        PARSER.declareString(AnomalyRecord::setCorrelatedByFieldValue, CORRELATED_BY_FIELD_VALUE);
        PARSER.declareString(AnomalyRecord::setPartitionFieldName, PARTITION_FIELD_NAME);
        PARSER.declareString(AnomalyRecord::setPartitionFieldValue, PARTITION_FIELD_VALUE);
        PARSER.declareString(AnomalyRecord::setFunction, FUNCTION);
        PARSER.declareString(AnomalyRecord::setFunctionDescription, FUNCTION_DESCRIPTION);
        PARSER.declareDoubleArray(AnomalyRecord::setTypical, TYPICAL);
        PARSER.declareDoubleArray(AnomalyRecord::setActual, ACTUAL);
        PARSER.declareString(AnomalyRecord::setFieldName, FIELD_NAME);
        PARSER.declareString(AnomalyRecord::setOverFieldName, OVER_FIELD_NAME);
        PARSER.declareString(AnomalyRecord::setOverFieldValue, OVER_FIELD_VALUE);
        PARSER.declareObjectArray(AnomalyRecord::setCauses, AnomalyCause.PARSER, CAUSES);
        PARSER.declareObjectArray(AnomalyRecord::setInfluencers, Influence.PARSER, INFLUENCERS);
        PARSER.declareInt((anomalyRecord, sequenceNum) -> {}, SEQUENCE_NUM);
    }
}

