/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.process.autodetect.writer;

import java.io.IOException;
import java.io.Writer;
import java.util.Objects;
import org.elasticsearch.xpack.ml.job.config.ModelPlotConfig;

public class ModelPlotConfigWriter {
    private static final double BOUNDS_PERCENTILE_DEFAULT = 95.0;
    private static final double BOUNDS_PERCENTILE_DISABLE_VALUE = -1.0;
    private final ModelPlotConfig modelPlotConfig;
    private final Writer writer;

    public ModelPlotConfigWriter(ModelPlotConfig modelPlotConfig, Writer writer) {
        this.modelPlotConfig = Objects.requireNonNull(modelPlotConfig);
        this.writer = Objects.requireNonNull(writer);
    }

    public void write() throws IOException {
        StringBuilder contents = new StringBuilder();
        contents.append("boundspercentile").append(" = ").append(this.modelPlotConfig.isEnabled() ? 95.0 : -1.0).append('\n');
        String terms = this.modelPlotConfig.getTerms();
        contents.append(ModelPlotConfig.TERMS_FIELD.getPreferredName()).append(" = ").append(terms == null ? "" : terms).append('\n');
        this.writer.write(contents.toString());
    }
}

