/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.persistence;

import java.util.Objects;
import org.elasticsearch.xpack.ml.job.results.Influencer;

public final class InfluencersQueryBuilder {
    public static final int DEFAULT_SIZE = 100;
    private InfluencersQuery influencersQuery = new InfluencersQuery();

    public InfluencersQueryBuilder from(int from) {
        this.influencersQuery.from = from;
        return this;
    }

    public InfluencersQueryBuilder size(int size) {
        this.influencersQuery.size = size;
        return this;
    }

    public InfluencersQueryBuilder includeInterim(boolean include) {
        this.influencersQuery.includeInterim = include;
        return this;
    }

    public InfluencersQueryBuilder influencerScoreThreshold(Double influencerScoreFilter) {
        this.influencersQuery.influencerScoreFilter = influencerScoreFilter;
        return this;
    }

    public InfluencersQueryBuilder sortField(String sortField) {
        this.influencersQuery.sortField = sortField;
        return this;
    }

    public InfluencersQueryBuilder sortDescending(boolean sortDescending) {
        this.influencersQuery.sortDescending = sortDescending;
        return this;
    }

    public InfluencersQueryBuilder start(String startTime) {
        this.influencersQuery.start = startTime;
        return this;
    }

    public InfluencersQueryBuilder end(String endTime) {
        this.influencersQuery.end = endTime;
        return this;
    }

    public InfluencersQuery build() {
        return this.influencersQuery;
    }

    public void clear() {
        this.influencersQuery = new InfluencersQuery();
    }

    public class InfluencersQuery {
        private int from = 0;
        private int size = 100;
        private boolean includeInterim = false;
        private double influencerScoreFilter = 0.0;
        private String start;
        private String end;
        private String sortField = Influencer.INFLUENCER_SCORE.getPreferredName();
        private boolean sortDescending = false;

        public int getFrom() {
            return this.from;
        }

        public int getSize() {
            return this.size;
        }

        public boolean isIncludeInterim() {
            return this.includeInterim;
        }

        public double getInfluencerScoreFilter() {
            return this.influencerScoreFilter;
        }

        public String getStart() {
            return this.start;
        }

        public String getEnd() {
            return this.end;
        }

        public String getSortField() {
            return this.sortField;
        }

        public boolean isSortDescending() {
            return this.sortDescending;
        }

        public int hashCode() {
            return Objects.hash(this.from, this.size, this.includeInterim, this.influencerScoreFilter, this.start, this.end, this.sortField, this.sortDescending);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            InfluencersQuery other = (InfluencersQuery)obj;
            return Objects.equals(this.from, other.from) && Objects.equals(this.size, other.size) && Objects.equals(this.includeInterim, other.includeInterim) && Objects.equals(this.start, other.start) && Objects.equals(this.end, other.end) && Objects.equals(this.influencerScoreFilter, other.influencerScoreFilter) && Objects.equals(this.sortField, other.sortField) && this.sortDescending == other.sortDescending;
        }
    }
}

