/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.CheckedConsumer;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.xpack.ml.MlMetadata;
import org.elasticsearch.xpack.ml.action.DeleteJobAction;
import org.elasticsearch.xpack.ml.action.PutJobAction;
import org.elasticsearch.xpack.ml.action.RevertModelSnapshotAction;
import org.elasticsearch.xpack.ml.action.util.QueryPage;
import org.elasticsearch.xpack.ml.job.UpdateJobProcessNotifier;
import org.elasticsearch.xpack.ml.job.config.Job;
import org.elasticsearch.xpack.ml.job.config.JobState;
import org.elasticsearch.xpack.ml.job.config.JobUpdate;
import org.elasticsearch.xpack.ml.job.messages.Messages;
import org.elasticsearch.xpack.ml.job.persistence.JobProvider;
import org.elasticsearch.xpack.ml.job.persistence.JobResultsPersister;
import org.elasticsearch.xpack.ml.job.persistence.JobStorageDeletionTask;
import org.elasticsearch.xpack.ml.job.process.autodetect.state.ModelSizeStats;
import org.elasticsearch.xpack.ml.job.process.autodetect.state.ModelSnapshot;
import org.elasticsearch.xpack.ml.notifications.Auditor;
import org.elasticsearch.xpack.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.persistent.PersistentTasksCustomMetaData;

public class JobManager
extends AbstractComponent {
    private final JobProvider jobProvider;
    private final ClusterService clusterService;
    private final Auditor auditor;
    private final Client client;
    private final UpdateJobProcessNotifier updateJobProcessNotifier;

    public JobManager(Settings settings, JobProvider jobProvider, ClusterService clusterService, Auditor auditor, Client client, UpdateJobProcessNotifier updateJobProcessNotifier) {
        super(settings);
        this.jobProvider = Objects.requireNonNull(jobProvider);
        this.clusterService = Objects.requireNonNull(clusterService);
        this.auditor = Objects.requireNonNull(auditor);
        this.client = Objects.requireNonNull(client);
        this.updateJobProcessNotifier = updateJobProcessNotifier;
    }

    public QueryPage<Job> getJob(String jobId, ClusterState clusterState) {
        Job job;
        if (jobId.equals("_all")) {
            return this.getJobs(clusterState);
        }
        MlMetadata mlMetadata = (MlMetadata)clusterState.getMetaData().custom("ml");
        Job job2 = job = mlMetadata == null ? null : mlMetadata.getJobs().get(jobId);
        if (job == null) {
            this.logger.debug(String.format(Locale.ROOT, "Cannot find job '%s'", jobId));
            throw ExceptionsHelper.missingJobException(jobId);
        }
        this.logger.debug("Returning job [" + jobId + "]");
        return new QueryPage<Job>(Collections.singletonList(job), 1L, Job.RESULTS_FIELD);
    }

    public QueryPage<Job> getJobs(ClusterState clusterState) {
        MlMetadata mlMetadata = (MlMetadata)clusterState.getMetaData().custom("ml");
        if (mlMetadata == null) {
            mlMetadata = MlMetadata.EMPTY_METADATA;
        }
        List jobs = mlMetadata.getJobs().entrySet().stream().map(Map.Entry::getValue).collect(Collectors.toList());
        return new QueryPage<Job>(jobs, mlMetadata.getJobs().size(), Job.RESULTS_FIELD);
    }

    public Job getJobOrThrowIfUnknown(String jobId) {
        return JobManager.getJobOrThrowIfUnknown(this.clusterService.state(), jobId);
    }

    public JobState getJobState(String jobId) {
        PersistentTasksCustomMetaData tasks = (PersistentTasksCustomMetaData)this.clusterService.state().getMetaData().custom("persistent_tasks");
        return MlMetadata.getJobState(jobId, tasks);
    }

    public static Job getJobOrThrowIfUnknown(ClusterState clusterState, String jobId) {
        Job job;
        MlMetadata mlMetadata = (MlMetadata)clusterState.metaData().custom("ml");
        Job job2 = job = mlMetadata == null ? null : mlMetadata.getJobs().get(jobId);
        if (job == null) {
            throw ExceptionsHelper.missingJobException(jobId);
        }
        return job;
    }

    public void putJob(final PutJobAction.Request request, ClusterState state, final ActionListener<PutJobAction.Response> actionListener) {
        final Job job = request.getJobBuilder().build(new Date());
        MlMetadata currentMlMetadata = (MlMetadata)state.metaData().custom("ml");
        if (currentMlMetadata != null && currentMlMetadata.getJobs().containsKey(job.getId())) {
            actionListener.onFailure((Exception)ExceptionsHelper.jobAlreadyExists(job.getId()));
            return;
        }
        ActionListener<Boolean> putJobListener = new ActionListener<Boolean>(){

            public void onResponse(Boolean indicesCreated) {
                JobManager.this.auditor.info(job.getId(), Messages.getMessage("Job created"));
                JobManager.this.clusterService.submitStateUpdateTask("put-job-" + job.getId(), (ClusterStateTaskConfig)new AckedClusterStateUpdateTask<PutJobAction.Response>((AckedRequest)request, actionListener){

                    protected PutJobAction.Response newResponse(boolean acknowledged) {
                        return new PutJobAction.Response(acknowledged, job);
                    }

                    public ClusterState execute(ClusterState currentState) throws Exception {
                        return JobManager.this.updateClusterState(job, false, currentState);
                    }
                });
            }

            public void onFailure(Exception e) {
                Matcher matcher;
                if (e instanceof IllegalArgumentException && (matcher = Pattern.compile("(?:mapper|Can't merge a non object mapping) \\[(.*)\\] (?:of different type, current_type \\[.*\\], merged_type|with an object mapping) \\[.*\\]").matcher(e.getMessage())).matches()) {
                    String msg = Messages.getMessage("This job would cause a mapping clash with existing field [{0}] - avoid the clash by assigning a dedicated results index", matcher.group(1));
                    actionListener.onFailure((Exception)ExceptionsHelper.badRequestException(msg, e, new Object[0]));
                    return;
                }
                actionListener.onFailure(e);
            }
        };
        ActionListener checkForLeftOverDocs = ActionListener.wrap(arg_0 -> this.lambda$putJob$0(job, state, (ActionListener)putJobListener, arg_0), arg_0 -> actionListener.onFailure(arg_0));
        this.jobProvider.checkForLeftOverDocuments(job, (ActionListener<Boolean>)checkForLeftOverDocs);
    }

    public void updateJob(String jobId, JobUpdate jobUpdate, AckedRequest request, ActionListener<PutJobAction.Response> actionListener) {
        Job job = this.getJobOrThrowIfUnknown(jobId);
        this.validate(jobUpdate, job, isValid -> {
            if (isValid.booleanValue()) {
                this.internalJobUpdate(jobId, jobUpdate, request, actionListener);
            } else {
                actionListener.onFailure((Exception)new IllegalArgumentException("Invalid update to job [" + jobId + "]"));
            }
        }, arg_0 -> actionListener.onFailure(arg_0));
    }

    private void validate(JobUpdate jobUpdate, Job job, Consumer<Boolean> handler, Consumer<Exception> errorHandler) {
        if (jobUpdate.getModelSnapshotId() != null) {
            this.jobProvider.getModelSnapshot(job.getId(), jobUpdate.getModelSnapshotId(), newModelSnapshot -> {
                if (newModelSnapshot == null) {
                    String message = Messages.getMessage("No model snapshot with id [{0}] exists for job [{1}]", jobUpdate.getModelSnapshotId(), job.getId());
                    errorHandler.accept((Exception)new ResourceNotFoundException(message, new Object[0]));
                }
                this.jobProvider.getModelSnapshot(job.getId(), job.getModelSnapshotId(), oldModelSnapshot -> {
                    if (oldModelSnapshot != null && ((ModelSnapshot)((Object)((Object)((Object)newModelSnapshot.result)))).getTimestamp().before(((ModelSnapshot)((Object)((Object)((Object)oldModelSnapshot.result)))).getTimestamp())) {
                        String message = "Job [" + job.getId() + "] has a more recent model snapshot [" + ((ModelSnapshot)((Object)((Object)((Object)oldModelSnapshot.result)))).getSnapshotId() + "]";
                        errorHandler.accept(new IllegalArgumentException(message));
                    }
                    handler.accept(true);
                }, errorHandler);
            }, errorHandler);
        } else {
            handler.accept(true);
        }
    }

    private void internalJobUpdate(final String jobId, final JobUpdate jobUpdate, AckedRequest request, ActionListener<PutJobAction.Response> actionListener) {
        this.clusterService.submitStateUpdateTask("update-job-" + jobId, (ClusterStateTaskConfig)new AckedClusterStateUpdateTask<PutJobAction.Response>(request, actionListener){
            private volatile Job updatedJob;

            protected PutJobAction.Response newResponse(boolean acknowledged) {
                return new PutJobAction.Response(acknowledged, this.updatedJob);
            }

            public ClusterState execute(ClusterState currentState) throws Exception {
                Job job = JobManager.this.getJob(jobId, currentState).results().get(0);
                this.updatedJob = jobUpdate.mergeWithJob(job);
                return JobManager.this.updateClusterState(this.updatedJob, true, currentState);
            }

            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                PersistentTasksCustomMetaData persistentTasks = (PersistentTasksCustomMetaData)newState.metaData().custom("persistent_tasks");
                JobState jobState = MlMetadata.getJobState(jobId, persistentTasks);
                if (jobState == JobState.OPENED) {
                    JobManager.this.updateJobProcessNotifier.submitJobUpdate(jobUpdate);
                }
            }
        });
    }

    ClusterState updateClusterState(Job job, boolean overwrite, ClusterState currentState) {
        MlMetadata.Builder builder = JobManager.createMlMetadataBuilder(currentState);
        builder.putJob(job, overwrite);
        return JobManager.buildNewClusterState(currentState, builder);
    }

    public void deleteJob(DeleteJobAction.Request request, JobStorageDeletionTask task, ActionListener<DeleteJobAction.Response> actionListener) {
        final String jobId = request.getJobId();
        this.logger.debug("Deleting job '" + jobId + "'");
        CheckedConsumer apiResponseHandler = jobDeleted -> {
            if (jobDeleted.booleanValue()) {
                this.logger.info("Job [" + jobId + "] deleted");
                this.auditor.info(jobId, Messages.getMessage("Job deleted"));
                actionListener.onResponse((Object)new DeleteJobAction.Response(true));
            } else {
                actionListener.onResponse((Object)new DeleteJobAction.Response(false));
            }
        };
        CheckedConsumer deleteJobStateHandler = response -> this.clusterService.submitStateUpdateTask("delete-job-" + jobId, (ClusterStateTaskConfig)new AckedClusterStateUpdateTask<Boolean>((AckedRequest)request, ActionListener.wrap((CheckedConsumer)apiResponseHandler, arg_0 -> ((ActionListener)actionListener).onFailure(arg_0))){

            protected Boolean newResponse(boolean acknowledged) {
                return acknowledged && response != false;
            }

            public ClusterState execute(ClusterState currentState) throws Exception {
                MlMetadata currentMlMetadata = (MlMetadata)currentState.metaData().custom("ml");
                if (!currentMlMetadata.getJobs().containsKey(jobId)) {
                    return currentState;
                }
                MlMetadata.Builder builder = new MlMetadata.Builder(currentMlMetadata);
                builder.deleteJob(jobId, (PersistentTasksCustomMetaData)currentState.getMetaData().custom("persistent_tasks"));
                return JobManager.buildNewClusterState(currentState, builder);
            }
        });
        task.delete(jobId, this.client, this.clusterService.state(), (CheckedConsumer<Boolean, Exception>)((CheckedConsumer)arg_0 -> ((CheckedConsumer)deleteJobStateHandler).accept(arg_0)), arg_0 -> actionListener.onFailure(arg_0));
    }

    public void revertSnapshot(final RevertModelSnapshotAction.Request request, final ActionListener<RevertModelSnapshotAction.Response> actionListener, final ModelSnapshot modelSnapshot) {
        JobResultsPersister persister = new JobResultsPersister(this.settings, this.client);
        CheckedConsumer modelSizeStatsResponseHandler = response -> persister.persistQuantiles(modelSnapshot.getQuantiles(), WriteRequest.RefreshPolicy.IMMEDIATE, (ActionListener<IndexResponse>)ActionListener.wrap(quantilesResponse -> {
            ModelSnapshot snapshotWithoutQuantiles = new ModelSnapshot.Builder(modelSnapshot).setQuantiles(null).build();
            actionListener.onResponse((Object)new RevertModelSnapshotAction.Response(snapshotWithoutQuantiles));
        }, arg_0 -> ((ActionListener)actionListener).onFailure(arg_0)));
        CheckedConsumer updateHandler = response -> {
            if (response.booleanValue()) {
                ModelSizeStats revertedModelSizeStats = new ModelSizeStats.Builder(modelSnapshot.getModelSizeStats()).setLogTime(new Date()).build();
                persister.persistModelSizeStats(revertedModelSizeStats, WriteRequest.RefreshPolicy.IMMEDIATE, (ActionListener<IndexResponse>)ActionListener.wrap(arg_0 -> ((CheckedConsumer)modelSizeStatsResponseHandler).accept(arg_0), arg_0 -> ((ActionListener)actionListener).onFailure(arg_0)));
            }
        };
        this.clusterService.submitStateUpdateTask("revert-snapshot-" + request.getJobId(), (ClusterStateTaskConfig)new AckedClusterStateUpdateTask<Boolean>((AckedRequest)request, ActionListener.wrap((CheckedConsumer)updateHandler, arg_0 -> actionListener.onFailure(arg_0))){

            protected Boolean newResponse(boolean acknowledged) {
                if (acknowledged) {
                    JobManager.this.auditor.info(request.getJobId(), Messages.getMessage("Job model snapshot reverted to ''{0}''", modelSnapshot.getDescription()));
                    return true;
                }
                actionListener.onFailure((Exception)new IllegalStateException("Could not revert modelSnapshot on job [" + request.getJobId() + "], not acknowledged by master."));
                return false;
            }

            public ClusterState execute(ClusterState currentState) throws Exception {
                Job job = JobManager.getJobOrThrowIfUnknown(currentState, request.getJobId());
                Job.Builder builder = new Job.Builder(job);
                builder.setModelSnapshotId(modelSnapshot.getSnapshotId());
                return JobManager.this.updateClusterState(builder.build(), true, currentState);
            }
        });
    }

    private static MlMetadata.Builder createMlMetadataBuilder(ClusterState currentState) {
        MlMetadata currentMlMetadata = (MlMetadata)currentState.metaData().custom("ml");
        return new MlMetadata.Builder(currentMlMetadata);
    }

    private static ClusterState buildNewClusterState(ClusterState currentState, MlMetadata.Builder builder) {
        ClusterState.Builder newState = ClusterState.builder((ClusterState)currentState);
        newState.metaData(MetaData.builder((MetaData)currentState.getMetaData()).putCustom("ml", (MetaData.Custom)builder.build()).build());
        return newState.build();
    }

    private /* synthetic */ void lambda$putJob$0(Job job, ClusterState state, ActionListener putJobListener, Boolean response) throws Exception {
        this.jobProvider.createJobResultIndex(job, state, (ActionListener<Boolean>)putJobListener);
    }
}

