/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.datafeed.extractor.aggregation;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.bucket.histogram.Histogram;
import org.elasticsearch.search.aggregations.metrics.NumericMetricsAggregation;
import org.elasticsearch.search.aggregations.metrics.max.Max;
import org.elasticsearch.search.aggregations.metrics.percentiles.Percentile;
import org.elasticsearch.search.aggregations.metrics.percentiles.Percentiles;

class AggregationToJsonProcessor
implements Releasable {
    private final String timeField;
    private final Set<String> fields;
    private final boolean includeDocCount;
    private final XContentBuilder jsonBuilder;
    private final Map<String, Object> keyValuePairs;
    private long keyValueWrittenCount;

    AggregationToJsonProcessor(String timeField, Set<String> fields, boolean includeDocCount, OutputStream outputStream) throws IOException {
        this.timeField = Objects.requireNonNull(timeField);
        this.fields = Objects.requireNonNull(fields);
        this.includeDocCount = includeDocCount;
        this.jsonBuilder = new XContentBuilder((XContent)JsonXContent.jsonXContent, outputStream);
        this.keyValuePairs = new LinkedHashMap<String, Object>();
        this.keyValueWrittenCount = 0L;
    }

    public void process(Histogram.Bucket bucket) throws IOException {
        Aggregation timeAgg;
        if (bucket.getDocCount() == 0L) {
            return;
        }
        Aggregations aggs = bucket.getAggregations();
        Aggregation aggregation = timeAgg = aggs == null ? null : aggs.get(this.timeField);
        if (!(timeAgg instanceof Max)) {
            throw new IllegalArgumentException("Missing max aggregation for time_field [" + this.timeField + "]");
        }
        long timestamp = (long)((Max)timeAgg).value();
        this.keyValuePairs.put(this.timeField, timestamp);
        ArrayList<Aggregation> subAggs = new ArrayList<Aggregation>(aggs.asList());
        subAggs.remove(timeAgg);
        this.processNestedAggs(bucket.getDocCount(), subAggs);
    }

    private void processNestedAggs(long docCount, List<Aggregation> aggs) throws IOException {
        if (aggs.isEmpty()) {
            this.writeJsonObject(docCount);
            return;
        }
        boolean processedBucketAgg = false;
        ArrayList<String> addedLeafKeys = new ArrayList<String>();
        for (Aggregation agg : aggs) {
            if (!this.fields.contains(agg.getName())) continue;
            if (agg instanceof MultiBucketsAggregation) {
                if (processedBucketAgg) {
                    throw new IllegalArgumentException("Multiple bucket aggregations at the same level are not supported");
                }
                if (!addedLeafKeys.isEmpty()) {
                    throw new IllegalArgumentException("Mixing bucket and leaf aggregations at the same level is not supported");
                }
                processedBucketAgg = true;
                this.processBucket((MultiBucketsAggregation)agg);
                continue;
            }
            if (processedBucketAgg) {
                throw new IllegalArgumentException("Mixing bucket and leaf aggregations at the same level is not supported");
            }
            String addedKey = this.processLeaf(agg);
            if (addedKey == null) continue;
            addedLeafKeys.add(addedKey);
        }
        if (!addedLeafKeys.isEmpty()) {
            this.writeJsonObject(docCount);
            addedLeafKeys.forEach(k -> this.keyValuePairs.remove(k));
        }
    }

    private void processBucket(MultiBucketsAggregation bucketAgg) throws IOException {
        for (MultiBucketsAggregation.Bucket bucket : bucketAgg.getBuckets()) {
            this.keyValuePairs.put(bucketAgg.getName(), bucket.getKey());
            this.processNestedAggs(bucket.getDocCount(), AggregationToJsonProcessor.asList(bucket.getAggregations()));
            this.keyValuePairs.remove(bucketAgg.getName());
        }
    }

    @Nullable
    private String processLeaf(Aggregation agg) throws IOException {
        if (agg instanceof NumericMetricsAggregation.SingleValue) {
            return this.processSingleValue((NumericMetricsAggregation.SingleValue)agg);
        }
        if (agg instanceof Percentiles) {
            return this.processPercentiles((Percentiles)agg);
        }
        throw new IllegalArgumentException("Unsupported aggregation type [" + agg.getName() + "]");
    }

    private String processSingleValue(NumericMetricsAggregation.SingleValue singleValue) throws IOException {
        return this.addMetricIfFinite(singleValue.getName(), singleValue.value());
    }

    @Nullable
    private String addMetricIfFinite(String key, double value) {
        if (Double.isFinite(value)) {
            this.keyValuePairs.put(key, value);
            return key;
        }
        return null;
    }

    private String processPercentiles(Percentiles percentiles) throws IOException {
        Iterator percentileIterator = percentiles.iterator();
        String addedKey = this.addMetricIfFinite(percentiles.getName(), ((Percentile)percentileIterator.next()).getValue());
        if (percentileIterator.hasNext()) {
            throw new IllegalArgumentException("Multi-percentile aggregation [" + percentiles.getName() + "] is not supported");
        }
        return addedKey;
    }

    private void writeJsonObject(long docCount) throws IOException {
        if (docCount > 0L) {
            this.jsonBuilder.startObject();
            for (Map.Entry<String, Object> keyValue : this.keyValuePairs.entrySet()) {
                this.jsonBuilder.field(keyValue.getKey(), keyValue.getValue());
                ++this.keyValueWrittenCount;
            }
            if (this.includeDocCount) {
                this.jsonBuilder.field("doc_count", docCount);
                ++this.keyValueWrittenCount;
            }
            this.jsonBuilder.endObject();
        }
    }

    public void close() {
        this.jsonBuilder.close();
    }

    public long getKeyValueCount() {
        return this.keyValueWrittenCount;
    }

    private static List<Aggregation> asList(@Nullable Aggregations aggs) {
        return aggs == null ? Collections.emptyList() : aggs.asList();
    }
}

