/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.datafeed.extractor;

import java.io.IOException;
import java.util.Arrays;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.ShardSearchFailure;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xpack.ml.utils.ExceptionsHelper;

public final class ExtractorUtils {
    private static final Logger LOGGER = Loggers.getLogger(ExtractorUtils.class);
    private static final String EPOCH_MILLIS = "epoch_millis";

    private ExtractorUtils() {
    }

    public static QueryBuilder wrapInTimeRangeQuery(QueryBuilder userQuery, String timeField, long start, long end) {
        RangeQueryBuilder timeQuery = new RangeQueryBuilder(timeField).gte((Object)start).lt((Object)end).format(EPOCH_MILLIS);
        return new BoolQueryBuilder().filter(userQuery).filter((QueryBuilder)timeQuery);
    }

    public static void checkSearchWasSuccessful(String jobId, SearchResponse searchResponse) throws IOException {
        if (searchResponse.status() != RestStatus.OK) {
            throw new IOException("[" + jobId + "] Search request returned status code: " + searchResponse.status() + ". Response was:\n" + searchResponse.toString());
        }
        Object[] shardFailures = searchResponse.getShardFailures();
        if (shardFailures != null && shardFailures.length > 0) {
            LOGGER.error("[{}] Search request returned shard failures: {}", (Object)jobId, (Object)Arrays.toString(shardFailures));
            throw new IOException(ExceptionsHelper.shardFailuresToErrorMsg(jobId, (ShardSearchFailure[])shardFailures));
        }
        int unavailableShards = searchResponse.getTotalShards() - searchResponse.getSuccessfulShards();
        if (unavailableShards > 0) {
            throw new IOException("[" + jobId + "] Search request encountered [" + unavailableShards + "] unavailable shards");
        }
    }
}

