/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.Version;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingAction;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.AliasOrIndex;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.CheckedSupplier;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.Index;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.ml.MachineLearning;
import org.elasticsearch.xpack.ml.MlMetadata;
import org.elasticsearch.xpack.ml.job.config.Job;
import org.elasticsearch.xpack.ml.job.config.JobState;
import org.elasticsearch.xpack.ml.job.config.JobTaskStatus;
import org.elasticsearch.xpack.ml.job.persistence.AnomalyDetectorsIndex;
import org.elasticsearch.xpack.ml.job.persistence.ElasticsearchMappings;
import org.elasticsearch.xpack.ml.job.process.autodetect.AutodetectProcessManager;
import org.elasticsearch.xpack.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.persistent.AllocatedPersistentTask;
import org.elasticsearch.xpack.persistent.PersistentTaskParams;
import org.elasticsearch.xpack.persistent.PersistentTasksCustomMetaData;
import org.elasticsearch.xpack.persistent.PersistentTasksExecutor;
import org.elasticsearch.xpack.persistent.PersistentTasksService;
import org.elasticsearch.xpack.security.InternalClient;

public class OpenJobAction
extends Action<Request, Response, RequestBuilder> {
    public static final OpenJobAction INSTANCE = new OpenJobAction();
    public static final String NAME = "cluster:admin/xpack/ml/job/open";
    public static final String TASK_NAME = "xpack/ml/job";

    private OpenJobAction() {
        super(NAME);
    }

    public RequestBuilder newRequestBuilder(ElasticsearchClient client) {
        return new RequestBuilder(client, this);
    }

    public Response newResponse() {
        return new Response();
    }

    static void validate(String jobId, MlMetadata mlMetadata) {
        Job job;
        Job job2 = job = mlMetadata == null ? null : mlMetadata.getJobs().get(jobId);
        if (job == null) {
            throw ExceptionsHelper.missingJobException(jobId);
        }
        if (job.isDeleted()) {
            throw ExceptionsHelper.conflictStatusException("Cannot open job [" + jobId + "] because it has been marked as deleted", new Object[0]);
        }
        if (job.getJobVersion() == null) {
            throw ExceptionsHelper.badRequestException("Cannot open job [" + jobId + "] because jobs created prior to version 5.5 are not supported", new Object[0]);
        }
    }

    static PersistentTasksCustomMetaData.Assignment selectLeastLoadedMlNode(String jobId, ClusterState clusterState, int maxConcurrentJobAllocations, int fallbackMaxNumberOfOpenJobs, Logger logger) {
        List<String> unavailableIndices = OpenJobAction.verifyIndicesPrimaryShardsAreActive(jobId, clusterState);
        if (unavailableIndices.size() != 0) {
            String reason = "Not opening job [" + jobId + "], because not all primary shards are active for the following indices [" + String.join((CharSequence)",", unavailableIndices) + "]";
            logger.debug(reason);
            return new PersistentTasksCustomMetaData.Assignment(null, reason);
        }
        long maxAvailable = Long.MIN_VALUE;
        LinkedList<String> reasons = new LinkedList<String>();
        DiscoveryNode minLoadedNode = null;
        PersistentTasksCustomMetaData persistentTasks = (PersistentTasksCustomMetaData)clusterState.getMetaData().custom("persistent_tasks");
        for (DiscoveryNode node : clusterState.getNodes()) {
            long available;
            int numberOfAllocatingJobs;
            long numberOfAssignedJobs;
            Map nodeAttributes = node.getAttributes();
            String enabled = (String)nodeAttributes.get("ml.enabled");
            if (!Boolean.valueOf(enabled).booleanValue()) {
                String reason = "Not opening job [" + jobId + "] on node [" + node + "], because this node isn't a ml node.";
                logger.trace(reason);
                reasons.add(reason);
                continue;
            }
            MlMetadata mlMetadata = (MlMetadata)clusterState.getMetaData().custom("ml");
            Job job = mlMetadata.getJobs().get(jobId);
            Set<String> compatibleJobTypes = Job.getCompatibleJobTypes(node.getVersion());
            if (!compatibleJobTypes.contains(job.getJobType())) {
                String reason = "Not opening job [" + jobId + "] on node [" + node + "], because this node does not support jobs of type [" + job.getJobType() + "]";
                logger.trace(reason);
                reasons.add(reason);
                continue;
            }
            if (!OpenJobAction.nodeSupportsJobVersion(node.getVersion(), job.getJobVersion())) {
                String reason = "Not opening job [" + jobId + "] on node [" + node + "], because this node does not support jobs of version [" + job.getJobVersion() + "]";
                logger.trace(reason);
                reasons.add(reason);
                continue;
            }
            if (persistentTasks != null) {
                numberOfAssignedJobs = persistentTasks.getNumberOfTasksOnNode(node.getId(), TASK_NAME);
                numberOfAllocatingJobs = persistentTasks.findTasks(TASK_NAME, task -> {
                    if (!node.getId().equals(task.getExecutorNode())) {
                        return false;
                    }
                    JobTaskStatus jobTaskState = (JobTaskStatus)task.getStatus();
                    return jobTaskState == null || jobTaskState.isStatusStale((PersistentTasksCustomMetaData.PersistentTask<?>)task);
                }).size();
            } else {
                numberOfAssignedJobs = 0L;
                numberOfAllocatingJobs = 0;
            }
            if (numberOfAllocatingJobs >= maxConcurrentJobAllocations) {
                String reason = "Not opening job [" + jobId + "] on node [" + node + "], because node exceeds [" + numberOfAllocatingJobs + "] the maximum number of jobs [" + maxConcurrentJobAllocations + "] in opening state";
                logger.trace(reason);
                reasons.add(reason);
                continue;
            }
            String maxNumberOfOpenJobsStr = (String)nodeAttributes.get("ml.max_open_jobs");
            int maxNumberOfOpenJobs = fallbackMaxNumberOfOpenJobs;
            if (maxNumberOfOpenJobsStr != null) {
                try {
                    maxNumberOfOpenJobs = Integer.parseInt(maxNumberOfOpenJobsStr);
                }
                catch (NumberFormatException e) {
                    String reason = "Not opening job [" + jobId + "] on node [" + node + "], because " + "ml.max_open_jobs" + " attribute [" + maxNumberOfOpenJobsStr + "] is not an integer";
                    logger.trace(reason);
                    reasons.add(reason);
                    continue;
                }
            }
            if ((available = (long)maxNumberOfOpenJobs - numberOfAssignedJobs) == 0L) {
                String reason = "Not opening job [" + jobId + "] on node [" + node + "], because this node is full. Number of opened jobs [" + numberOfAssignedJobs + "], " + AutodetectProcessManager.MAX_RUNNING_JOBS_PER_NODE.getKey() + " [" + maxNumberOfOpenJobs + "]";
                logger.trace(reason);
                reasons.add(reason);
                continue;
            }
            if (maxAvailable >= available) continue;
            maxAvailable = available;
            minLoadedNode = node;
        }
        if (minLoadedNode != null) {
            logger.debug("selected node [{}] for job [{}]", minLoadedNode, (Object)jobId);
            return new PersistentTasksCustomMetaData.Assignment(minLoadedNode.getId(), "");
        }
        String explanation = String.join((CharSequence)"|", reasons);
        logger.debug("no node selected for job [{}], reasons [{}]", (Object)jobId, (Object)explanation);
        return new PersistentTasksCustomMetaData.Assignment(null, explanation);
    }

    static String[] indicesOfInterest(ClusterState clusterState, String job) {
        String jobResultIndex = AnomalyDetectorsIndex.getPhysicalIndexFromState(clusterState, job);
        return new String[]{AnomalyDetectorsIndex.jobStateIndexName(), jobResultIndex, ".ml-meta"};
    }

    static List<String> verifyIndicesPrimaryShardsAreActive(String jobId, ClusterState clusterState) {
        String[] indices = OpenJobAction.indicesOfInterest(clusterState, jobId);
        ArrayList<String> unavailableIndices = new ArrayList<String>(indices.length);
        for (String index : indices) {
            IndexRoutingTable routingTable;
            if (!clusterState.metaData().hasIndex(index) || (routingTable = clusterState.getRoutingTable().index(index)) != null && routingTable.allPrimaryShardsActive()) continue;
            unavailableIndices.add(index);
        }
        return unavailableIndices;
    }

    static boolean nodeSupportsJobVersion(Version nodeVersion, Version jobVersion) {
        return nodeVersion.onOrAfter(Version.V_5_5_0);
    }

    static String[] mappingRequiresUpdate(ClusterState state, String[] concreteIndices, Version minVersion, Logger logger) {
        ArrayList<String> indicesToUpdate = new ArrayList<String>();
        ImmutableOpenMap currentMapping = state.metaData().findMappings(concreteIndices, new String[]{"doc"});
        for (String index : concreteIndices) {
            ImmutableOpenMap innerMap = (ImmutableOpenMap)currentMapping.get((Object)index);
            if (innerMap != null) {
                MappingMetaData metaData = (MappingMetaData)innerMap.get((Object)"doc");
                try {
                    Map meta = (Map)metaData.sourceAsMap().get("_meta");
                    if (meta != null) {
                        String versionString = (String)meta.get("version");
                        if (versionString == null) {
                            logger.info("Version of mappings for [{}] not found, recreating", (Object)index);
                            indicesToUpdate.add(index);
                            continue;
                        }
                        Version mappingVersion = Version.fromString((String)versionString);
                        if (mappingVersion.onOrAfter(minVersion)) continue;
                        logger.info("Mappings for [{}] are outdated [{}], updating it[{}].", (Object)index, (Object)mappingVersion, (Object)Version.CURRENT);
                        indicesToUpdate.add(index);
                        continue;
                    }
                    logger.info("Version of mappings for [{}] not found, recreating", (Object)index);
                    indicesToUpdate.add(index);
                }
                catch (Exception e) {
                    logger.error((Message)new ParameterizedMessage("Failed to retrieve mapping version for [{}], recreating", (Object)index), (Throwable)e);
                    indicesToUpdate.add(index);
                }
                continue;
            }
            logger.info("No mappings found for [{}], recreating", (Object)index);
            indicesToUpdate.add(index);
        }
        return indicesToUpdate.toArray(new String[indicesToUpdate.size()]);
    }

    public static class OpenJobPersistentTasksExecutor
    extends PersistentTasksExecutor<JobParams> {
        private final AutodetectProcessManager autodetectProcessManager;
        private final int fallbackMaxNumberOfOpenJobs;
        private volatile int maxConcurrentJobAllocations;

        public OpenJobPersistentTasksExecutor(Settings settings, ClusterService clusterService, AutodetectProcessManager autodetectProcessManager) {
            super(settings, OpenJobAction.TASK_NAME, "ml_utility");
            this.autodetectProcessManager = autodetectProcessManager;
            this.fallbackMaxNumberOfOpenJobs = (Integer)AutodetectProcessManager.MAX_RUNNING_JOBS_PER_NODE.get(settings);
            this.maxConcurrentJobAllocations = (Integer)MachineLearning.CONCURRENT_JOB_ALLOCATIONS.get(settings);
            clusterService.getClusterSettings().addSettingsUpdateConsumer(MachineLearning.CONCURRENT_JOB_ALLOCATIONS, this::setMaxConcurrentJobAllocations);
        }

        @Override
        public PersistentTasksCustomMetaData.Assignment getAssignment(JobParams params, ClusterState clusterState) {
            return OpenJobAction.selectLeastLoadedMlNode(params.getJobId(), clusterState, this.maxConcurrentJobAllocations, this.fallbackMaxNumberOfOpenJobs, this.logger);
        }

        @Override
        public void validate(JobParams params, ClusterState clusterState) {
            MlMetadata mlMetadata = (MlMetadata)clusterState.metaData().custom("ml");
            OpenJobAction.validate(params.getJobId(), mlMetadata);
            PersistentTasksCustomMetaData.Assignment assignment = OpenJobAction.selectLeastLoadedMlNode(params.getJobId(), clusterState, this.maxConcurrentJobAllocations, this.fallbackMaxNumberOfOpenJobs, this.logger);
            if (assignment.getExecutorNode() == null) {
                String msg = "Could not open job because no suitable nodes were found, allocation explanation [" + assignment.getExplanation() + "]";
                this.logger.warn("[{}] {}", (Object)params.getJobId(), (Object)msg);
                throw new ElasticsearchStatusException(msg, RestStatus.TOO_MANY_REQUESTS, new Object[0]);
            }
        }

        @Override
        protected void nodeOperation(AllocatedPersistentTask task, JobParams params) {
            JobTask jobTask = (JobTask)task;
            jobTask.autodetectProcessManager = this.autodetectProcessManager;
            this.autodetectProcessManager.openJob(jobTask, e2 -> {
                if (e2 == null) {
                    task.markAsCompleted();
                } else {
                    task.markAsFailed((Exception)e2);
                }
            });
        }

        @Override
        protected AllocatedPersistentTask createTask(long id, String type, String action, TaskId parentTaskId, PersistentTasksCustomMetaData.PersistentTask<JobParams> persistentTask) {
            return new JobTask(persistentTask.getParams().getJobId(), id, type, action, parentTaskId);
        }

        void setMaxConcurrentJobAllocations(int maxConcurrentJobAllocations) {
            this.logger.info("Changing [{}] from [{}] to [{}]", (Object)MachineLearning.CONCURRENT_JOB_ALLOCATIONS.getKey(), (Object)this.maxConcurrentJobAllocations, (Object)maxConcurrentJobAllocations);
            this.maxConcurrentJobAllocations = maxConcurrentJobAllocations;
        }
    }

    public static class TransportAction
    extends TransportMasterNodeAction<Request, Response> {
        private final XPackLicenseState licenseState;
        private final PersistentTasksService persistentTasksService;
        private final InternalClient client;

        @Inject
        public TransportAction(Settings settings, TransportService transportService, ThreadPool threadPool, XPackLicenseState licenseState, ClusterService clusterService, PersistentTasksService persistentTasksService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, InternalClient client) {
            super(settings, OpenJobAction.NAME, transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, Request::new);
            this.licenseState = licenseState;
            this.persistentTasksService = persistentTasksService;
            this.client = client;
        }

        protected String executor() {
            return "same";
        }

        protected Response newResponse() {
            return new Response();
        }

        protected ClusterBlockException checkBlock(Request request, ClusterState state) {
            return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
        }

        protected void masterOperation(Request request, ClusterState state, final ActionListener<Response> listener) throws Exception {
            final JobParams jobParams = request.getJobParams();
            if (this.licenseState.isMachineLearningAllowed()) {
                ActionListener<PersistentTasksCustomMetaData.PersistentTask<JobParams>> finalListener = new ActionListener<PersistentTasksCustomMetaData.PersistentTask<JobParams>>(){

                    public void onResponse(PersistentTasksCustomMetaData.PersistentTask<JobParams> task) {
                        this.waitForJobStarted(task.getId(), jobParams, (ActionListener<Response>)listener);
                    }

                    public void onFailure(Exception e) {
                        if (e instanceof ResourceAlreadyExistsException) {
                            e = new ElasticsearchStatusException("Cannot open job [" + jobParams.getJobId() + "] because it has already been opened", RestStatus.CONFLICT, (Throwable)e, new Object[0]);
                        }
                        listener.onFailure(e);
                    }
                };
                ActionListener missingMappingsListener = ActionListener.wrap(arg_0 -> this.lambda$masterOperation$0(jobParams, (ActionListener)finalListener, arg_0), arg_0 -> listener.onFailure(arg_0));
                ActionListener resultsPutMappingHandler = ActionListener.wrap(response -> this.addDocMappingIfMissing(AnomalyDetectorsIndex.jobStateIndexName(), (CheckedSupplier<XContentBuilder, IOException>)((CheckedSupplier)ElasticsearchMappings::stateMapping), state, (ActionListener<Boolean>)missingMappingsListener), arg_0 -> listener.onFailure(arg_0));
                this.addDocMappingIfMissing(AnomalyDetectorsIndex.jobResultsAliasedName(jobParams.jobId), (CheckedSupplier<XContentBuilder, IOException>)((CheckedSupplier)ElasticsearchMappings::docMapping), state, (ActionListener<Boolean>)resultsPutMappingHandler);
            } else {
                listener.onFailure((Exception)((Object)LicenseUtils.newComplianceException("ml")));
            }
        }

        void waitForJobStarted(String taskId, final JobParams jobParams, final ActionListener<Response> listener) {
            final JobPredicate predicate = new JobPredicate();
            this.persistentTasksService.waitForPersistentTaskStatus(taskId, predicate, jobParams.timeout, new PersistentTasksService.WaitForPersistentTaskStatusListener<JobParams>(){

                public void onResponse(PersistentTasksCustomMetaData.PersistentTask<JobParams> persistentTask) {
                    if (predicate.exception != null) {
                        listener.onFailure(predicate.exception);
                    } else {
                        listener.onResponse((Object)new Response(predicate.opened));
                    }
                }

                public void onFailure(Exception e) {
                    listener.onFailure(e);
                }

                @Override
                public void onTimeout(TimeValue timeout) {
                    listener.onFailure((Exception)((Object)new ElasticsearchException("Opening job [" + jobParams.getJobId() + "] timed out after [" + timeout + "]", new Object[0])));
                }
            });
        }

        private void addDocMappingIfMissing(String alias, CheckedSupplier<XContentBuilder, IOException> mappingSupplier, ClusterState state, ActionListener<Boolean> listener) {
            AliasOrIndex aliasOrIndex = (AliasOrIndex)state.metaData().getAliasAndIndexLookup().get(alias);
            if (aliasOrIndex == null) {
                listener.onResponse((Object)true);
                return;
            }
            String[] concreteIndices = (String[])aliasOrIndex.getIndices().stream().map(IndexMetaData::getIndex).map(Index::getName).toArray(String[]::new);
            String[] indicesThatRequireAnUpdate = OpenJobAction.mappingRequiresUpdate(state, concreteIndices, Version.CURRENT, this.logger);
            if (indicesThatRequireAnUpdate.length > 0) {
                try (XContentBuilder mapping = (XContentBuilder)mappingSupplier.get();){
                    PutMappingRequest putMappingRequest = new PutMappingRequest(indicesThatRequireAnUpdate);
                    putMappingRequest.type("doc");
                    putMappingRequest.source(mapping);
                    this.client.execute((Action)PutMappingAction.INSTANCE, (ActionRequest)putMappingRequest, ActionListener.wrap(response -> {
                        if (response.isAcknowledged()) {
                            listener.onResponse((Object)true);
                        } else {
                            listener.onFailure((Exception)((Object)new ElasticsearchException("Attempt to put missing mapping in indices " + Arrays.toString(indicesThatRequireAnUpdate) + " was not acknowledged", new Object[0])));
                        }
                    }, arg_0 -> listener.onFailure(arg_0)));
                }
                catch (IOException e) {
                    listener.onFailure((Exception)e);
                }
            } else {
                this.logger.trace("Mappings are uptodate.");
                listener.onResponse((Object)true);
            }
        }

        private /* synthetic */ void lambda$masterOperation$0(JobParams jobParams, ActionListener finalListener, Boolean response) throws Exception {
            this.persistentTasksService.startPersistentTask(MlMetadata.jobTaskId(jobParams.jobId), OpenJobAction.TASK_NAME, jobParams, finalListener);
        }

        private class JobPredicate
        implements Predicate<PersistentTasksCustomMetaData.PersistentTask<?>> {
            private volatile boolean opened;
            private volatile Exception exception;

            private JobPredicate() {
            }

            @Override
            public boolean test(PersistentTasksCustomMetaData.PersistentTask<?> persistentTask) {
                JobState jobState = JobState.CLOSED;
                if (persistentTask != null) {
                    JobTaskStatus jobStateStatus = (JobTaskStatus)persistentTask.getStatus();
                    jobState = jobStateStatus == null ? JobState.OPENING : jobStateStatus.getState();
                }
                switch (jobState) {
                    case OPENING: 
                    case CLOSED: {
                        return false;
                    }
                    case OPENED: {
                        this.opened = true;
                        return true;
                    }
                    case CLOSING: {
                        this.exception = ExceptionsHelper.conflictStatusException("The job has been " + (Object)((Object)JobState.CLOSED) + " while waiting to be " + (Object)((Object)JobState.OPENED), new Object[0]);
                        return true;
                    }
                }
                this.exception = ExceptionsHelper.serverError("Unexpected job state [" + (Object)((Object)jobState) + "] while waiting for job to be " + (Object)((Object)JobState.OPENED));
                return true;
            }
        }
    }

    static class RequestBuilder
    extends ActionRequestBuilder<Request, Response, RequestBuilder> {
        RequestBuilder(ElasticsearchClient client, OpenJobAction action) {
            super(client, (Action)action, (ActionRequest)new Request());
        }
    }

    public static class JobTask
    extends AllocatedPersistentTask {
        private final String jobId;
        private volatile AutodetectProcessManager autodetectProcessManager;

        JobTask(String jobId, long id, String type, String action, TaskId parentTask) {
            super(id, type, action, "job-" + jobId, parentTask);
            this.jobId = jobId;
        }

        public String getJobId() {
            return this.jobId;
        }

        protected void onCancelled() {
            String reason = this.getReasonCancelled();
            this.killJob(reason);
        }

        void killJob(String reason) {
            this.autodetectProcessManager.killProcess(this, false, reason);
        }

        void closeJob(String reason) {
            this.autodetectProcessManager.closeJob(this, false, reason);
        }

        static boolean match(Task task, String expectedJobId) {
            String expectedDescription = "job-" + expectedJobId;
            return task instanceof JobTask && expectedDescription.equals(task.getDescription());
        }
    }

    public static class Response
    extends AcknowledgedResponse {
        public Response() {
        }

        public Response(boolean acknowledged) {
            super(acknowledged);
        }

        public void readFrom(StreamInput in) throws IOException {
            this.readAcknowledged(in);
        }

        public void writeTo(StreamOutput out) throws IOException {
            this.writeAcknowledged(out);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            AcknowledgedResponse that = (AcknowledgedResponse)o;
            return this.isAcknowledged() == that.isAcknowledged();
        }

        public int hashCode() {
            return Objects.hash(this.isAcknowledged());
        }
    }

    public static class JobParams
    implements PersistentTaskParams {
        public static final ParseField IGNORE_DOWNTIME = new ParseField("ignore_downtime", new String[0]);
        public static final ParseField TIMEOUT = new ParseField("timeout", new String[0]);
        public static ObjectParser<JobParams, Void> PARSER = new ObjectParser("xpack/ml/job", JobParams::new);
        private String jobId;
        private TimeValue timeout = MachineLearning.STATE_PERSIST_RESTORE_TIMEOUT;

        public static JobParams fromXContent(XContentParser parser) {
            return JobParams.parseRequest(null, parser);
        }

        public static JobParams parseRequest(String jobId, XContentParser parser) {
            JobParams params = (JobParams)PARSER.apply(parser, null);
            if (jobId != null) {
                params.jobId = jobId;
            }
            return params;
        }

        JobParams() {
        }

        public JobParams(String jobId) {
            this.jobId = ExceptionsHelper.requireNonNull(jobId, Job.ID.getPreferredName());
        }

        public JobParams(StreamInput in) throws IOException {
            this.jobId = in.readString();
            if (in.getVersion().onOrBefore(Version.V_5_5_0)) {
                in.readBoolean();
            }
            this.timeout = TimeValue.timeValueMillis((long)in.readVLong());
        }

        public String getJobId() {
            return this.jobId;
        }

        public void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public TimeValue getTimeout() {
            return this.timeout;
        }

        public void setTimeout(TimeValue timeout) {
            this.timeout = timeout;
        }

        public String getWriteableName() {
            return OpenJobAction.TASK_NAME;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.jobId);
            if (out.getVersion().onOrBefore(Version.V_5_5_0)) {
                out.writeBoolean(true);
            }
            out.writeVLong(this.timeout.millis());
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(Job.ID.getPreferredName(), this.jobId);
            builder.field(TIMEOUT.getPreferredName(), this.timeout.getStringRep());
            builder.endObject();
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.jobId, this.timeout);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            JobParams other = (JobParams)obj;
            return Objects.equals(this.jobId, other.jobId) && Objects.equals(this.timeout, other.timeout);
        }

        public String toString() {
            return Strings.toString((ToXContent)this);
        }

        static {
            PARSER.declareString(JobParams::setJobId, Job.ID);
            PARSER.declareBoolean((p, v) -> {}, IGNORE_DOWNTIME);
            PARSER.declareString((params, val) -> params.setTimeout(TimeValue.parseTimeValue((String)val, (String)TIMEOUT.getPreferredName())), TIMEOUT);
        }
    }

    public static class Request
    extends MasterNodeRequest<Request>
    implements ToXContent {
        private JobParams jobParams;

        public static Request fromXContent(XContentParser parser) {
            return Request.parseRequest(null, parser);
        }

        public static Request parseRequest(String jobId, XContentParser parser) {
            JobParams jobParams = (JobParams)JobParams.PARSER.apply(parser, null);
            if (jobId != null) {
                jobParams.jobId = jobId;
            }
            return new Request(jobParams);
        }

        public Request(JobParams jobParams) {
            this.jobParams = jobParams;
        }

        public Request(String jobId) {
            this.jobParams = new JobParams(jobId);
        }

        public Request(StreamInput in) throws IOException {
            this.readFrom(in);
        }

        Request() {
        }

        public JobParams getJobParams() {
            return this.jobParams;
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.jobParams = new JobParams(in);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.jobParams.writeTo(out);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            this.jobParams.toXContent(builder, params);
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.jobParams);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || obj.getClass() != ((Object)((Object)this)).getClass()) {
                return false;
            }
            Request other = (Request)((Object)obj);
            return Objects.equals(this.jobParams, other.jobParams);
        }

        public String toString() {
            return Strings.toString((ToXContent)this);
        }
    }
}

