/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.MasterNodeOperationRequestBuilder;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.ml.MlMetadata;
import org.elasticsearch.xpack.ml.job.config.Detector;
import org.elasticsearch.xpack.ml.job.config.Job;
import org.elasticsearch.xpack.ml.job.config.MlFilter;
import org.elasticsearch.xpack.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.security.InternalClient;

public class DeleteFilterAction
extends Action<Request, Response, RequestBuilder> {
    public static final DeleteFilterAction INSTANCE = new DeleteFilterAction();
    public static final String NAME = "cluster:admin/xpack/ml/filters/delete";

    private DeleteFilterAction() {
        super(NAME);
    }

    public RequestBuilder newRequestBuilder(ElasticsearchClient client) {
        return new RequestBuilder(client, this);
    }

    public Response newResponse() {
        return new Response();
    }

    public static class TransportAction
    extends HandledTransportAction<Request, Response> {
        private final InternalClient client;
        private final ClusterService clusterService;

        @Inject
        public TransportAction(Settings settings, ThreadPool threadPool, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, ClusterService clusterService, InternalClient client) {
            super(settings, DeleteFilterAction.NAME, threadPool, transportService, actionFilters, indexNameExpressionResolver, Request::new);
            this.clusterService = clusterService;
            this.client = client;
        }

        protected void doExecute(Request request, final ActionListener<Response> listener) {
            final String filterId = request.getFilterId();
            ClusterState state = this.clusterService.state();
            MlMetadata currentMlMetadata = (MlMetadata)state.metaData().custom("ml");
            Map<String, Job> jobs = currentMlMetadata.getJobs();
            ArrayList<String> currentlyUsedBy = new ArrayList<String>();
            block0: for (Job job : jobs.values()) {
                List<Detector> detectors = job.getAnalysisConfig().getDetectors();
                for (Detector detector : detectors) {
                    if (!detector.extractReferencedFilters().contains(filterId)) continue;
                    currentlyUsedBy.add(job.getId());
                    continue block0;
                }
            }
            if (!currentlyUsedBy.isEmpty()) {
                throw ExceptionsHelper.conflictStatusException("Cannot delete filter, currently used by jobs: " + currentlyUsedBy, new Object[0]);
            }
            DeleteRequest deleteRequest = new DeleteRequest(".ml-meta", "doc", MlFilter.documentId(filterId));
            BulkRequestBuilder bulkRequestBuilder = this.client.prepareBulk();
            bulkRequestBuilder.add(deleteRequest);
            bulkRequestBuilder.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            bulkRequestBuilder.execute((ActionListener)new ActionListener<BulkResponse>(){

                public void onResponse(BulkResponse bulkResponse) {
                    if (bulkResponse.getItems()[0].status() == RestStatus.NOT_FOUND) {
                        listener.onFailure((Exception)new ResourceNotFoundException("Could not delete filter with ID [" + filterId + "] because it does not exist", new Object[0]));
                    } else {
                        listener.onResponse((Object)new Response(true));
                    }
                }

                public void onFailure(Exception e) {
                    logger.error("Could not delete filter with ID [" + filterId + "]", (Throwable)e);
                    listener.onFailure((Exception)new IllegalStateException("Could not delete filter with ID [" + filterId + "]", e));
                }
            });
        }
    }

    public static class Response
    extends AcknowledgedResponse {
        public Response(boolean acknowledged) {
            super(acknowledged);
        }

        private Response() {
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.readAcknowledged(in);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.writeAcknowledged(out);
        }
    }

    public static class RequestBuilder
    extends MasterNodeOperationRequestBuilder<Request, Response, RequestBuilder> {
        public RequestBuilder(ElasticsearchClient client, DeleteFilterAction action) {
            super(client, (Action)action, (MasterNodeRequest)new Request());
        }
    }

    public static class Request
    extends AcknowledgedRequest<Request> {
        public static final ParseField FILTER_ID = new ParseField("filter_id", new String[0]);
        private String filterId;

        Request() {
        }

        public Request(String filterId) {
            this.filterId = ExceptionsHelper.requireNonNull(filterId, FILTER_ID.getPreferredName());
        }

        public String getFilterId() {
            return this.filterId;
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.filterId = in.readString();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.filterId);
        }

        public int hashCode() {
            return Objects.hash(this.filterId);
        }

        public boolean equals(Object obj) {
            if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Request other = (Request)((Object)obj);
            return Objects.equals(this.filterId, other.filterId);
        }
    }
}

