/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.trigger.schedule;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.watcher.trigger.schedule.CronnableSchedule;
import org.elasticsearch.xpack.watcher.trigger.schedule.Schedule;
import org.elasticsearch.xpack.watcher.trigger.schedule.support.DayTimes;

public class DailySchedule
extends CronnableSchedule {
    public static final String TYPE = "daily";
    public static final DayTimes[] DEFAULT_TIMES = new DayTimes[]{DayTimes.MIDNIGHT};
    private final DayTimes[] times;

    DailySchedule() {
        this(DEFAULT_TIMES);
    }

    DailySchedule(DayTimes ... times) {
        super(DailySchedule.crons(times));
        this.times = times;
    }

    @Override
    public String type() {
        return TYPE;
    }

    public DayTimes[] times() {
        return this.times;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (params.paramAsBoolean("normalize", false) && this.times.length == 1) {
            builder.field(Parser.AT_FIELD.getPreferredName(), (ToXContent)this.times[0], params);
        } else {
            builder.startArray(Parser.AT_FIELD.getPreferredName());
            for (DayTimes dayTimes : this.times) {
                dayTimes.toXContent(builder, params);
            }
            builder.endArray();
        }
        return builder.endObject();
    }

    public static Builder builder() {
        return new Builder();
    }

    static String[] crons(DayTimes[] times) {
        assert (times.length > 0) : "at least one time must be defined";
        ArrayList<String> crons = new ArrayList<String>(times.length);
        for (DayTimes time : times) {
            crons.add(time.cron());
        }
        return crons.toArray(new String[crons.size()]);
    }

    public static class Builder {
        private Set<DayTimes> times = new HashSet<DayTimes>();

        private Builder() {
        }

        public Builder at(int hour, int minute) {
            this.times.add(new DayTimes(hour, minute));
            return this;
        }

        public Builder atRoundHour(int ... hours) {
            this.times.add(new DayTimes(hours, new int[]{0}));
            return this;
        }

        public Builder atNoon() {
            this.times.add(DayTimes.NOON);
            return this;
        }

        public Builder atMidnight() {
            this.times.add(DayTimes.MIDNIGHT);
            return this;
        }

        public DailySchedule build() {
            return this.times.isEmpty() ? new DailySchedule() : new DailySchedule(this.times.toArray(new DayTimes[this.times.size()]));
        }
    }

    public static class Parser
    implements Schedule.Parser<DailySchedule> {
        static final ParseField AT_FIELD = new ParseField("at", new String[0]);

        @Override
        public String type() {
            return DailySchedule.TYPE;
        }

        @Override
        public DailySchedule parse(XContentParser parser) throws IOException {
            XContentParser.Token token;
            ArrayList<DayTimes> times = new ArrayList<DayTimes>();
            String currentFieldName = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (AT_FIELD.match(currentFieldName)) {
                    if (token != XContentParser.Token.START_ARRAY) {
                        try {
                            times.add(DayTimes.parse(parser, token));
                            continue;
                        }
                        catch (ElasticsearchParseException pe) {
                            throw new ElasticsearchParseException("could not parse [{}] schedule. invalid time value for field [{}] - [{}]", (Throwable)pe, new Object[]{DailySchedule.TYPE, currentFieldName, token});
                        }
                    }
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        try {
                            times.add(DayTimes.parse(parser, token));
                        }
                        catch (ElasticsearchParseException pe) {
                            throw new ElasticsearchParseException("could not parse [{}] schedule. invalid time value for field [{}] - [{}]", (Throwable)pe, new Object[]{DailySchedule.TYPE, currentFieldName, token});
                        }
                    }
                    continue;
                }
                throw new ElasticsearchParseException("could not parse [{}] schedule. unexpected field [{}]", new Object[]{DailySchedule.TYPE, currentFieldName});
            }
            return times.isEmpty() ? new DailySchedule() : new DailySchedule(times.toArray(new DayTimes[times.size()]));
        }
    }
}

