/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ssl;

import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509ExtendedTrustManager;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.env.Environment;
import org.elasticsearch.xpack.ssl.CertUtils;
import org.elasticsearch.xpack.ssl.KeyConfig;

class StoreKeyConfig
extends KeyConfig {
    final String keyStorePath;
    final String keyStorePassword;
    final String keyStoreAlgorithm;
    final String keyPassword;
    final String trustStoreAlgorithm;

    StoreKeyConfig(String keyStorePath, String keyStorePassword, String keyPassword, String keyStoreAlgorithm, String trustStoreAlgorithm) {
        this.keyStorePath = Objects.requireNonNull(keyStorePath, "keystore path must be specified");
        this.keyStorePassword = Objects.requireNonNull(keyStorePassword, "keystore password must be specified");
        this.keyPassword = keyPassword;
        this.keyStoreAlgorithm = keyStoreAlgorithm;
        this.trustStoreAlgorithm = trustStoreAlgorithm;
    }

    /*
     * Exception decompiling
     */
    @Override
    X509ExtendedKeyManager createKeyManager(@Nullable Environment environment) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    X509ExtendedTrustManager createTrustManager(@Nullable Environment environment) {
        try {
            return CertUtils.trustManager(this.keyStorePath, this.keyStorePassword, this.trustStoreAlgorithm, environment);
        }
        catch (Exception e) {
            throw new ElasticsearchException("failed to initialize a TrustManagerFactory", (Throwable)e, new Object[0]);
        }
    }

    @Override
    List<Path> filesToMonitor(@Nullable Environment environment) {
        return Collections.singletonList(CertUtils.resolvePath(this.keyStorePath, environment));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StoreKeyConfig that = (StoreKeyConfig)o;
        if (this.keyStorePath != null ? !this.keyStorePath.equals(that.keyStorePath) : that.keyStorePath != null) {
            return false;
        }
        if (this.keyStorePassword != null ? !this.keyStorePassword.equals(that.keyStorePassword) : that.keyStorePassword != null) {
            return false;
        }
        if (this.keyStoreAlgorithm != null ? !this.keyStoreAlgorithm.equals(that.keyStoreAlgorithm) : that.keyStoreAlgorithm != null) {
            return false;
        }
        if (this.keyPassword != null ? !this.keyPassword.equals(that.keyPassword) : that.keyPassword != null) {
            return false;
        }
        return this.trustStoreAlgorithm != null ? this.trustStoreAlgorithm.equals(that.trustStoreAlgorithm) : that.trustStoreAlgorithm == null;
    }

    @Override
    public int hashCode() {
        int result = this.keyStorePath != null ? this.keyStorePath.hashCode() : 0;
        result = 31 * result + (this.keyStorePassword != null ? this.keyStorePassword.hashCode() : 0);
        result = 31 * result + (this.keyStoreAlgorithm != null ? this.keyStoreAlgorithm.hashCode() : 0);
        result = 31 * result + (this.keyPassword != null ? this.keyPassword.hashCode() : 0);
        result = 31 * result + (this.trustStoreAlgorithm != null ? this.trustStoreAlgorithm.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "keyStorePath=[" + this.keyStorePath + "], keyStoreAlgorithm=[" + this.keyStoreAlgorithm + "], trustStoreAlgorithm=[" + this.trustStoreAlgorithm + "]";
    }
}

