/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ssl;

import java.nio.file.Path;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509ExtendedTrustManager;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.env.Environment;
import org.elasticsearch.xpack.ssl.CertUtils;
import org.elasticsearch.xpack.ssl.KeyConfig;

class PEMKeyConfig
extends KeyConfig {
    private final String keyPath;
    private final String keyPassword;
    private final String certPath;

    PEMKeyConfig(String keyPath, String keyPassword, String certChainPath) {
        this.keyPath = Objects.requireNonNull(keyPath, "key file must be specified");
        this.keyPassword = keyPassword;
        this.certPath = Objects.requireNonNull(certChainPath, "certificate must be specified");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    X509ExtendedKeyManager createKeyManager(@Nullable Environment environment) {
        try {
            PrivateKey privateKey = this.readPrivateKey(CertUtils.resolvePath(this.keyPath, environment));
            Certificate[] certificateChain = CertUtils.readCertificates(Collections.singletonList(this.certPath), environment);
            try (SecureString securedKeyPasswordChars = new SecureString(this.keyPassword == null ? new char[]{} : this.keyPassword.toCharArray());){
                X509ExtendedKeyManager x509ExtendedKeyManager = CertUtils.keyManager(certificateChain, privateKey, securedKeyPasswordChars.getChars());
                return x509ExtendedKeyManager;
            }
        }
        catch (Exception e) {
            throw new ElasticsearchException("failed to initialize a KeyManagerFactory", (Throwable)e, new Object[0]);
        }
    }

    /*
     * Exception decompiling
     */
    private PrivateKey readPrivateKey(Path keyPath) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    X509ExtendedTrustManager createTrustManager(@Nullable Environment environment) {
        try {
            Certificate[] certificates = CertUtils.readCertificates(Collections.singletonList(this.certPath), environment);
            return CertUtils.trustManager(certificates);
        }
        catch (Exception e) {
            throw new ElasticsearchException("failed to initialize a TrustManagerFactory", (Throwable)e, new Object[0]);
        }
    }

    @Override
    List<Path> filesToMonitor(@Nullable Environment environment) {
        ArrayList<Path> paths = new ArrayList<Path>(2);
        paths.add(CertUtils.resolvePath(this.keyPath, environment));
        paths.add(CertUtils.resolvePath(this.certPath, environment));
        return paths;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PEMKeyConfig that = (PEMKeyConfig)o;
        if (this.keyPath != null ? !this.keyPath.equals(that.keyPath) : that.keyPath != null) {
            return false;
        }
        if (this.keyPassword != null ? !this.keyPassword.equals(that.keyPassword) : that.keyPassword != null) {
            return false;
        }
        return this.certPath != null ? this.certPath.equals(that.certPath) : that.certPath == null;
    }

    @Override
    public int hashCode() {
        int result = this.keyPath != null ? this.keyPath.hashCode() : 0;
        result = 31 * result + (this.keyPassword != null ? this.keyPassword.hashCode() : 0);
        result = 31 * result + (this.certPath != null ? this.certPath.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "keyPath=[" + this.keyPath + "], certPaths=[" + this.certPath + "]";
    }

    private /* synthetic */ char[] lambda$readPrivateKey$0(SecureString secureString) {
        if (this.keyPassword == null) {
            return null;
        }
        return secureString.getChars();
    }
}

