/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest.action.role;

import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.xpack.security.action.role.GetRolesResponse;
import org.elasticsearch.xpack.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.security.client.SecurityClient;
import org.elasticsearch.xpack.security.rest.action.SecurityBaseRestHandler;

public class RestGetRolesAction
extends SecurityBaseRestHandler {
    public RestGetRolesAction(Settings settings, RestController controller, XPackLicenseState licenseState) {
        super(settings, licenseState);
        controller.registerHandler(RestRequest.Method.GET, "/_xpack/security/role/", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.GET, "/_xpack/security/role/{name}", (RestHandler)this);
        controller.registerAsDeprecatedHandler(RestRequest.Method.GET, "/_shield/role", (RestHandler)this, "[GET /_shield/role] is deprecated! Use [GET /_xpack/security/role] instead.", this.deprecationLogger);
        controller.registerAsDeprecatedHandler(RestRequest.Method.GET, "/_shield/role/{name}", (RestHandler)this, "[GET /_shield/role/{name}] is deprecated! Use [GET /_xpack/security/role/{name}] instead.", this.deprecationLogger);
    }

    @Override
    public BaseRestHandler.RestChannelConsumer innerPrepareRequest(RestRequest request, NodeClient client) throws IOException {
        final String[] roles = request.paramAsStringArray("name", Strings.EMPTY_ARRAY);
        return channel -> new SecurityClient((ElasticsearchClient)client).prepareGetRoles(roles).execute((ActionListener)new RestBuilderListener<GetRolesResponse>(channel){

            public RestResponse buildResponse(GetRolesResponse response, XContentBuilder builder) throws Exception {
                builder.startObject();
                for (RoleDescriptor role : response.roles()) {
                    builder.field(role.getName(), (ToXContent)role);
                }
                builder.endObject();
                if (roles.length != 0 && response.roles().length == 0) {
                    return new BytesRestResponse(RestStatus.NOT_FOUND, builder);
                }
                return new BytesRestResponse(RestStatus.OK, builder);
            }
        });
    }
}

