/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.ldap.support;

import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPURL;
import com.unboundid.ldap.sdk.ServerSet;
import com.unboundid.util.ssl.HostNameSSLSocketVerifier;
import com.unboundid.util.ssl.SSLSocketVerifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import javax.net.ssl.SSLSocketFactory;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.xpack.security.authc.RealmConfig;
import org.elasticsearch.xpack.security.authc.RealmSettings;
import org.elasticsearch.xpack.security.authc.ldap.support.LdapLoadBalancing;
import org.elasticsearch.xpack.security.authc.ldap.support.LdapSession;
import org.elasticsearch.xpack.ssl.SSLConfigurationSettings;
import org.elasticsearch.xpack.ssl.SSLService;
import org.elasticsearch.xpack.ssl.VerificationMode;

public abstract class SessionFactory {
    public static final String URLS_SETTING = "url";
    public static final String TIMEOUT_TCP_CONNECTION_SETTING = "timeout.tcp_connect";
    public static final String TIMEOUT_TCP_READ_SETTING = "timeout.tcp_read";
    public static final String TIMEOUT_LDAP_SETTING = "timeout.ldap_search";
    public static final String HOSTNAME_VERIFICATION_SETTING = "hostname_verification";
    public static final String FOLLOW_REFERRALS_SETTING = "follow_referrals";
    public static final Setting<Boolean> IGNORE_REFERRAL_ERRORS_SETTING = Setting.boolSetting((String)"ignore_referral_errors", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final TimeValue TIMEOUT_DEFAULT = TimeValue.timeValueSeconds((long)5L);
    private static final Pattern STARTS_WITH_LDAPS = Pattern.compile("^ldaps:.*", 2);
    private static final Pattern STARTS_WITH_LDAP = Pattern.compile("^ldap:.*", 2);
    protected final Logger logger;
    protected final RealmConfig config;
    protected final TimeValue timeout;
    protected final SSLService sslService;
    protected final ServerSet serverSet;
    protected final boolean sslUsed;
    protected final boolean ignoreReferralErrors;

    protected SessionFactory(RealmConfig config, SSLService sslService) {
        this.config = config;
        this.logger = config.logger(this.getClass());
        Settings settings = config.settings();
        TimeValue searchTimeout = settings.getAsTime(TIMEOUT_LDAP_SETTING, TIMEOUT_DEFAULT);
        if (searchTimeout.millis() < 1000L) {
            this.logger.warn("ldap_search timeout [{}] is less than the minimum supported search timeout of 1s. using 1s", (Object)searchTimeout.millis());
            searchTimeout = TimeValue.timeValueSeconds((long)1L);
        }
        this.timeout = searchTimeout;
        this.sslService = sslService;
        LDAPServers ldapServers = this.ldapServers(settings);
        this.serverSet = this.serverSet(config, sslService, ldapServers);
        this.sslUsed = ldapServers.ssl;
        this.ignoreReferralErrors = (Boolean)IGNORE_REFERRAL_ERRORS_SETTING.get(settings);
    }

    public abstract void session(String var1, SecureString var2, ActionListener<LdapSession> var3);

    public boolean supportsUnauthenticatedSession() {
        return false;
    }

    public void unauthenticatedSession(String username, ActionListener<LdapSession> listener) {
        throw new UnsupportedOperationException("unauthenticated sessions are not supported");
    }

    protected static LDAPConnectionOptions connectionOptions(RealmConfig config, SSLService sslService, Logger logger) {
        boolean hostnameVerficationExists;
        Settings realmSettings = config.settings();
        LDAPConnectionOptions options = new LDAPConnectionOptions();
        options.setConnectTimeoutMillis(Math.toIntExact(realmSettings.getAsTime(TIMEOUT_TCP_CONNECTION_SETTING, TIMEOUT_DEFAULT).millis()));
        options.setFollowReferrals(realmSettings.getAsBoolean(FOLLOW_REFERRALS_SETTING, Boolean.valueOf(true)).booleanValue());
        options.setResponseTimeoutMillis(realmSettings.getAsTime(TIMEOUT_TCP_READ_SETTING, TIMEOUT_DEFAULT).millis());
        options.setAllowConcurrentSocketFactoryUse(true);
        SSLConfigurationSettings sslConfigurationSettings = SSLConfigurationSettings.withoutPrefix();
        Settings realmSSLSettings = realmSettings.getByPrefix("ssl.");
        boolean verificationModeExists = sslConfigurationSettings.verificationMode.exists(realmSSLSettings);
        boolean bl = hostnameVerficationExists = realmSettings.get(HOSTNAME_VERIFICATION_SETTING, null) != null;
        if (verificationModeExists && hostnameVerficationExists) {
            throw new IllegalArgumentException("[hostname_verification] and [" + sslConfigurationSettings.verificationMode.getKey() + "] may not be used at the same time");
        }
        if (verificationModeExists) {
            VerificationMode verificationMode = sslService.getVerificationMode(realmSSLSettings, Settings.EMPTY);
            if (verificationMode == VerificationMode.FULL) {
                options.setSSLSocketVerifier((SSLSocketVerifier)new HostNameSSLSocketVerifier(true));
            }
        } else if (hostnameVerficationExists) {
            new DeprecationLogger(logger).deprecated("the setting [{}] has been deprecated and will be removed in a future version. use [{}] instead", new Object[]{RealmSettings.getFullSettingKey(config, HOSTNAME_VERIFICATION_SETTING), RealmSettings.getFullSettingKey(config, "ssl." + sslConfigurationSettings.verificationMode.getKey())});
            if (realmSettings.getAsBoolean(HOSTNAME_VERIFICATION_SETTING, Boolean.valueOf(true)).booleanValue()) {
                options.setSSLSocketVerifier((SSLSocketVerifier)new HostNameSSLSocketVerifier(true));
            }
        } else {
            options.setSSLSocketVerifier((SSLSocketVerifier)new HostNameSSLSocketVerifier(true));
        }
        return options;
    }

    private LDAPServers ldapServers(Settings settings) {
        String[] ldapUrls = settings.getAsArray(URLS_SETTING, this.getDefaultLdapUrls(settings));
        if (ldapUrls == null || ldapUrls.length == 0) {
            throw new IllegalArgumentException("missing required LDAP setting [url]");
        }
        return new LDAPServers(ldapUrls);
    }

    protected String[] getDefaultLdapUrls(Settings settings) {
        return null;
    }

    private ServerSet serverSet(RealmConfig realmConfig, SSLService clientSSLService, LDAPServers ldapServers) {
        Settings settings = realmConfig.settings();
        SSLSocketFactory socketFactory = null;
        if (ldapServers.ssl()) {
            socketFactory = clientSSLService.sslSocketFactory(settings.getByPrefix("ssl."));
            if (settings.getAsBoolean(HOSTNAME_VERIFICATION_SETTING, Boolean.valueOf(true)).booleanValue()) {
                this.logger.debug("using encryption for LDAP connections with hostname verification");
            } else {
                this.logger.debug("using encryption for LDAP connections without hostname verification");
            }
        }
        return LdapLoadBalancing.serverSet(ldapServers.addresses(), ldapServers.ports(), settings, socketFactory, SessionFactory.connectionOptions(realmConfig, this.sslService, this.logger));
    }

    ServerSet getServerSet() {
        return this.serverSet;
    }

    public boolean isSslUsed() {
        return this.sslUsed;
    }

    protected static Set<Setting<?>> getSettings() {
        HashSet settings = new HashSet();
        settings.addAll(LdapLoadBalancing.getSettings());
        settings.add(Setting.listSetting((String)URLS_SETTING, Collections.emptyList(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(Setting.timeSetting((String)TIMEOUT_TCP_CONNECTION_SETTING, (TimeValue)TIMEOUT_DEFAULT, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(Setting.timeSetting((String)TIMEOUT_TCP_READ_SETTING, (TimeValue)TIMEOUT_DEFAULT, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(Setting.timeSetting((String)TIMEOUT_LDAP_SETTING, (TimeValue)TIMEOUT_DEFAULT, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(Setting.boolSetting((String)HOSTNAME_VERIFICATION_SETTING, (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.boolSetting((String)FOLLOW_REFERRALS_SETTING, (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(IGNORE_REFERRAL_ERRORS_SETTING);
        settings.addAll(SSLConfigurationSettings.withPrefix("ssl.").getAllSettings());
        return settings;
    }

    public static class LDAPServers {
        private final String[] addresses;
        private final int[] ports;
        private final boolean ssl;

        public LDAPServers(String[] urls) {
            this.ssl = this.secureUrls(urls);
            this.addresses = new String[urls.length];
            this.ports = new int[urls.length];
            for (int i = 0; i < urls.length; ++i) {
                try {
                    LDAPURL url = new LDAPURL(urls[i]);
                    this.addresses[i] = url.getHost();
                    this.ports[i] = url.getPort();
                    continue;
                }
                catch (LDAPException e) {
                    throw new IllegalArgumentException("unable to parse configured LDAP url [" + urls[i] + "]", e);
                }
            }
        }

        public String[] addresses() {
            return this.addresses;
        }

        public int[] ports() {
            return this.ports;
        }

        public boolean ssl() {
            return this.ssl;
        }

        private boolean secureUrls(String[] ldapUrls) {
            if (ldapUrls.length == 0) {
                return true;
            }
            boolean allSecure = Arrays.stream(ldapUrls).allMatch(s -> STARTS_WITH_LDAPS.matcher((CharSequence)s).find());
            boolean allClear = Arrays.stream(ldapUrls).allMatch(s -> STARTS_WITH_LDAP.matcher((CharSequence)s).find());
            if (!allSecure && !allClear) {
                throw new IllegalArgumentException("configured LDAP protocols are not all equal (ldaps://.. and ldap://..): [" + Strings.arrayToCommaDelimitedString((Object[])ldapUrls) + "]");
            }
            return allSecure;
        }
    }
}

