/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.esnative;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.GroupedActionListener;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.update.UpdateRequestBuilder;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.client.Requests;
import org.elasticsearch.common.inject.internal.Nullable;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.xpack.security.InternalClient;
import org.elasticsearch.xpack.security.authc.esnative.ReservedRealm;
import org.elasticsearch.xpack.security.authc.support.Hasher;
import org.elasticsearch.xpack.security.client.SecurityClient;
import org.elasticsearch.xpack.security.support.IndexLifecycleManager;
import org.elasticsearch.xpack.security.user.LogstashSystemUser;
import org.elasticsearch.xpack.security.user.User;

public class NativeRealmMigrator
implements IndexLifecycleManager.IndexDataMigrator {
    private final XPackLicenseState licenseState;
    private final Logger logger;
    private InternalClient client;

    public NativeRealmMigrator(Settings settings, XPackLicenseState licenseState, InternalClient internalClient) {
        this.licenseState = licenseState;
        this.logger = Loggers.getLogger(this.getClass(), (Settings)settings, (String[])new String[0]);
        this.client = internalClient;
    }

    @Override
    public void performUpgrade(@Nullable Version previousVersion, ActionListener<Boolean> listener) {
        try {
            List<BiConsumer<Version, ActionListener<Void>>> tasks = this.collectUpgradeTasks(previousVersion);
            if (tasks.isEmpty()) {
                listener.onResponse((Object)false);
            } else {
                GroupedActionListener countDownListener = new GroupedActionListener(ActionListener.wrap(r -> listener.onResponse((Object)true), arg_0 -> listener.onFailure(arg_0)), tasks.size(), Collections.emptyList());
                this.logger.info("Performing {} security migration task(s) from version {}", (Object)tasks.size(), (Object)previousVersion);
                tasks.forEach(t -> t.accept(previousVersion, countDownListener));
            }
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    private List<BiConsumer<Version, ActionListener<Void>>> collectUpgradeTasks(@Nullable Version previousVersion) {
        ArrayList<BiConsumer<Version, ActionListener<Void>>> tasks = new ArrayList<BiConsumer<Version, ActionListener<Void>>>();
        if (this.shouldDisableLogstashUser(previousVersion)) {
            tasks.add(this::createLogstashUserAsDisabled);
        }
        if (this.shouldConvertDefaultPasswords(previousVersion)) {
            tasks.add(this::doConvertDefaultPasswords);
        }
        return tasks;
    }

    private boolean shouldDisableLogstashUser(@Nullable Version previousVersion) {
        return previousVersion != null && previousVersion.before(LogstashSystemUser.DEFINED_SINCE) && previousVersion.onOrAfter(Version.V_5_0_0);
    }

    private void createLogstashUserAsDisabled(@Nullable Version previousVersion, ActionListener<Void> listener) {
        this.logger.info("Upgrading security from version [{}] - new reserved user [{}] will default to disabled", (Object)previousVersion, (Object)"logstash_system");
        boolean clearCache = this.licenseState.isAuthAllowed();
        this.client.prepareGet(".security", "reserved-user", "logstash_system").execute(ActionListener.wrap(getResponse -> {
            if (getResponse.isExists()) {
                listener.onResponse(null);
            } else {
                this.client.prepareIndex(".security", "reserved-user", "logstash_system").setSource(Requests.INDEX_CONTENT_TYPE, new Object[]{User.Fields.ENABLED.getPreferredName(), false, User.Fields.PASSWORD.getPreferredName(), ""}).setCreate(true).execute(ActionListener.wrap(r -> {
                    if (clearCache) {
                        new SecurityClient((ElasticsearchClient)this.client).prepareClearRealmCache().usernames("logstash_system").execute(ActionListener.wrap(re -> listener.onResponse(null), arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
                    } else {
                        listener.onResponse(null);
                    }
                }, arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private boolean shouldConvertDefaultPasswords(@Nullable Version previousVersion) {
        return previousVersion != null && previousVersion.onOrAfter(Version.V_5_0_0) && previousVersion.before(Version.V_5_4_0);
    }

    private void doConvertDefaultPasswords(@Nullable Version previousVersion, ActionListener<Void> listener) {
        this.client.prepareSearch(new String[]{".security"}).setTypes(new String[]{"reserved-user"}).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).setFetchSource(true).execute(ActionListener.wrap(searchResponse -> {
            assert (searchResponse.getHits().getTotalHits() <= 10L) : "there are more than 10 reserved users we need to change this to retrieve them all!";
            HashSet<String> toConvert = new HashSet<String>();
            for (SearchHit searchHit : searchResponse.getHits()) {
                Map sourceMap = searchHit.getSource();
                if (!this.hasOldStyleDefaultPassword(sourceMap)) continue;
                toConvert.add(searchHit.getId());
            }
            if (toConvert.isEmpty()) {
                listener.onResponse(null);
            } else {
                GroupedActionListener countDownListener = new GroupedActionListener(ActionListener.wrap(r -> listener.onResponse(null), arg_0 -> ((ActionListener)listener).onFailure(arg_0)), toConvert.size(), Collections.emptyList());
                toConvert.forEach(username -> {
                    this.logger.debug("Upgrading security from version [{}] - marking reserved user [{}] as having default password", (Object)previousVersion, username);
                    ((UpdateRequestBuilder)this.client.prepareUpdate(".security", "reserved-user", (String)username).setDoc(new Object[]{User.Fields.PASSWORD.getPreferredName(), ""}).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).execute((ActionListener)countDownListener);
                });
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private boolean hasOldStyleDefaultPassword(Map<String, Object> userSource) {
        String passwordHash = (String)userSource.get(User.Fields.PASSWORD.getPreferredName());
        if (passwordHash == null) {
            throw new IllegalStateException("passwordHash should never be null");
        }
        if (passwordHash.isEmpty()) {
            return false;
        }
        try (SecureString secureString = new SecureString(passwordHash.toCharArray());){
            boolean bl = Hasher.BCRYPT.verify(ReservedRealm.DEFAULT_PASSWORD_TEXT, secureString.getChars());
            return bl;
        }
    }
}

