/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.watcher.ResourceWatcherService;
import org.elasticsearch.xpack.security.authc.Realm;
import org.elasticsearch.xpack.security.authc.esnative.NativeRealm;
import org.elasticsearch.xpack.security.authc.esnative.NativeUsersStore;
import org.elasticsearch.xpack.security.authc.file.FileRealm;
import org.elasticsearch.xpack.security.authc.ldap.LdapRealm;
import org.elasticsearch.xpack.security.authc.pki.PkiRealm;
import org.elasticsearch.xpack.security.authc.support.mapper.NativeRoleMappingStore;
import org.elasticsearch.xpack.ssl.SSLService;

public class InternalRealms {
    private static final Set<String> TYPES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("native", "file", "active_directory", "ldap", "pki")));

    public static boolean isInternalRealm(String type, boolean includeReservedRealm) {
        if (TYPES.contains(type)) {
            return true;
        }
        return includeReservedRealm && "reserved".equals(type);
    }

    public static Map<String, Realm.Factory> getFactories(ThreadPool threadPool, ResourceWatcherService resourceWatcherService, SSLService sslService, NativeUsersStore nativeUsersStore, NativeRoleMappingStore nativeRoleMappingStore) {
        HashMap<String, Realm.Factory> map = new HashMap<String, Realm.Factory>();
        map.put("file", config -> new FileRealm(config, resourceWatcherService));
        map.put("native", config -> new NativeRealm(config, nativeUsersStore));
        map.put("active_directory", config -> new LdapRealm("active_directory", config, sslService, resourceWatcherService, nativeRoleMappingStore, threadPool));
        map.put("ldap", config -> new LdapRealm("ldap", config, sslService, resourceWatcherService, nativeRoleMappingStore, threadPool));
        map.put("pki", config -> new PkiRealm(config, resourceWatcherService, nativeRoleMappingStore));
        return Collections.unmodifiableMap(map);
    }

    public static Map<String, Set<Setting<?>>> getSettings() {
        HashMap map = new HashMap();
        map.put("file", FileRealm.getSettings());
        map.put("native", NativeRealm.getSettings());
        map.put("active_directory", LdapRealm.getSettings("active_directory"));
        map.put("ldap", LdapRealm.getSettings("ldap"));
        map.put("pki", PkiRealm.getSettings());
        return Collections.unmodifiableMap(map);
    }

    private InternalRealms() {
    }
}

