/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.node.Node;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportMessage;
import org.elasticsearch.xpack.common.IteratingActionListener;
import org.elasticsearch.xpack.security.Security;
import org.elasticsearch.xpack.security.audit.AuditTrail;
import org.elasticsearch.xpack.security.audit.AuditTrailService;
import org.elasticsearch.xpack.security.authc.Authentication;
import org.elasticsearch.xpack.security.authc.AuthenticationFailureHandler;
import org.elasticsearch.xpack.security.authc.AuthenticationToken;
import org.elasticsearch.xpack.security.authc.Realm;
import org.elasticsearch.xpack.security.authc.Realms;
import org.elasticsearch.xpack.security.authc.TokenService;
import org.elasticsearch.xpack.security.authc.UserToken;
import org.elasticsearch.xpack.security.authc.support.UsernamePasswordToken;
import org.elasticsearch.xpack.security.crypto.CryptoService;
import org.elasticsearch.xpack.security.user.AnonymousUser;
import org.elasticsearch.xpack.security.user.User;

public class AuthenticationService
extends AbstractComponent {
    public static final Setting<Boolean> SIGN_USER_HEADER = Setting.boolSetting((String)Security.setting("authc.sign_user_header"), (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Deprecated});
    public static final Setting<Boolean> RUN_AS_ENABLED = Setting.boolSetting((String)Security.setting("authc.run_as.enabled"), (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final String RUN_AS_USER_HEADER = "es-security-runas-user";
    private final Realms realms;
    private final AuditTrail auditTrail;
    private final CryptoService cryptoService;
    private final AuthenticationFailureHandler failureHandler;
    private final ThreadContext threadContext;
    private final String nodeName;
    private final AnonymousUser anonymousUser;
    private final TokenService tokenService;
    private final boolean runAsEnabled;
    private final boolean isAnonymousUserEnabled;
    private final boolean signingEnabled;

    public AuthenticationService(Settings settings, Realms realms, AuditTrailService auditTrail, CryptoService cryptoService, AuthenticationFailureHandler failureHandler, ThreadPool threadPool, AnonymousUser anonymousUser, TokenService tokenService) {
        super(settings);
        this.nodeName = (String)Node.NODE_NAME_SETTING.get(settings);
        this.realms = realms;
        this.auditTrail = auditTrail;
        this.cryptoService = cryptoService;
        this.failureHandler = failureHandler;
        this.threadContext = threadPool.getThreadContext();
        this.anonymousUser = anonymousUser;
        this.runAsEnabled = (Boolean)RUN_AS_ENABLED.get(settings);
        this.isAnonymousUserEnabled = AnonymousUser.isAnonymousEnabled(settings);
        this.signingEnabled = (Boolean)SIGN_USER_HEADER.get(settings);
        this.tokenService = tokenService;
    }

    public void authenticate(RestRequest request, ActionListener<Authentication> authenticationListener) {
        this.createAuthenticator(request, authenticationListener).authenticateAsync();
    }

    public void authenticate(String action, TransportMessage message, User fallbackUser, Version version, ActionListener<Authentication> listener) {
        this.createAuthenticator(action, message, fallbackUser, version, listener).authenticateAsync();
    }

    public void authenticate(String action, TransportMessage message, String username, SecureString password, ActionListener<Authentication> listener) {
        new Authenticator(action, message, null, listener, username, password).authenticateAsync();
    }

    void attachUserIfMissing(User user, Version version) throws IOException {
        Authentication authentication = new Authentication(user, new Authentication.RealmRef("__attach", "__attach", this.nodeName), null);
        authentication.writeToContextIfMissing(this.threadContext, this.cryptoService, this.settings, version, this.signingEnabled);
    }

    Authenticator createAuthenticator(RestRequest request, ActionListener<Authentication> listener) {
        return new Authenticator(request, listener);
    }

    Authenticator createAuthenticator(String action, TransportMessage message, User fallbackUser, Version version, ActionListener<Authentication> listener) {
        return new Authenticator(action, message, fallbackUser, version, listener);
    }

    public static void addSettings(List<Setting<?>> settings) {
        settings.add(SIGN_USER_HEADER);
        settings.add(RUN_AS_ENABLED);
    }

    static class AuditableRestRequest
    extends AuditableRequest {
        private final RestRequest request;

        AuditableRestRequest(AuditTrail auditTrail, AuthenticationFailureHandler failureHandler, ThreadContext threadContext, RestRequest request) {
            super(auditTrail, failureHandler, threadContext);
            this.request = request;
        }

        @Override
        void authenticationSuccess(String realm, User user) {
            this.auditTrail.authenticationSuccess(realm, user, this.request);
        }

        @Override
        void realmAuthenticationFailed(AuthenticationToken token, String realm) {
            this.auditTrail.authenticationFailed(realm, token, this.request);
        }

        @Override
        ElasticsearchSecurityException tamperedRequest() {
            this.auditTrail.tamperedRequest(this.request);
            return new ElasticsearchSecurityException("rest request attempted to inject a user", new Object[0]);
        }

        @Override
        ElasticsearchSecurityException exceptionProcessingRequest(Exception e, @Nullable AuthenticationToken token) {
            if (token != null) {
                this.auditTrail.authenticationFailed(token, this.request);
            } else {
                this.auditTrail.authenticationFailed(this.request);
            }
            return this.failureHandler.exceptionProcessingRequest(this.request, e, this.threadContext);
        }

        @Override
        ElasticsearchSecurityException authenticationFailed(AuthenticationToken token) {
            this.auditTrail.authenticationFailed(token, this.request);
            return this.failureHandler.failedAuthentication(this.request, token, this.threadContext);
        }

        @Override
        ElasticsearchSecurityException anonymousAccessDenied() {
            this.auditTrail.anonymousAccessDenied(this.request);
            return this.failureHandler.missingToken(this.request, this.threadContext);
        }

        @Override
        ElasticsearchSecurityException runAsDenied(User user, AuthenticationToken token) {
            this.auditTrail.runAsDenied(user, this.request);
            return this.failureHandler.failedAuthentication(this.request, token, this.threadContext);
        }

        public String toString() {
            return "rest request uri [" + this.request.uri() + "]";
        }
    }

    static class AuditableTransportRequest
    extends AuditableRequest {
        private final String action;
        private final TransportMessage message;

        AuditableTransportRequest(AuditTrail auditTrail, AuthenticationFailureHandler failureHandler, ThreadContext threadContext, String action, TransportMessage message) {
            super(auditTrail, failureHandler, threadContext);
            this.action = action;
            this.message = message;
        }

        @Override
        void authenticationSuccess(String realm, User user) {
            this.auditTrail.authenticationSuccess(realm, user, this.action, this.message);
        }

        @Override
        void realmAuthenticationFailed(AuthenticationToken token, String realm) {
            this.auditTrail.authenticationFailed(realm, token, this.action, this.message);
        }

        @Override
        ElasticsearchSecurityException tamperedRequest() {
            this.auditTrail.tamperedRequest(this.action, this.message);
            return new ElasticsearchSecurityException("failed to verify signed authentication information", new Object[0]);
        }

        @Override
        ElasticsearchSecurityException exceptionProcessingRequest(Exception e, @Nullable AuthenticationToken token) {
            if (token != null) {
                this.auditTrail.authenticationFailed(token, this.action, this.message);
            } else {
                this.auditTrail.authenticationFailed(this.action, this.message);
            }
            return this.failureHandler.exceptionProcessingRequest(this.message, this.action, e, this.threadContext);
        }

        @Override
        ElasticsearchSecurityException authenticationFailed(AuthenticationToken token) {
            this.auditTrail.authenticationFailed(token, this.action, this.message);
            return this.failureHandler.failedAuthentication(this.message, token, this.action, this.threadContext);
        }

        @Override
        ElasticsearchSecurityException anonymousAccessDenied() {
            this.auditTrail.anonymousAccessDenied(this.action, this.message);
            return this.failureHandler.missingToken(this.message, this.action, this.threadContext);
        }

        @Override
        ElasticsearchSecurityException runAsDenied(User user, AuthenticationToken token) {
            this.auditTrail.runAsDenied(user, this.action, this.message);
            return this.failureHandler.failedAuthentication(this.message, token, this.action, this.threadContext);
        }

        public String toString() {
            return "transport request action [" + this.action + "]";
        }
    }

    static abstract class AuditableRequest {
        final AuditTrail auditTrail;
        final AuthenticationFailureHandler failureHandler;
        final ThreadContext threadContext;

        AuditableRequest(AuditTrail auditTrail, AuthenticationFailureHandler failureHandler, ThreadContext threadContext) {
            this.auditTrail = auditTrail;
            this.failureHandler = failureHandler;
            this.threadContext = threadContext;
        }

        abstract void realmAuthenticationFailed(AuthenticationToken var1, String var2);

        abstract ElasticsearchSecurityException tamperedRequest();

        abstract ElasticsearchSecurityException exceptionProcessingRequest(Exception var1, @Nullable AuthenticationToken var2);

        abstract ElasticsearchSecurityException authenticationFailed(AuthenticationToken var1);

        abstract ElasticsearchSecurityException anonymousAccessDenied();

        abstract ElasticsearchSecurityException runAsDenied(User var1, AuthenticationToken var2);

        abstract void authenticationSuccess(String var1, User var2);
    }

    class Authenticator {
        private final AuditableRequest request;
        private final User fallbackUser;
        private final ActionListener<Authentication> listener;
        private final Version version;
        private Authentication.RealmRef authenticatedBy = null;
        private Authentication.RealmRef lookedupBy = null;
        private AuthenticationToken authenticationToken = null;

        Authenticator(RestRequest request, ActionListener<Authentication> listener) {
            this(new AuditableRestRequest(this$0.auditTrail, this$0.failureHandler, this$0.threadContext, request), null, Version.CURRENT, listener);
        }

        Authenticator(String action, TransportMessage message, User fallbackUser, Version version, ActionListener<Authentication> listener) {
            this(new AuditableTransportRequest(this$0.auditTrail, this$0.failureHandler, this$0.threadContext, action, message), fallbackUser, version, listener);
        }

        Authenticator(String action, TransportMessage message, User fallbackUser, ActionListener<Authentication> listener, String username, SecureString password) {
            this(new AuditableTransportRequest(this$0.auditTrail, this$0.failureHandler, this$0.threadContext, action, message), fallbackUser, Version.CURRENT, listener);
            this.authenticationToken = new UsernamePasswordToken(username, password);
        }

        private Authenticator(AuditableRequest auditableRequest, User fallbackUser, Version version, ActionListener<Authentication> listener) {
            this.request = auditableRequest;
            this.fallbackUser = fallbackUser;
            this.listener = listener;
            this.version = version;
        }

        private void authenticateAsync() {
            this.lookForExistingAuthentication(authentication -> {
                if (authentication != null) {
                    this.listener.onResponse(authentication);
                } else {
                    AuthenticationService.this.tokenService.getAndValidateToken(AuthenticationService.this.threadContext, (ActionListener<UserToken>)ActionListener.wrap(userToken -> {
                        if (userToken != null) {
                            this.writeAuthToContext(userToken.getAuthentication());
                        } else {
                            this.extractToken(this::consumeToken);
                        }
                    }, e -> {
                        if (e instanceof ElasticsearchSecurityException && !AuthenticationService.this.tokenService.isExpiredTokenException((ElasticsearchSecurityException)((Object)((Object)((Object)e))))) {
                            this.request.tamperedRequest();
                        }
                        this.listener.onFailure(e);
                    }));
                }
            });
        }

        private void lookForExistingAuthentication(Consumer<Authentication> authenticationConsumer) {
            Runnable action;
            try {
                Authentication authentication = Authentication.readFromContext(AuthenticationService.this.threadContext, AuthenticationService.this.cryptoService, AuthenticationService.this.settings, this.version, AuthenticationService.this.signingEnabled);
                action = authentication != null && this.request instanceof AuditableRestRequest ? () -> this.listener.onFailure((Exception)((Object)this.request.tamperedRequest())) : () -> authenticationConsumer.accept(authentication);
            }
            catch (Exception e) {
                AuthenticationService.this.logger.error(() -> new ParameterizedMessage("caught exception while trying to read authentication from request [{}]", (Object)this.request), (Throwable)e);
                action = () -> this.listener.onFailure((Exception)((Object)this.request.tamperedRequest()));
            }
            action.run();
        }

        void extractToken(Consumer<AuthenticationToken> consumer) {
            Runnable action;
            block4: {
                action = () -> consumer.accept(null);
                try {
                    if (this.authenticationToken != null) {
                        action = () -> consumer.accept(this.authenticationToken);
                        break block4;
                    }
                    for (Realm realm : AuthenticationService.this.realms) {
                        AuthenticationToken token = realm.token(AuthenticationService.this.threadContext);
                        if (token == null) continue;
                        action = () -> consumer.accept(token);
                        break;
                    }
                }
                catch (Exception e) {
                    action = () -> this.listener.onFailure((Exception)((Object)this.request.exceptionProcessingRequest(e, null)));
                }
            }
            action.run();
        }

        private void consumeToken(AuthenticationToken token) {
            if (token == null) {
                this.handleNullToken();
            } else {
                this.authenticationToken = token;
                List<Realm> realmsList = AuthenticationService.this.realms.asList();
                BiConsumer<Realm, ActionListener> realmAuthenticatingConsumer = (realm, userListener) -> {
                    if (realm.supports(this.authenticationToken)) {
                        realm.authenticate(this.authenticationToken, (ActionListener<User>)ActionListener.wrap(user -> {
                            if (user == null) {
                                this.request.realmAuthenticationFailed(this.authenticationToken, realm.name());
                            } else {
                                this.authenticatedBy = new Authentication.RealmRef(realm.name(), realm.type(), AuthenticationService.this.nodeName);
                            }
                            userListener.onResponse(user);
                        }, ex -> {
                            AuthenticationService.this.logger.warn("An error occurred while attempting to authenticate [{}] against realm [{}] - {}", (Object)this.authenticationToken.principal(), (Object)realm.name(), ex);
                            AuthenticationService.this.logger.debug("Authentication failed due to exception", (Throwable)ex);
                            userListener.onFailure(ex);
                        }));
                    } else {
                        userListener.onResponse(null);
                    }
                };
                IteratingActionListener authenticatingListener = new IteratingActionListener(ActionListener.wrap(this::consumeUser, e -> this.listener.onFailure((Exception)((Object)this.request.exceptionProcessingRequest((Exception)e, token)))), realmAuthenticatingConsumer, realmsList, AuthenticationService.this.threadContext);
                try {
                    authenticatingListener.run();
                }
                catch (Exception e2) {
                    this.listener.onFailure((Exception)((Object)this.request.exceptionProcessingRequest(e2, token)));
                }
            }
        }

        void handleNullToken() {
            Authentication authentication;
            Authentication.RealmRef authenticatedBy;
            if (this.fallbackUser != null) {
                authenticatedBy = new Authentication.RealmRef("__fallback", "__fallback", AuthenticationService.this.nodeName);
                authentication = new Authentication(this.fallbackUser, authenticatedBy, null);
            } else if (AuthenticationService.this.isAnonymousUserEnabled) {
                authenticatedBy = new Authentication.RealmRef("__anonymous", "__anonymous", AuthenticationService.this.nodeName);
                authentication = new Authentication(AuthenticationService.this.anonymousUser, authenticatedBy, null);
            } else {
                authentication = null;
            }
            Runnable action = authentication != null ? () -> this.writeAuthToContext(authentication) : () -> this.listener.onFailure((Exception)((Object)this.request.anonymousAccessDenied()));
            action.run();
        }

        private void consumeUser(User user) {
            if (user == null) {
                Map<Realm, Tuple<String, Exception>> failureDetails = Realm.getAuthenticationFailureDetails(AuthenticationService.this.threadContext);
                failureDetails.forEach((realm, tuple) -> {
                    String message = (String)tuple.v1();
                    String cause = tuple.v2() == null ? "" : " (Caused by " + tuple.v2() + ")";
                    AuthenticationService.this.logger.warn("Authentication to realm {} failed - {}{}", (Object)realm.name(), (Object)message, (Object)cause);
                });
                this.listener.onFailure((Exception)((Object)this.request.authenticationFailed(this.authenticationToken)));
            } else if (AuthenticationService.this.runAsEnabled) {
                String runAsUsername = AuthenticationService.this.threadContext.getHeader(AuthenticationService.RUN_AS_USER_HEADER);
                if (runAsUsername != null && !runAsUsername.isEmpty()) {
                    this.lookupRunAsUser(user, runAsUsername, this::finishAuthentication);
                } else if (runAsUsername == null) {
                    this.finishAuthentication(user);
                } else {
                    assert (runAsUsername.isEmpty()) : "the run as username may not be empty";
                    AuthenticationService.this.logger.debug("user [{}] attempted to runAs with an empty username", (Object)user.principal());
                    this.listener.onFailure((Exception)((Object)this.request.runAsDenied(new User(runAsUsername, null, user), this.authenticationToken)));
                }
            } else {
                this.finishAuthentication(user);
            }
        }

        private void lookupRunAsUser(User user, String runAsUsername, Consumer<User> userConsumer) {
            List<Realm> realmsList = AuthenticationService.this.realms.asList();
            BiConsumer<Realm, ActionListener> realmLookupConsumer = (realm, lookupUserListener) -> {
                if (realm.userLookupSupported()) {
                    realm.lookupUser(runAsUsername, (ActionListener<User>)ActionListener.wrap(lookedupUser -> {
                        if (lookedupUser != null) {
                            this.lookedupBy = new Authentication.RealmRef(realm.name(), realm.type(), AuthenticationService.this.nodeName);
                            lookupUserListener.onResponse(lookedupUser);
                        } else {
                            lookupUserListener.onResponse(null);
                        }
                    }, arg_0 -> ((ActionListener)lookupUserListener).onFailure(arg_0)));
                } else {
                    lookupUserListener.onResponse(null);
                }
            };
            IteratingActionListener userLookupListener = new IteratingActionListener(ActionListener.wrap(lookupUser -> {
                if (lookupUser == null) {
                    userConsumer.accept(new User(runAsUsername, null, user));
                } else {
                    userConsumer.accept(new User((User)lookupUser, user));
                }
            }, e -> this.listener.onFailure((Exception)((Object)this.request.exceptionProcessingRequest((Exception)e, this.authenticationToken)))), realmLookupConsumer, realmsList, AuthenticationService.this.threadContext);
            try {
                userLookupListener.run();
            }
            catch (Exception e2) {
                this.listener.onFailure((Exception)((Object)this.request.exceptionProcessingRequest(e2, this.authenticationToken)));
            }
        }

        void finishAuthentication(User finalUser) {
            if (!finalUser.enabled() || !finalUser.authenticatedUser().enabled()) {
                AuthenticationService.this.logger.debug("user [{}] is disabled. failing authentication", (Object)finalUser);
                this.listener.onFailure((Exception)((Object)this.request.authenticationFailed(this.authenticationToken)));
            } else {
                Authentication finalAuth = new Authentication(finalUser, this.authenticatedBy, this.lookedupBy);
                this.writeAuthToContext(finalAuth);
            }
        }

        void writeAuthToContext(Authentication authentication) {
            this.request.authenticationSuccess(authentication.getAuthenticatedBy().getName(), authentication.getUser());
            Runnable action = () -> this.listener.onResponse((Object)authentication);
            try {
                authentication.writeToContext(AuthenticationService.this.threadContext, AuthenticationService.this.cryptoService, AuthenticationService.this.settings, Version.CURRENT, AuthenticationService.this.signingEnabled);
            }
            catch (Exception e) {
                action = () -> this.listener.onFailure((Exception)((Object)this.request.exceptionProcessingRequest(e, this.authenticationToken)));
            }
            action.run();
        }
    }
}

