/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.token;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;

public final class CreateTokenResponse
extends ActionResponse
implements ToXContentObject {
    private String tokenString;
    private TimeValue expiresIn;
    private String scope;

    CreateTokenResponse() {
    }

    public CreateTokenResponse(String tokenString, TimeValue expiresIn, String scope) {
        this.tokenString = Objects.requireNonNull(tokenString);
        this.expiresIn = Objects.requireNonNull(expiresIn);
        this.scope = scope;
    }

    public String getTokenString() {
        return this.tokenString;
    }

    public String getScope() {
        return this.scope;
    }

    public TimeValue getExpiresIn() {
        return this.expiresIn;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.tokenString);
        this.expiresIn.writeTo(out);
        out.writeOptionalString(this.scope);
    }

    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.tokenString = in.readString();
        this.expiresIn = new TimeValue(in);
        this.scope = in.readOptionalString();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject().field("access_token", this.tokenString).field("type", "Bearer").field("expires_in", this.expiresIn.seconds());
        if (this.scope != null) {
            builder.field("scope", this.scope);
        }
        return builder.endObject();
    }
}

