/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.token;

import java.io.IOException;
import java.util.Arrays;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.xpack.security.authc.support.CharArrays;

public final class CreateTokenRequest
extends ActionRequest {
    private String grantType;
    private String username;
    private SecureString password;
    private String scope;

    CreateTokenRequest() {
    }

    public CreateTokenRequest(String grantType, String username, SecureString password, @Nullable String scope) {
        this.grantType = grantType;
        this.username = username;
        this.password = password;
        this.scope = scope;
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (!"password".equals(this.grantType)) {
            validationException = ValidateActions.addValidationError((String)"only [password] grant_type is supported", validationException);
        }
        if (Strings.isNullOrEmpty((String)"username")) {
            validationException = ValidateActions.addValidationError((String)"username is missing", (ActionRequestValidationException)validationException);
        }
        if (Strings.isNullOrEmpty((String)"password")) {
            validationException = ValidateActions.addValidationError((String)"password is missing", (ActionRequestValidationException)validationException);
        }
        return validationException;
    }

    public void setGrantType(String grantType) {
        this.grantType = grantType;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(SecureString password) {
        this.password = password;
    }

    public void setScope(@Nullable String scope) {
        this.scope = scope;
    }

    public String getGrantType() {
        return this.grantType;
    }

    public String getUsername() {
        return this.username;
    }

    public SecureString getPassword() {
        return this.password;
    }

    @Nullable
    public String getScope() {
        return this.scope;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.grantType);
        out.writeString(this.username);
        byte[] passwordBytes = CharArrays.toUtf8Bytes(this.password.getChars());
        try {
            out.writeByteArray(passwordBytes);
        }
        finally {
            Arrays.fill(passwordBytes, (byte)0);
        }
        out.writeOptionalString(this.scope);
    }

    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.grantType = in.readString();
        this.username = in.readString();
        byte[] passwordBytes = in.readByteArray();
        try {
            this.password = new SecureString(CharArrays.utf8BytesToChars(passwordBytes));
        }
        finally {
            Arrays.fill(passwordBytes, (byte)0);
        }
        this.scope = in.readOptionalString();
    }
}

