/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.rolemapping;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.support.WriteRequestBuilder;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.xpack.security.action.rolemapping.PutRoleMappingAction;
import org.elasticsearch.xpack.security.action.rolemapping.PutRoleMappingRequest;
import org.elasticsearch.xpack.security.action.rolemapping.PutRoleMappingResponse;
import org.elasticsearch.xpack.security.authc.support.mapper.ExpressionRoleMapping;
import org.elasticsearch.xpack.security.authc.support.mapper.expressiondsl.RoleMapperExpression;

public class PutRoleMappingRequestBuilder
extends ActionRequestBuilder<PutRoleMappingRequest, PutRoleMappingResponse, PutRoleMappingRequestBuilder>
implements WriteRequestBuilder<PutRoleMappingRequestBuilder> {
    public PutRoleMappingRequestBuilder(ElasticsearchClient client, PutRoleMappingAction action) {
        super(client, (Action)action, (ActionRequest)new PutRoleMappingRequest());
    }

    public PutRoleMappingRequestBuilder source(String name, BytesReference source, XContentType xContentType) throws IOException {
        ExpressionRoleMapping mapping = ExpressionRoleMapping.parse(name, source, xContentType);
        ((PutRoleMappingRequest)this.request).setName(name);
        ((PutRoleMappingRequest)this.request).setEnabled(mapping.isEnabled());
        ((PutRoleMappingRequest)this.request).setRoles(mapping.getRoles());
        ((PutRoleMappingRequest)this.request).setRules(mapping.getExpression());
        ((PutRoleMappingRequest)this.request).setMetadata(mapping.getMetadata());
        return this;
    }

    public PutRoleMappingRequestBuilder name(String name) {
        ((PutRoleMappingRequest)this.request).setName(name);
        return this;
    }

    public PutRoleMappingRequestBuilder roles(String ... roles) {
        ((PutRoleMappingRequest)this.request).setRoles(Arrays.asList(roles));
        return this;
    }

    public PutRoleMappingRequestBuilder expression(RoleMapperExpression expression) {
        ((PutRoleMappingRequest)this.request).setRules(expression);
        return this;
    }

    public PutRoleMappingRequestBuilder enabled(boolean enabled) {
        ((PutRoleMappingRequest)this.request).setEnabled(enabled);
        return this;
    }

    public PutRoleMappingRequestBuilder metadata(Map<String, Object> metadata) {
        ((PutRoleMappingRequest)this.request).setMetadata(metadata);
        return this;
    }
}

