/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security;

import org.elasticsearch.bootstrap.BootstrapCheck;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.xpack.XPackSettings;
import org.elasticsearch.xpack.security.authc.TokenService;

final class TokenPassphraseBootstrapCheck
implements BootstrapCheck {
    static final int MINIMUM_PASSPHRASE_LENGTH = 8;
    private final Settings settings;

    TokenPassphraseBootstrapCheck(Settings settings) {
        this.settings = settings;
    }

    public boolean check() {
        if (((Boolean)XPackSettings.TOKEN_SERVICE_ENABLED_SETTING.get(this.settings)).booleanValue()) {
            try (SecureString secureString = (SecureString)TokenService.TOKEN_PASSPHRASE.get(this.settings);){
                boolean bl = secureString.length() < 8 || secureString.equals((Object)"changeme is a terrible password, so let's not use it anymore!");
                return bl;
            }
        }
        return false;
    }

    public String errorMessage() {
        return "Please set a passphrase using the elasticsearch-keystore tool for the setting [" + TokenService.TOKEN_PASSPHRASE.getKey() + "] that is at least " + 8 + " characters in length and does not match the default passphrase or disable the token service using the [" + XPackSettings.TOKEN_SERVICE_ENABLED_SETTING.getKey() + "] setting";
    }
}

