/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.rest.datafeeds;

import java.io.IOException;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.xpack.ml.action.StopDatafeedAction;
import org.elasticsearch.xpack.ml.datafeed.DatafeedConfig;

public class RestStopDatafeedAction
extends BaseRestHandler {
    public RestStopDatafeedAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.POST, "/_xpack/ml/datafeeds/{" + DatafeedConfig.ID.getPreferredName() + "}/_stop", (RestHandler)this);
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        StopDatafeedAction.Request jobDatafeedRequest;
        String datafeedId = restRequest.param(DatafeedConfig.ID.getPreferredName());
        if (restRequest.hasContentOrSourceParam()) {
            XContentParser parser = restRequest.contentOrSourceParamParser();
            jobDatafeedRequest = StopDatafeedAction.Request.parseRequest(datafeedId, parser);
        } else {
            jobDatafeedRequest = new StopDatafeedAction.Request(datafeedId);
            if (restRequest.hasParam(StopDatafeedAction.TIMEOUT.getPreferredName())) {
                TimeValue stopTimeout = restRequest.paramAsTime(StopDatafeedAction.TIMEOUT.getPreferredName(), StopDatafeedAction.DEFAULT_TIMEOUT);
                jobDatafeedRequest.setStopTimeout(stopTimeout);
            }
            if (restRequest.hasParam(StopDatafeedAction.FORCE.getPreferredName())) {
                jobDatafeedRequest.setForce(restRequest.paramAsBoolean(StopDatafeedAction.FORCE.getPreferredName(), false));
            }
        }
        return channel -> client.execute((Action)StopDatafeedAction.INSTANCE, (ActionRequest)jobDatafeedRequest, (ActionListener)new RestBuilderListener<StopDatafeedAction.Response>(channel){

            public RestResponse buildResponse(StopDatafeedAction.Response response, XContentBuilder builder) throws Exception {
                builder.startObject();
                builder.field("stopped", response.isStopped());
                builder.endObject();
                return new BytesRestResponse(RestStatus.OK, builder);
            }
        });
    }
}

