/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.results;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.elasticsearch.Version;
import org.elasticsearch.action.support.ToXContentToBytes;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.ml.job.config.Job;
import org.elasticsearch.xpack.ml.job.results.AnomalyRecord;
import org.elasticsearch.xpack.ml.job.results.BucketInfluencer;
import org.elasticsearch.xpack.ml.job.results.PartitionScore;
import org.elasticsearch.xpack.ml.job.results.Result;
import org.elasticsearch.xpack.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.ml.utils.time.TimeUtils;

public class Bucket
extends ToXContentToBytes
implements Writeable {
    private static final ParseField JOB_ID = Job.ID;
    public static final ParseField ANOMALY_SCORE = new ParseField("anomaly_score", new String[0]);
    public static final ParseField INITIAL_ANOMALY_SCORE = new ParseField("initial_anomaly_score", new String[0]);
    public static final ParseField RECORD_COUNT = new ParseField("record_count", new String[0]);
    public static final ParseField EVENT_COUNT = new ParseField("event_count", new String[0]);
    public static final ParseField RECORDS = new ParseField("records", new String[0]);
    public static final ParseField BUCKET_INFLUENCERS = new ParseField("bucket_influencers", new String[0]);
    public static final ParseField BUCKET_SPAN = new ParseField("bucket_span", new String[0]);
    public static final ParseField PROCESSING_TIME_MS = new ParseField("processing_time_ms", new String[0]);
    public static final ParseField PARTITION_SCORES = new ParseField("partition_scores", new String[0]);
    public static final ParseField RESULTS_FIELD = new ParseField("buckets", new String[0]);
    public static final String RESULT_TYPE_VALUE = "bucket";
    public static final ParseField RESULT_TYPE_FIELD = new ParseField("bucket", new String[0]);
    public static final ConstructingObjectParser<Bucket, Void> PARSER = new ConstructingObjectParser("bucket", a -> new Bucket((String)a[0], (Date)a[1], (Long)a[2]));
    private final String jobId;
    private final Date timestamp;
    private final long bucketSpan;
    private double anomalyScore;
    private double initialAnomalyScore;
    private List<AnomalyRecord> records = new ArrayList<AnomalyRecord>();
    private long eventCount;
    private boolean isInterim;
    private List<BucketInfluencer> bucketInfluencers = new ArrayList<BucketInfluencer>();
    private long processingTimeMs;
    private List<PartitionScore> partitionScores = Collections.emptyList();

    public Bucket(String jobId, Date timestamp, long bucketSpan) {
        this.jobId = jobId;
        this.timestamp = ExceptionsHelper.requireNonNull(timestamp, Result.TIMESTAMP.getPreferredName());
        this.bucketSpan = bucketSpan;
    }

    public Bucket(Bucket other) {
        this.jobId = other.jobId;
        this.timestamp = other.timestamp;
        this.bucketSpan = other.bucketSpan;
        this.anomalyScore = other.anomalyScore;
        this.initialAnomalyScore = other.initialAnomalyScore;
        this.records = new ArrayList<AnomalyRecord>(other.records);
        this.eventCount = other.eventCount;
        this.isInterim = other.isInterim;
        this.bucketInfluencers = new ArrayList<BucketInfluencer>(other.bucketInfluencers);
        this.processingTimeMs = other.processingTimeMs;
        this.partitionScores = new ArrayList<PartitionScore>(other.partitionScores);
    }

    public Bucket(StreamInput in) throws IOException {
        this.jobId = in.readString();
        this.timestamp = new Date(in.readLong());
        this.anomalyScore = in.readDouble();
        this.bucketSpan = in.readLong();
        this.initialAnomalyScore = in.readDouble();
        if (in.getVersion().before(Version.V_5_5_0_UNRELEASED)) {
            in.readInt();
        }
        this.records = in.readList(AnomalyRecord::new);
        this.eventCount = in.readLong();
        this.isInterim = in.readBoolean();
        this.bucketInfluencers = in.readList(BucketInfluencer::new);
        this.processingTimeMs = in.readLong();
        if (in.getVersion().before(Version.V_5_5_0_UNRELEASED)) {
            in.readGenericValue();
        }
        this.partitionScores = in.readList(PartitionScore::new);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.jobId);
        out.writeLong(this.timestamp.getTime());
        out.writeDouble(this.anomalyScore);
        out.writeLong(this.bucketSpan);
        out.writeDouble(this.initialAnomalyScore);
        if (out.getVersion().before(Version.V_5_5_0_UNRELEASED)) {
            out.writeInt(0);
        }
        out.writeList(this.records);
        out.writeLong(this.eventCount);
        out.writeBoolean(this.isInterim);
        out.writeList(this.bucketInfluencers);
        out.writeLong(this.processingTimeMs);
        if (out.getVersion().before(Version.V_5_5_0_UNRELEASED)) {
            out.writeGenericValue(Collections.emptyMap());
        }
        out.writeList(this.partitionScores);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(JOB_ID.getPreferredName(), this.jobId);
        builder.dateField(Result.TIMESTAMP.getPreferredName(), Result.TIMESTAMP.getPreferredName() + "_string", this.timestamp.getTime());
        builder.field(ANOMALY_SCORE.getPreferredName(), this.anomalyScore);
        builder.field(BUCKET_SPAN.getPreferredName(), this.bucketSpan);
        builder.field(INITIAL_ANOMALY_SCORE.getPreferredName(), this.initialAnomalyScore);
        if (!this.records.isEmpty()) {
            builder.field(RECORDS.getPreferredName(), this.records);
        }
        builder.field(EVENT_COUNT.getPreferredName(), this.eventCount);
        builder.field(Result.IS_INTERIM.getPreferredName(), this.isInterim);
        builder.field(BUCKET_INFLUENCERS.getPreferredName(), this.bucketInfluencers);
        builder.field(PROCESSING_TIME_MS.getPreferredName(), this.processingTimeMs);
        if (!this.partitionScores.isEmpty()) {
            builder.field(PARTITION_SCORES.getPreferredName(), this.partitionScores);
        }
        builder.field(Result.RESULT_TYPE.getPreferredName(), RESULT_TYPE_VALUE);
        builder.endObject();
        return builder;
    }

    public String getJobId() {
        return this.jobId;
    }

    public String getId() {
        return this.jobId + "_bucket_" + this.timestamp.getTime() + "_" + this.bucketSpan;
    }

    public long getEpoch() {
        return this.timestamp.getTime() / 1000L;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public long getBucketSpan() {
        return this.bucketSpan;
    }

    public double getAnomalyScore() {
        return this.anomalyScore;
    }

    public void setAnomalyScore(double anomalyScore) {
        this.anomalyScore = anomalyScore;
    }

    public double getInitialAnomalyScore() {
        return this.initialAnomalyScore;
    }

    public void setInitialAnomalyScore(double initialAnomalyScore) {
        this.initialAnomalyScore = initialAnomalyScore;
    }

    public List<AnomalyRecord> getRecords() {
        return this.records;
    }

    public void setRecords(List<AnomalyRecord> records) {
        this.records = Objects.requireNonNull(records);
    }

    public long getEventCount() {
        return this.eventCount;
    }

    public void setEventCount(long value) {
        this.eventCount = value;
    }

    public boolean isInterim() {
        return this.isInterim;
    }

    public void setInterim(boolean isInterim) {
        this.isInterim = isInterim;
    }

    public long getProcessingTimeMs() {
        return this.processingTimeMs;
    }

    public void setProcessingTimeMs(long timeMs) {
        this.processingTimeMs = timeMs;
    }

    public List<BucketInfluencer> getBucketInfluencers() {
        return this.bucketInfluencers;
    }

    public void setBucketInfluencers(List<BucketInfluencer> bucketInfluencers) {
        this.bucketInfluencers = Objects.requireNonNull(bucketInfluencers);
    }

    public void addBucketInfluencer(BucketInfluencer bucketInfluencer) {
        this.bucketInfluencers.add(bucketInfluencer);
    }

    public List<PartitionScore> getPartitionScores() {
        return this.partitionScores;
    }

    public void setPartitionScores(List<PartitionScore> scores) {
        this.partitionScores = Objects.requireNonNull(scores);
    }

    public double partitionInitialAnomalyScore(String partitionValue) {
        Optional<PartitionScore> first = this.partitionScores.stream().filter(s -> partitionValue.equals(s.getPartitionFieldValue())).findFirst();
        return first.isPresent() ? first.get().getInitialRecordScore() : 0.0;
    }

    public double partitionAnomalyScore(String partitionValue) {
        Optional<PartitionScore> first = this.partitionScores.stream().filter(s -> partitionValue.equals(s.getPartitionFieldValue())).findFirst();
        return first.isPresent() ? first.get().getRecordScore() : 0.0;
    }

    public int hashCode() {
        return Objects.hash(this.jobId, this.timestamp, this.eventCount, this.initialAnomalyScore, this.anomalyScore, this.records, this.isInterim, this.bucketSpan, this.bucketInfluencers, this.partitionScores, this.processingTimeMs);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Bucket)) {
            return false;
        }
        Bucket that = (Bucket)((Object)other);
        return Objects.equals(this.jobId, that.jobId) && Objects.equals(this.timestamp, that.timestamp) && this.eventCount == that.eventCount && this.bucketSpan == that.bucketSpan && this.anomalyScore == that.anomalyScore && this.initialAnomalyScore == that.initialAnomalyScore && Objects.equals(this.records, that.records) && Objects.equals(this.isInterim, that.isInterim) && Objects.equals(this.bucketInfluencers, that.bucketInfluencers) && Objects.equals(this.partitionScores, that.partitionScores) && this.processingTimeMs == that.processingTimeMs;
    }

    public boolean isNormalizable() {
        return this.anomalyScore > 0.0 || this.partitionScores.stream().anyMatch(s -> s.getRecordScore() > 0.0);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), JOB_ID);
        PARSER.declareField(ConstructingObjectParser.constructorArg(), p -> {
            if (p.currentToken() == XContentParser.Token.VALUE_NUMBER) {
                return new Date(p.longValue());
            }
            if (p.currentToken() == XContentParser.Token.VALUE_STRING) {
                return new Date(TimeUtils.dateStringToEpoch(p.text()));
            }
            throw new IllegalArgumentException("unexpected token [" + p.currentToken() + "] for [" + Result.TIMESTAMP.getPreferredName() + "]");
        }, Result.TIMESTAMP, ObjectParser.ValueType.VALUE);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), BUCKET_SPAN);
        PARSER.declareDouble(Bucket::setAnomalyScore, ANOMALY_SCORE);
        PARSER.declareDouble(Bucket::setInitialAnomalyScore, INITIAL_ANOMALY_SCORE);
        PARSER.declareBoolean(Bucket::setInterim, Result.IS_INTERIM);
        PARSER.declareLong(Bucket::setEventCount, EVENT_COUNT);
        PARSER.declareObjectArray(Bucket::setRecords, AnomalyRecord.PARSER, RECORDS);
        PARSER.declareObjectArray(Bucket::setBucketInfluencers, BucketInfluencer.PARSER, BUCKET_INFLUENCERS);
        PARSER.declareLong(Bucket::setProcessingTimeMs, PROCESSING_TIME_MS);
        PARSER.declareObjectArray(Bucket::setPartitionScores, PartitionScore.PARSER, PARTITION_SCORES);
        PARSER.declareString((bucket, s) -> {}, Result.RESULT_TYPE);
        PARSER.declareInt((bucket, recordCount) -> {}, RECORD_COUNT);
    }
}

