/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.persistence;

import java.util.List;
import java.util.function.Consumer;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.common.CheckedConsumer;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.query.ConstantScoreQueryBuilder;
import org.elasticsearch.index.query.IdsQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.index.reindex.DeleteByQueryAction;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.rest.action.admin.indices.AliasesNotFoundException;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.xpack.ml.job.config.Job;
import org.elasticsearch.xpack.ml.job.persistence.AnomalyDetectorsIndex;
import org.elasticsearch.xpack.ml.job.persistence.JobDataDeleter;
import org.elasticsearch.xpack.ml.job.persistence.JobProvider;
import org.elasticsearch.xpack.ml.job.process.autodetect.state.CategorizerState;
import org.elasticsearch.xpack.ml.job.process.autodetect.state.ModelSnapshot;
import org.elasticsearch.xpack.ml.job.process.autodetect.state.Quantiles;

public class JobStorageDeletionTask
extends Task {
    private final Logger logger = Loggers.getLogger(((Object)((Object)this)).getClass());

    public JobStorageDeletionTask(long id, String type, String action, String description, TaskId parentTask) {
        super(id, type, action, description, parentTask);
    }

    public void delete(String jobId, Client client, ClusterState state, CheckedConsumer<Boolean, Exception> finishedHandler, Consumer<Exception> failureHandler) {
        String indexName = AnomalyDetectorsIndex.getPhysicalIndexFromState(state, jobId);
        String indexPattern = indexName + "-*";
        ActionListener deleteAliasHandler = ActionListener.wrap(finishedHandler, failureHandler);
        ActionListener dbqHandler = ActionListener.wrap(bulkByScrollResponse -> {
            if (bulkByScrollResponse.isTimedOut()) {
                this.logger.warn("[{}] DeleteByQuery for indices [{}, {}] timed out.", (Object)jobId, (Object)indexName, (Object)indexPattern);
            }
            if (!bulkByScrollResponse.getBulkFailures().isEmpty()) {
                this.logger.warn("[{}] {} failures and {} conflicts encountered while running DeleteByQuery on indices [{}, {}].", (Object)jobId, (Object)bulkByScrollResponse.getBulkFailures().size(), (Object)bulkByScrollResponse.getVersionConflicts(), (Object)indexName, (Object)indexPattern);
                for (BulkItemResponse.Failure failure : bulkByScrollResponse.getBulkFailures()) {
                    this.logger.warn("DBQ failure: " + failure);
                }
            }
            this.deleteAliases(jobId, client, (ActionListener<Boolean>)deleteAliasHandler);
        }, failureHandler);
        ActionListener deleteCategorizerStateHandler = ActionListener.wrap(response -> {
            this.logger.info("Running DBQ on [" + indexName + "," + indexPattern + "] for job [" + jobId + "]");
            SearchRequest searchRequest = new SearchRequest(new String[]{indexName, indexPattern});
            DeleteByQueryRequest request = new DeleteByQueryRequest(searchRequest);
            ConstantScoreQueryBuilder query = new ConstantScoreQueryBuilder((QueryBuilder)new TermQueryBuilder(Job.ID.getPreferredName(), jobId));
            searchRequest.source(new SearchSourceBuilder().query((QueryBuilder)query));
            searchRequest.indicesOptions(JobProvider.addIgnoreUnavailable(IndicesOptions.lenientExpandOpen()));
            request.setSlices(5);
            request.setAbortOnVersionConflict(false);
            request.setRefresh(true);
            client.execute((Action)DeleteByQueryAction.INSTANCE, (ActionRequest)request, dbqHandler);
        }, failureHandler);
        ActionListener deleteQuantilesHandler = ActionListener.wrap(response -> this.deleteCategorizerState(jobId, client, 1, (ActionListener<Boolean>)deleteCategorizerStateHandler), failureHandler);
        ActionListener deleteStateHandler = ActionListener.wrap(bulkResponse -> this.deleteQuantiles(jobId, client, (ActionListener<Boolean>)deleteQuantilesHandler), failureHandler);
        this.deleteModelState(jobId, client, (ActionListener<BulkResponse>)deleteStateHandler);
    }

    private void deleteQuantiles(String jobId, Client client, ActionListener<Boolean> finishedHandler) {
        SearchRequest searchRequest = new SearchRequest(new String[]{AnomalyDetectorsIndex.jobStateIndexName()});
        DeleteByQueryRequest request = new DeleteByQueryRequest(searchRequest);
        IdsQueryBuilder query = new IdsQueryBuilder().addIds(new String[]{Quantiles.documentId(jobId), Quantiles.v54DocumentId(jobId)});
        searchRequest.source(new SearchSourceBuilder().query((QueryBuilder)query));
        searchRequest.indicesOptions(JobProvider.addIgnoreUnavailable(IndicesOptions.lenientExpandOpen()));
        request.setAbortOnVersionConflict(false);
        request.setRefresh(true);
        client.execute((Action)DeleteByQueryAction.INSTANCE, (ActionRequest)request, ActionListener.wrap(response -> finishedHandler.onResponse((Object)true), e -> {
            if (e instanceof IndexNotFoundException) {
                finishedHandler.onResponse((Object)true);
            } else {
                finishedHandler.onFailure(e);
            }
        }));
    }

    private void deleteModelState(String jobId, Client client, ActionListener<BulkResponse> listener) {
        JobProvider jobProvider = new JobProvider(client, Settings.EMPTY);
        jobProvider.modelSnapshots(jobId, 0, 10000, page -> {
            List<ModelSnapshot> deleteCandidates = page.results();
            JobDataDeleter deleter = new JobDataDeleter(client, jobId);
            deleter.deleteModelSnapshots(deleteCandidates, listener);
        }, arg_0 -> listener.onFailure(arg_0));
    }

    private void deleteCategorizerState(String jobId, Client client, int docNum, ActionListener<Boolean> finishedHandler) {
        SearchRequest searchRequest = new SearchRequest(new String[]{AnomalyDetectorsIndex.jobStateIndexName()});
        DeleteByQueryRequest request = new DeleteByQueryRequest(searchRequest);
        IdsQueryBuilder query = new IdsQueryBuilder().addIds(new String[]{CategorizerState.documentId(jobId, docNum), CategorizerState.v54DocumentId(jobId, docNum)});
        searchRequest.source(new SearchSourceBuilder().query((QueryBuilder)query));
        searchRequest.indicesOptions(JobProvider.addIgnoreUnavailable(IndicesOptions.lenientExpandOpen()));
        request.setAbortOnVersionConflict(false);
        request.setRefresh(true);
        client.execute((Action)DeleteByQueryAction.INSTANCE, (ActionRequest)request, ActionListener.wrap(response -> {
            if (response.getDeleted() > 0L) {
                this.deleteCategorizerState(jobId, client, docNum + 1, finishedHandler);
                return;
            }
            finishedHandler.onResponse((Object)true);
        }, e -> {
            if (e instanceof IndexNotFoundException) {
                finishedHandler.onResponse((Object)true);
            } else {
                finishedHandler.onFailure(e);
            }
        }));
    }

    private void deleteAliases(String jobId, Client client, ActionListener<Boolean> finishedHandler) {
        String readAliasName = AnomalyDetectorsIndex.jobResultsAliasedName(jobId);
        String writeAliasName = AnomalyDetectorsIndex.resultsWriteAlias(jobId);
        String indexPattern = AnomalyDetectorsIndex.jobResultsIndexPrefix() + "*";
        IndicesAliasesRequest request = new IndicesAliasesRequest().addAliasAction(IndicesAliasesRequest.AliasActions.remove().aliases(new String[]{readAliasName, writeAliasName}).indices(new String[]{indexPattern}));
        client.admin().indices().aliases(request, ActionListener.wrap(response -> finishedHandler.onResponse((Object)true), e -> {
            if (e instanceof AliasesNotFoundException) {
                this.logger.warn("[{}] Aliases {} not found. Continuing to delete job.", (Object)jobId, (Object)((AliasesNotFoundException)e).getResourceId());
                finishedHandler.onResponse((Object)true);
            } else if (e instanceof IndexNotFoundException) {
                this.logger.warn("[{}] Index [{}] referenced by alias not found. Continuing to delete job.", (Object)jobId, (Object)((IndexNotFoundException)((Object)((Object)e))).getIndex().getName());
                finishedHandler.onResponse((Object)true);
            } else {
                this.logger.error("[" + jobId + "] Failed to delete aliases [" + readAliasName + ", " + writeAliasName + "].", (Throwable)e);
                finishedHandler.onFailure(e);
            }
        }));
    }
}

